package io.fincast.compo.impl

import io.fincast.compo.ValueProvider
import io.fincast.compo.ValueProviders
import io.fincast.compo.base.YieldCompoBase
import io.fincast.enums.BookingKind
import io.fincast.enums.FundsUtilisation
import io.fincast.enums.Periodicity
import io.fincast.holding.Holding

data class InterestCompo(
	override val holding: Holding,
	override val tag: String = "interest",
	override val amount: ValueProvider<Double> = ValueProviders.prevEomBalance(),
	val interestRate: ValueProvider<Double>,
	val interestPeriodicity: Periodicity,
	override val fundsUtilisation: FundsUtilisation
) : YieldCompoBase() {

	override val yieldRate: ValueProvider<Double> = interestRate

	override val yieldPeriodicity: Periodicity = interestPeriodicity

	override val bookingKind: BookingKind = BookingKind.INTEREST

}
