package io.fincast.compo.impl

import io.fincast.compo.ValueProvider
import io.fincast.compo.ValueProviders
import io.fincast.compo.base.YieldCompoBase
import io.fincast.enums.BookingKind
import io.fincast.enums.FundsUtilisation
import io.fincast.enums.Periodicity
import io.fincast.holding.Holding

data class DividendCompo(
	override val holding: Holding,
	val dividendYield: ValueProvider<Double>,
	val dividendPeriodicity: Periodicity,
	override val fundsUtilisation: FundsUtilisation
) : YieldCompoBase() {

	override val tag: String = "dividend"

	override val amount: ValueProvider<Double> = ValueProviders.prevEomBalance()

	override val yieldRate: ValueProvider<Double> = dividendYield

	override val yieldPeriodicity: Periodicity = dividendPeriodicity

	override val bookingKind: BookingKind = BookingKind.DIVIDEND

}
