package io.fincast.compo.impl

import io.fincast.compo.ValueProvider
import io.fincast.compo.ValueProviders
import io.fincast.compo.base.YieldCompoBase
import io.fincast.enums.BookingKind
import io.fincast.enums.FundsUtilisation
import io.fincast.enums.Periodicity
import io.fincast.holding.Holding

data class CapitalGainCompo(
	override val holding: Holding,
	val capitalGainRate: ValueProvider<Double>,
	val capitalGainPeriodicity: Periodicity = Periodicity.YEARLY
) : YieldCompoBase() {

	override val tag: String = "capitalGain"

	override val amount: ValueProvider<Double> = ValueProviders.prevEomBalance()

	override val yieldRate: ValueProvider<Double> = capitalGainRate

	override val yieldPeriodicity: Periodicity = capitalGainPeriodicity

	override val fundsUtilisation: FundsUtilisation = FundsUtilisation.COMPOUND

	override val bookingKind: BookingKind = BookingKind.CAPITAL_GAIN

}
