package io.fincast.compo.base

import io.fincast.compo.FinancialCompo
import io.fincast.compo.ValueProvider
import io.fincast.engine.SimDate
import io.fincast.enums.BookingKind
import io.fincast.enums.FundsUtilisation
import io.fincast.enums.Periodicity

abstract class YieldCompoBase : FinancialCompo {

	abstract val amount: ValueProvider<Double> // eomBalance, eomCreditBalance, eomDebitBalance

	abstract val yieldRate: ValueProvider<Double>

	abstract val yieldPeriodicity: Periodicity

	abstract val bookingKind: BookingKind

	abstract val fundsUtilisation: FundsUtilisation

	private var yield = 0.0

	override fun getYield(): Double {
		return this.yield
	}

	override fun handleLifecycle(date: SimDate) {
		val amount = amount.getValue(this, date)
		val yieldRate = yieldRate.getValue(this, date)
		val yield = (amount ?: 0.0) * (yieldRate ?: 0.0) / 100 / Periodicity.MONTHS_IN_YEAR
		addAccrual(yield)
		if (yieldPeriodicity.isEndOfPeriod(date)) {
			bookYield(date, bookingKind, fundsUtilisation)
		}
	}

	private fun addAccrual(accrual: Double) {
		this.yield += accrual
	}

	private fun bookYield(date: SimDate, bookingKind: BookingKind, fundsUtilisation: FundsUtilisation) {
		val holding = if (fundsUtilisation == FundsUtilisation.COMPOUND) this.holding else household.internalCash
		holding.bookCashflow(date, bookingKind, yield, this.holding, this.tag)
		yield = 0.0
	}

}
