package io.fincast.compo

import kotlin.math.min

object ValueProviders {

	@JvmStatic
	val Zero: ValueProvider<Double> = constValue(0.0)

	private var totalProfit = 0.0
	private var availableProfit = 0.0

	fun setTotalProfit(value: Double) {
		totalProfit = value
	}

	fun setAvailableProfit(value: Double) {
		availableProfit = value
	}

	@JvmStatic
	fun <T> constValue(value: T): ValueProvider<T> {
		return ValueProvider { _, _ ->
			return@ValueProvider value
		}
	}

	@JvmStatic
	fun currentRelativeValue(percentage: Double): ValueProvider<Double> {
		return ValueProvider { compo, date ->
			return@ValueProvider percentage / 100.0 * compo.holding.getBalance(date)
		}
	}

	@JvmStatic
	fun prevEomBalance(): ValueProvider<Double> {
		return ValueProvider { compo, date ->
			return@ValueProvider compo.holding.getBalance(date - 1)
		}
	}

	@JvmStatic
	fun prevEomCreditBalance(): ValueProvider<Double> {
		return ValueProvider { compo, date ->
			val eomBalance = compo.holding.getBalance(date - 1)
			return@ValueProvider eomBalance.coerceAtLeast(0.0)
		}
	}

	@JvmStatic
	fun prevEomDebitBalance(): ValueProvider<Double> {
		return ValueProvider { compo, date ->
			val eomBalance = compo.holding.getBalance(date - 1)
			return@ValueProvider eomBalance.coerceAtMost(0.0)
		}
	}

	@JvmStatic
	fun profitShare(value: Double): ValueProvider<Double> {
		return ValueProvider { _, d ->
			val profit = if (value <= 1.0) value * totalProfit else value
			return@ValueProvider min(profit, availableProfit)
		}
	}

}
