package io.fincast.compo

import io.fincast.engine.SimDate
import io.fincast.holding.Holding
import io.fincast.holding.ProjectionPhase
import io.fincast.household.Household

interface FinancialCompo {

	val holding: Holding

	val tag: String

	val household: Household get() = holding.household

	val projectionPhase: ProjectionPhase get() = ProjectionPhase.LIFECYCLE

	fun getYield(): Double = 0.0

	fun handleLifecycle(date: SimDate) {}

}
