/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.portfolio.impl;

import io.fincast.enums.BookingKind;
import io.fincast.enums.FundsAllocation;
import io.fincast.enums.Periodicity;
import io.fincast.portfolio.Position;
import io.fincast.portfolio.SimDate;
import io.fincast.portfolio.ValueProvider;
import io.fincast.portfolio.impl.PositionCompoBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\t\u0010\"\u001a\u00020\u000bH\u00c6\u0003J\t\u0010#\u001a\u00020\rH\u00c6\u0003J\t\u0010$\u001a\u00020\u000fH\u00c6\u0003J[\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u00c6\u0001J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u00d6\u0003J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\t\u0010.\u001a\u00020/H\u00d6\u0001J\t\u00100\u001a\u00020\u0005H\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0012\u00a8\u00061"}, d2={"Lio/fincast/portfolio/impl/YieldCompo;", "Lio/fincast/portfolio/impl/PositionCompoBase;", "position", "Lio/fincast/portfolio/Position;", "tag", "", "amount", "Lio/fincast/portfolio/ValueProvider;", "", "yieldRate", "yieldPeriodicity", "Lio/fincast/enums/Periodicity;", "bookingKind", "Lio/fincast/enums/BookingKind;", "fundsAllocation", "Lio/fincast/enums/FundsAllocation;", "(Lio/fincast/portfolio/Position;Ljava/lang/String;Lio/fincast/portfolio/ValueProvider;Lio/fincast/portfolio/ValueProvider;Lio/fincast/enums/Periodicity;Lio/fincast/enums/BookingKind;Lio/fincast/enums/FundsAllocation;)V", "getAmount", "()Lio/fincast/portfolio/ValueProvider;", "getBookingKind", "()Lio/fincast/enums/BookingKind;", "getFundsAllocation", "()Lio/fincast/enums/FundsAllocation;", "getPosition", "()Lio/fincast/portfolio/Position;", "getTag", "()Ljava/lang/String;", "getYieldPeriodicity", "()Lio/fincast/enums/Periodicity;", "getYieldRate", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "", "handleLifecycle", "", "date", "Lio/fincast/portfolio/SimDate;", "hashCode", "", "toString", "fincast"})
public final class YieldCompo
extends PositionCompoBase {
    @NotNull
    private final Position position;
    @NotNull
    private final String tag;
    @NotNull
    private final ValueProvider<Double> amount;
    @NotNull
    private final ValueProvider<Double> yieldRate;
    @NotNull
    private final Periodicity yieldPeriodicity;
    @NotNull
    private final BookingKind bookingKind;
    @NotNull
    private final FundsAllocation fundsAllocation;

    public YieldCompo(@NotNull Position position, @NotNull String tag, @NotNull ValueProvider<Double> amount, @NotNull ValueProvider<Double> yieldRate, @NotNull Periodicity yieldPeriodicity, @NotNull BookingKind bookingKind, @NotNull FundsAllocation fundsAllocation) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter(amount, (String)"amount");
        Intrinsics.checkNotNullParameter(yieldRate, (String)"yieldRate");
        Intrinsics.checkNotNullParameter((Object)((Object)yieldPeriodicity), (String)"yieldPeriodicity");
        Intrinsics.checkNotNullParameter((Object)((Object)bookingKind), (String)"bookingKind");
        Intrinsics.checkNotNullParameter((Object)((Object)fundsAllocation), (String)"fundsAllocation");
        this.position = position;
        this.tag = tag;
        this.amount = amount;
        this.yieldRate = yieldRate;
        this.yieldPeriodicity = yieldPeriodicity;
        this.bookingKind = bookingKind;
        this.fundsAllocation = fundsAllocation;
    }

    @Override
    @NotNull
    public Position getPosition() {
        return this.position;
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @NotNull
    public final ValueProvider<Double> getAmount() {
        return this.amount;
    }

    @NotNull
    public final ValueProvider<Double> getYieldRate() {
        return this.yieldRate;
    }

    @NotNull
    public final Periodicity getYieldPeriodicity() {
        return this.yieldPeriodicity;
    }

    @NotNull
    public final BookingKind getBookingKind() {
        return this.bookingKind;
    }

    @NotNull
    public final FundsAllocation getFundsAllocation() {
        return this.fundsAllocation;
    }

    @Override
    public void handleLifecycle(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        double amount = ((Number)this.amount.getValue(date)).doubleValue();
        double yieldRate = ((Number)this.yieldRate.getValue(date)).doubleValue();
        double yield = amount * yieldRate / (double)100 / (double)12;
        this.addYield(yield);
        if (Periodicity.isCashflowDate$default(this.yieldPeriodicity, date, null, null, 6, null)) {
            this.bookYield(date, this.bookingKind, this.fundsAllocation);
        }
    }

    @NotNull
    public final Position component1() {
        return this.position;
    }

    @NotNull
    public final String component2() {
        return this.tag;
    }

    @NotNull
    public final ValueProvider<Double> component3() {
        return this.amount;
    }

    @NotNull
    public final ValueProvider<Double> component4() {
        return this.yieldRate;
    }

    @NotNull
    public final Periodicity component5() {
        return this.yieldPeriodicity;
    }

    @NotNull
    public final BookingKind component6() {
        return this.bookingKind;
    }

    @NotNull
    public final FundsAllocation component7() {
        return this.fundsAllocation;
    }

    @NotNull
    public final YieldCompo copy(@NotNull Position position, @NotNull String tag, @NotNull ValueProvider<Double> amount, @NotNull ValueProvider<Double> yieldRate, @NotNull Periodicity yieldPeriodicity, @NotNull BookingKind bookingKind, @NotNull FundsAllocation fundsAllocation) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter(amount, (String)"amount");
        Intrinsics.checkNotNullParameter(yieldRate, (String)"yieldRate");
        Intrinsics.checkNotNullParameter((Object)((Object)yieldPeriodicity), (String)"yieldPeriodicity");
        Intrinsics.checkNotNullParameter((Object)((Object)bookingKind), (String)"bookingKind");
        Intrinsics.checkNotNullParameter((Object)((Object)fundsAllocation), (String)"fundsAllocation");
        return new YieldCompo(position, tag, amount, yieldRate, yieldPeriodicity, bookingKind, fundsAllocation);
    }

    public static /* synthetic */ YieldCompo copy$default(YieldCompo yieldCompo, Position position, String string, ValueProvider valueProvider, ValueProvider valueProvider2, Periodicity periodicity, BookingKind bookingKind, FundsAllocation fundsAllocation, int n, Object object) {
        if ((n & 1) != 0) {
            position = yieldCompo.position;
        }
        if ((n & 2) != 0) {
            string = yieldCompo.tag;
        }
        if ((n & 4) != 0) {
            valueProvider = yieldCompo.amount;
        }
        if ((n & 8) != 0) {
            valueProvider2 = yieldCompo.yieldRate;
        }
        if ((n & 0x10) != 0) {
            periodicity = yieldCompo.yieldPeriodicity;
        }
        if ((n & 0x20) != 0) {
            bookingKind = yieldCompo.bookingKind;
        }
        if ((n & 0x40) != 0) {
            fundsAllocation = yieldCompo.fundsAllocation;
        }
        return yieldCompo.copy(position, string, valueProvider, valueProvider2, periodicity, bookingKind, fundsAllocation);
    }

    @NotNull
    public String toString() {
        return "YieldCompo(position=" + this.position + ", tag=" + this.tag + ", amount=" + this.amount + ", yieldRate=" + this.yieldRate + ", yieldPeriodicity=" + this.yieldPeriodicity + ", bookingKind=" + this.bookingKind + ", fundsAllocation=" + this.fundsAllocation + ")";
    }

    public int hashCode() {
        int result = this.position.hashCode();
        result = result * 31 + this.tag.hashCode();
        result = result * 31 + this.amount.hashCode();
        result = result * 31 + this.yieldRate.hashCode();
        result = result * 31 + this.yieldPeriodicity.hashCode();
        result = result * 31 + this.bookingKind.hashCode();
        result = result * 31 + this.fundsAllocation.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof YieldCompo)) {
            return false;
        }
        YieldCompo yieldCompo = (YieldCompo)other;
        if (!Intrinsics.areEqual((Object)this.position, (Object)yieldCompo.position)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tag, (Object)yieldCompo.tag)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.amount, yieldCompo.amount)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.yieldRate, yieldCompo.yieldRate)) {
            return false;
        }
        if (this.yieldPeriodicity != yieldCompo.yieldPeriodicity) {
            return false;
        }
        if (this.bookingKind != yieldCompo.bookingKind) {
            return false;
        }
        return this.fundsAllocation == yieldCompo.fundsAllocation;
    }
}

