/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.portfolio.impl;

import io.fincast.enums.Periodicity;
import io.fincast.portfolio.Position;
import io.fincast.portfolio.SimDate;
import io.fincast.portfolio.ValueProvider;
import io.fincast.portfolio.impl.PositionCompoBase;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0012J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010&\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\t\u0010'\u001a\u00020\fH\u00c6\u0003J\t\u0010(\u001a\u00020\u000eH\u00c6\u0003J\u000b\u0010)\u001a\u0004\u0018\u00010\u0010H\u00c6\u0003J\u000b\u0010*\u001a\u0004\u0018\u00010\u0010H\u00c6\u0003Jm\u0010+\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u00c6\u0001J\u0013\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/H\u00d6\u0003J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0010H\u0016J\t\u00103\u001a\u00020\fH\u00d6\u0001J\t\u00104\u001a\u00020\u0005H\u00d6\u0001R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0018\u00a8\u00065"}, d2={"Lio/fincast/portfolio/impl/TransferCompo;", "Lio/fincast/portfolio/impl/PositionCompoBase;", "position", "Lio/fincast/portfolio/Position;", "tag", "", "fromPosition", "toPosition", "amount", "Lio/fincast/portfolio/ValueProvider;", "", "sign", "", "periodicity", "Lio/fincast/enums/Periodicity;", "startDate", "Lio/fincast/portfolio/SimDate;", "endDate", "(Lio/fincast/portfolio/Position;Ljava/lang/String;Lio/fincast/portfolio/Position;Lio/fincast/portfolio/Position;Lio/fincast/portfolio/ValueProvider;ILio/fincast/enums/Periodicity;Lio/fincast/portfolio/SimDate;Lio/fincast/portfolio/SimDate;)V", "getAmount", "()Lio/fincast/portfolio/ValueProvider;", "getEndDate", "()Lio/fincast/portfolio/SimDate;", "getFromPosition", "()Lio/fincast/portfolio/Position;", "getPeriodicity", "()Lio/fincast/enums/Periodicity;", "getPosition", "getSign", "()I", "getStartDate", "getTag", "()Ljava/lang/String;", "getToPosition", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "", "handleLifecycle", "", "date", "hashCode", "toString", "fincast"})
public final class TransferCompo
extends PositionCompoBase {
    @NotNull
    private final Position position;
    @NotNull
    private final String tag;
    @NotNull
    private final Position fromPosition;
    @NotNull
    private final Position toPosition;
    @NotNull
    private final ValueProvider<Double> amount;
    private final int sign;
    @NotNull
    private final Periodicity periodicity;
    @Nullable
    private final SimDate startDate;
    @Nullable
    private final SimDate endDate;

    public TransferCompo(@NotNull Position position, @NotNull String tag, @NotNull Position fromPosition, @NotNull Position toPosition, @NotNull ValueProvider<Double> amount, int sign, @NotNull Periodicity periodicity, @Nullable SimDate startDate, @Nullable SimDate endDate) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)fromPosition, (String)"fromPosition");
        Intrinsics.checkNotNullParameter((Object)toPosition, (String)"toPosition");
        Intrinsics.checkNotNullParameter(amount, (String)"amount");
        Intrinsics.checkNotNullParameter((Object)((Object)periodicity), (String)"periodicity");
        this.position = position;
        this.tag = tag;
        this.fromPosition = fromPosition;
        this.toPosition = toPosition;
        this.amount = amount;
        this.sign = sign;
        this.periodicity = periodicity;
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public /* synthetic */ TransferCompo(Position position, String string, Position position2, Position position3, ValueProvider valueProvider, int n, Periodicity periodicity, SimDate simDate, SimDate simDate2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x80) != 0) {
            simDate = null;
        }
        if ((n2 & 0x100) != 0) {
            simDate2 = null;
        }
        this(position, string, position2, position3, valueProvider, n, periodicity, simDate, simDate2);
    }

    @Override
    @NotNull
    public Position getPosition() {
        return this.position;
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @NotNull
    public final Position getFromPosition() {
        return this.fromPosition;
    }

    @NotNull
    public final Position getToPosition() {
        return this.toPosition;
    }

    @NotNull
    public final ValueProvider<Double> getAmount() {
        return this.amount;
    }

    public final int getSign() {
        return this.sign;
    }

    @NotNull
    public final Periodicity getPeriodicity() {
        return this.periodicity;
    }

    @Nullable
    public final SimDate getStartDate() {
        return this.startDate;
    }

    @Nullable
    public final SimDate getEndDate() {
        return this.endDate;
    }

    @Override
    public void handleLifecycle(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        if (this.periodicity.isCashflowDate(date, this.startDate, this.endDate)) {
            double amount = ((Number)this.amount.getValue(date)).doubleValue() * (double)this.sign;
            this.bookTransfer(date, this.fromPosition, this.toPosition, amount);
        }
    }

    @NotNull
    public final Position component1() {
        return this.position;
    }

    @NotNull
    public final String component2() {
        return this.tag;
    }

    @NotNull
    public final Position component3() {
        return this.fromPosition;
    }

    @NotNull
    public final Position component4() {
        return this.toPosition;
    }

    @NotNull
    public final ValueProvider<Double> component5() {
        return this.amount;
    }

    public final int component6() {
        return this.sign;
    }

    @NotNull
    public final Periodicity component7() {
        return this.periodicity;
    }

    @Nullable
    public final SimDate component8() {
        return this.startDate;
    }

    @Nullable
    public final SimDate component9() {
        return this.endDate;
    }

    @NotNull
    public final TransferCompo copy(@NotNull Position position, @NotNull String tag, @NotNull Position fromPosition, @NotNull Position toPosition, @NotNull ValueProvider<Double> amount, int sign, @NotNull Periodicity periodicity, @Nullable SimDate startDate, @Nullable SimDate endDate) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)fromPosition, (String)"fromPosition");
        Intrinsics.checkNotNullParameter((Object)toPosition, (String)"toPosition");
        Intrinsics.checkNotNullParameter(amount, (String)"amount");
        Intrinsics.checkNotNullParameter((Object)((Object)periodicity), (String)"periodicity");
        return new TransferCompo(position, tag, fromPosition, toPosition, amount, sign, periodicity, startDate, endDate);
    }

    public static /* synthetic */ TransferCompo copy$default(TransferCompo transferCompo, Position position, String string, Position position2, Position position3, ValueProvider valueProvider, int n, Periodicity periodicity, SimDate simDate, SimDate simDate2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            position = transferCompo.position;
        }
        if ((n2 & 2) != 0) {
            string = transferCompo.tag;
        }
        if ((n2 & 4) != 0) {
            position2 = transferCompo.fromPosition;
        }
        if ((n2 & 8) != 0) {
            position3 = transferCompo.toPosition;
        }
        if ((n2 & 0x10) != 0) {
            valueProvider = transferCompo.amount;
        }
        if ((n2 & 0x20) != 0) {
            n = transferCompo.sign;
        }
        if ((n2 & 0x40) != 0) {
            periodicity = transferCompo.periodicity;
        }
        if ((n2 & 0x80) != 0) {
            simDate = transferCompo.startDate;
        }
        if ((n2 & 0x100) != 0) {
            simDate2 = transferCompo.endDate;
        }
        return transferCompo.copy(position, string, position2, position3, valueProvider, n, periodicity, simDate, simDate2);
    }

    @NotNull
    public String toString() {
        return "TransferCompo(position=" + this.position + ", tag=" + this.tag + ", fromPosition=" + this.fromPosition + ", toPosition=" + this.toPosition + ", amount=" + this.amount + ", sign=" + this.sign + ", periodicity=" + this.periodicity + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ")";
    }

    public int hashCode() {
        int result = this.position.hashCode();
        result = result * 31 + this.tag.hashCode();
        result = result * 31 + this.fromPosition.hashCode();
        result = result * 31 + this.toPosition.hashCode();
        result = result * 31 + this.amount.hashCode();
        result = result * 31 + Integer.hashCode(this.sign);
        result = result * 31 + this.periodicity.hashCode();
        result = result * 31 + (this.startDate == null ? 0 : this.startDate.hashCode());
        result = result * 31 + (this.endDate == null ? 0 : this.endDate.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TransferCompo)) {
            return false;
        }
        TransferCompo transferCompo = (TransferCompo)other;
        if (!Intrinsics.areEqual((Object)this.position, (Object)transferCompo.position)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tag, (Object)transferCompo.tag)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fromPosition, (Object)transferCompo.fromPosition)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.toPosition, (Object)transferCompo.toPosition)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.amount, transferCompo.amount)) {
            return false;
        }
        if (this.sign != transferCompo.sign) {
            return false;
        }
        if (this.periodicity != transferCompo.periodicity) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.startDate, (Object)transferCompo.startDate)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.endDate, (Object)transferCompo.endDate);
    }
}

