/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.portfolio.impl;

import io.fincast.enums.BookingKind;
import io.fincast.enums.BookingType;
import io.fincast.enums.ProductType;
import io.fincast.portfolio.AggregateBooking;
import io.fincast.portfolio.Booking;
import io.fincast.portfolio.LifecycleBooking;
import io.fincast.portfolio.Portfolio;
import io.fincast.portfolio.Position;
import io.fincast.portfolio.PositionCompo;
import io.fincast.portfolio.ReconciliationBooking;
import io.fincast.portfolio.SimDate;
import io.fincast.portfolio.impl.PositionImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\rH\u0002J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001aH\u0016J\u0018\u0010\"\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010#\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020\u0010H\u0016J\u0010\u0010(\u001a\u00020\n2\u0006\u0010!\u001a\u00020\u001aH\u0016J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0016J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010!\u001a\u00020\u001aH\u0016J\n\u0010*\u001a\u0004\u0018\u00010\u001aH\u0002J\n\u0010+\u001a\u0004\u0018\u00010\u001aH\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010!\u001a\u00020\u001aH\u0002J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0016J\u001e\u0010/\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010!\u001a\u00020\u001a2\u0006\u00100\u001a\u00020\u0001H\u0016J\u0010\u00101\u001a\u00020\n2\u0006\u0010!\u001a\u00020\u001aH\u0016J\u0010\u00102\u001a\u00020\n2\u0006\u0010!\u001a\u00020\u001aH\u0016J\u0010\u00103\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001aH\u0016J\u0010\u00104\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001aH\u0016J\u0010\u00105\u001a\u0002062\u0006\u0010!\u001a\u00020\u001aH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00067"}, d2={"Lio/fincast/portfolio/impl/PositionImpl;", "Lio/fincast/portfolio/Position;", "portfolio", "Lio/fincast/portfolio/Portfolio;", "tag", "", "productType", "Lio/fincast/enums/ProductType;", "(Lio/fincast/portfolio/Portfolio;Ljava/lang/String;Lio/fincast/enums/ProductType;)V", "balance", "", "bookings", "", "Lio/fincast/portfolio/Booking;", "compos", "", "Lio/fincast/portfolio/PositionCompo;", "getCompos", "()Ljava/util/List;", "setCompos", "(Ljava/util/List;)V", "getPortfolio", "()Lio/fincast/portfolio/Portfolio;", "getProductType", "()Lio/fincast/enums/ProductType;", "reconDate", "Lio/fincast/portfolio/SimDate;", "getTag", "()Ljava/lang/String;", "addBooking", "", "booking", "bookBalance", "date", "bookReconciliation", "bookTurnover", "bookingKind", "Lio/fincast/enums/BookingKind;", "turnover", "refCompo", "getBalance", "getBookings", "getFirstDate", "getLastDate", "getPeriod", "Lio/fincast/portfolio/AggregateBooking;", "getPeriods", "getRefBookings", "refPos", "getTurnover", "getYield", "handlePortfolioLifecycle", "handlePositionLifecycle", "isReconciled", "", "fincast"})
@SourceDebugExtension(value={"SMAP\nPositionImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PositionImpl.kt\nio/fincast/portfolio/impl/PositionImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n1855#2,2:124\n766#2:126\n857#2,2:127\n766#2:129\n857#2,2:130\n766#2:132\n857#2,2:133\n766#2:135\n857#2,2:136\n1#3:138\n*S KotlinDebug\n*F\n+ 1 PositionImpl.kt\nio/fincast/portfolio/impl/PositionImpl\n*L\n23#1:124,2\n44#1:126\n44#1:127,2\n48#1:129\n48#1:130,2\n60#1:132\n60#1:133,2\n69#1:135\n69#1:136,2\n*E\n"})
public final class PositionImpl
implements Position {
    @NotNull
    private final Portfolio portfolio;
    @NotNull
    private final String tag;
    @NotNull
    private final ProductType productType;
    @NotNull
    private List<? extends PositionCompo> compos;
    @NotNull
    private final List<Booking> bookings;
    @Nullable
    private SimDate reconDate;
    private double balance;

    public PositionImpl(@NotNull Portfolio portfolio, @NotNull String tag, @NotNull ProductType productType) {
        Intrinsics.checkNotNullParameter((Object)portfolio, (String)"portfolio");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)productType), (String)"productType");
        this.portfolio = portfolio;
        this.tag = tag;
        this.productType = productType;
        this.compos = CollectionsKt.emptyList();
        this.bookings = new ArrayList();
    }

    @Override
    @NotNull
    public Portfolio getPortfolio() {
        return this.portfolio;
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @Override
    @NotNull
    public ProductType getProductType() {
        return this.productType;
    }

    @Override
    @NotNull
    public List<PositionCompo> getCompos() {
        return this.compos;
    }

    public void setCompos(@NotNull List<? extends PositionCompo> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.compos = list;
    }

    @Override
    public void handlePositionLifecycle(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Iterable $this$forEach$iv = this.getCompos();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PositionCompo it = (PositionCompo)element$iv;
            boolean bl = false;
            it.handleLifecycle(date);
        }
    }

    @Override
    public void handlePortfolioLifecycle(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
    }

    @Override
    public boolean isReconciled(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return this.reconDate != null && Intrinsics.areEqual((Object)this.reconDate, (Object)date);
    }

    @Override
    public double getBalance(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return this.getPeriod(date).getAmount();
    }

    @Override
    public double getYield(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return this.getPeriod(date).getYield();
    }

    @Override
    public double getTurnover(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return this.getBalance(date) - this.getBalance(date.minus(1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Booking> getBookings() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.bookings;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Booking it = (Booking)element$iv$iv;
            boolean bl = false;
            if (!(it.getBookingKind() != BookingKind.AGGREGATE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Booking> getBookings(@NotNull SimDate date) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Iterable $this$filter$iv = this.bookings;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Booking it = (Booking)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getDate(), (Object)date) && it.getBookingKind() != BookingKind.AGGREGATE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public List<Booking> getRefBookings(@NotNull SimDate date, @NotNull Position refPos) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)refPos, (String)"refPos");
        List<Object> list = this.getBookings(date).stream().filter(arg_0 -> PositionImpl.getRefBookings$lambda$3(getRefBookings.1.INSTANCE, arg_0)).filter(arg_0 -> PositionImpl.getRefBookings$lambda$4((Function1)new Function1<Booking, Boolean>(refPos){
            final /* synthetic */ Position $refPos;
            {
                this.$refPos = $refPos;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Booking b) {
                Intrinsics.checkNotNull((Object)b, (String)"null cannot be cast to non-null type io.fincast.portfolio.LifecycleBooking");
                return ((LifecycleBooking)b).getRefPosition() == this.$refPos;
            }
        }, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"refPos: Position): List<\u2026=== refPos }\n\t\t\t.toList()");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Booking> getPeriods() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.bookings;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Booking it = (Booking)element$iv$iv;
            boolean bl = false;
            if (!(it.getBookingKind() == BookingKind.AGGREGATE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final AggregateBooking getPeriod(SimDate date) {
        void $this$filterTo$iv$iv;
        block6: {
            block5: {
                if (this.bookings.isEmpty()) break block5;
                SimDate simDate = this.getFirstDate();
                Intrinsics.checkNotNull((Object)simDate);
                if (date.compareTo(simDate) >= 0) break block6;
            }
            return new AggregateBooking(this, date, 0.0, 0.0);
        }
        SimDate simDate = this.getLastDate();
        Intrinsics.checkNotNull((Object)simDate);
        if (date.compareTo(simDate) >= 0) {
            return new AggregateBooking(this, date, this.balance, this.getYield());
        }
        Iterable $this$filter$iv = this.bookings;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Booking it = (Booking)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getDate(), (Object)date) && it.getBookingKind() == BookingKind.AGGREGATE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Object e = ((List)destination$iv$iv).get(0);
        Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type io.fincast.portfolio.AggregateBooking");
        return (AggregateBooking)e;
    }

    @Override
    public void bookReconciliation(@NotNull SimDate date, double balance) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        this.addBooking(new ReconciliationBooking(this, date, balance));
    }

    @Override
    public void bookTurnover(@NotNull SimDate date, @NotNull BookingKind bookingKind, double turnover, @NotNull PositionCompo refCompo) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)((Object)bookingKind), (String)"bookingKind");
        Intrinsics.checkNotNullParameter((Object)refCompo, (String)"refCompo");
        this.addBooking(new LifecycleBooking(this, date, bookingKind, turnover, refCompo.getPosition(), refCompo));
    }

    @Override
    public void bookBalance(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        if (!((Collection)this.bookings).isEmpty()) {
            this.addBooking(new AggregateBooking(this, date, this.balance, this.getYield()));
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void addBooking(Booking booking) {
        v0 = booking.getDate();
        v1 = this.getLastDate();
        if (v1 == null) {
            v1 = booking.getDate();
        }
        if (!(v0.compareTo(v1) >= 0)) {
            $i$a$-require-PositionImpl$addBooking$1 = false;
            $i$a$-require-PositionImpl$addBooking$1 = "bookings must be sequential i: " + booking.getDate() + " vs " + this.getLastDate();
            throw new IllegalArgumentException($i$a$-require-PositionImpl$addBooking$1.toString());
        }
        v2 = booking.getDate();
        v3 = this.getLastDate();
        if (v3 == null) {
            v3 = booking.getDate();
        }
        if (!(v2.compareTo(v3.plus(1)) <= 0)) {
            $i$a$-require-PositionImpl$addBooking$2 = false;
            $i$a$-require-PositionImpl$addBooking$2 = "bookings must be sequential ii: " + booking.getDate() + " vs " + this.getLastDate();
            throw new IllegalArgumentException($i$a$-require-PositionImpl$addBooking$2.toString());
        }
        if (booking.getBookingKind().getBookingType() == BookingType.AGGREGATE || this.reconDate == null) ** GOTO lbl-1000
        v4 = booking.getDate();
        v5 = this.reconDate;
        Intrinsics.checkNotNull((Object)v5);
        if (v4.compareTo(v5) > 0) lbl-1000:
        // 2 sources

        {
            v6 = true;
        } else {
            v6 = false;
        }
        if (!v6) {
            $i$a$-require-PositionImpl$addBooking$3 = false;
            var2_7 = "cannot add booking to reconciled period";
            throw new IllegalArgumentException(var2_7.toString());
        }
        if (booking.getBookingKind().getBookingType() != BookingType.AGGREGATE && 0.0 == booking.getAmount()) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[booking.getBookingKind().getBookingType().ordinal()]) {
            case 1: {
                this.balance = booking.getAmount();
                this.reconDate = booking.getDate();
                break;
            }
            case 2: {
                this.balance += booking.getAmount();
                break;
            }
            case 3: {
                if (booking.getAmount() == this.balance) break;
                $i$a$-check-PositionImpl$addBooking$4 = false;
                var3_9 = "balance must match";
                throw new IllegalStateException(var3_9.toString());
            }
        }
        this.bookings.add(booking);
        this.getPortfolio().addBooking(booking);
    }

    private final SimDate getFirstDate() {
        return !((Collection)this.bookings).isEmpty() ? this.bookings.get(0).getDate() : null;
    }

    private final SimDate getLastDate() {
        return !((Collection)this.bookings).isEmpty() ? this.bookings.get(CollectionsKt.getLastIndex(this.bookings)).getDate() : null;
    }

    @Override
    public double getYield() {
        return Position.DefaultImpls.getYield(this);
    }

    @Override
    @Nullable
    public PositionCompo getCompo(@NotNull String tag) {
        return Position.DefaultImpls.getCompo(this, tag);
    }

    private static final boolean getRefBookings$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getRefBookings$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BookingType.values().length];
            try {
                nArray[BookingType.RECONCILE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BookingType.TURNOVER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BookingType.AGGREGATE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

