/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.portfolio.impl;

import io.fincast.enums.Periodicity;
import io.fincast.portfolio.AggregateBooking;
import io.fincast.portfolio.Booking;
import io.fincast.portfolio.LifecycleBooking;
import io.fincast.portfolio.Portfolio;
import io.fincast.portfolio.Position;
import io.fincast.portfolio.ReconciliationBooking;
import io.fincast.portfolio.SimDate;
import io.fincast.portfolio.impl.PortfolioImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\nH\u0016J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0016\u0010$\u001a\u00020\u00192\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006%"}, d2={"Lio/fincast/portfolio/impl/PortfolioImpl;", "Lio/fincast/portfolio/Portfolio;", "reconDate", "Lio/fincast/portfolio/SimDate;", "(Lio/fincast/portfolio/SimDate;)V", "_externalMoney", "Lio/fincast/portfolio/Position;", "_pocketMoney", "bookings", "", "Lio/fincast/portfolio/Booking;", "externalMoney", "getExternalMoney", "()Lio/fincast/portfolio/Position;", "pocketMoney", "getPocketMoney", "positions", "", "getPositions", "()Ljava/util/List;", "setPositions", "(Ljava/util/List;)V", "getReconDate", "()Lio/fincast/portfolio/SimDate;", "addBooking", "", "booking", "bookBalance", "d", "calcProjection", "endDate", "periodicity", "Lio/fincast/enums/Periodicity;", "tag", "", "initAuxPositions", "initPositions", "fincast"})
@SourceDebugExtension(value={"SMAP\nPortfolioImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PortfolioImpl.kt\nio/fincast/portfolio/impl/PortfolioImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,90:1\n766#2:91\n857#2,2:92\n1855#2,2:95\n1855#2,2:97\n766#2:99\n857#2,2:100\n800#2,11:102\n800#2,11:113\n766#2:124\n857#2,2:125\n800#2,11:127\n1477#2:138\n1502#2,3:139\n1505#2,3:149\n1477#2:155\n1502#2,3:156\n1505#2,3:166\n1855#2,2:176\n1#3:94\n361#4,7:142\n361#4,7:159\n76#5:152\n96#5,2:153\n125#5:169\n152#5,3:170\n98#5,3:173\n*S KotlinDebug\n*F\n+ 1 PortfolioImpl.kt\nio/fincast/portfolio/impl/PortfolioImpl\n*L\n32#1:91\n32#1:92,2\n47#1:95,2\n49#1:97,2\n55#1:99\n55#1:100,2\n59#1:102,11\n61#1:113,11\n62#1:124\n62#1:125,2\n64#1:127,11\n65#1:138\n65#1:139,3\n65#1:149,3\n67#1:155\n67#1:156,3\n67#1:166,3\n80#1:176,2\n65#1:142,7\n67#1:159,7\n66#1:152\n66#1:153,2\n68#1:169\n68#1:170,3\n66#1:173,3\n*E\n"})
public final class PortfolioImpl
implements Portfolio {
    @NotNull
    private final SimDate reconDate;
    @Nullable
    private Position _pocketMoney;
    @Nullable
    private Position _externalMoney;
    @NotNull
    private List<? extends Position> positions;
    @NotNull
    private final List<Booking> bookings;

    public PortfolioImpl(@NotNull SimDate reconDate) {
        Intrinsics.checkNotNullParameter((Object)reconDate, (String)"reconDate");
        this.reconDate = reconDate;
        this.positions = CollectionsKt.emptyList();
        this.bookings = new ArrayList();
    }

    @Override
    @NotNull
    public SimDate getReconDate() {
        return this.reconDate;
    }

    @Override
    @NotNull
    public List<Position> getPositions() {
        return this.positions;
    }

    public void setPositions(@NotNull List<? extends Position> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.positions = list;
    }

    @Override
    @NotNull
    public Position getPocketMoney() {
        Position position = this._pocketMoney;
        if (position == null) {
            throw new IllegalStateException("pocketMoney not initialized");
        }
        return position;
    }

    @Override
    @NotNull
    public Position getExternalMoney() {
        Position position = this._externalMoney;
        if (position == null) {
            throw new IllegalStateException("externalMoney not initialized");
        }
        return position;
    }

    @Override
    public void initAuxPositions(@NotNull Position pocketMoney, @NotNull Position externalMoney) {
        Intrinsics.checkNotNullParameter((Object)pocketMoney, (String)"pocketMoney");
        Intrinsics.checkNotNullParameter((Object)externalMoney, (String)"externalMoney");
        this._pocketMoney = pocketMoney;
        this._externalMoney = externalMoney;
    }

    @Override
    public void initPositions(@NotNull List<? extends Position> positions) {
        Intrinsics.checkNotNullParameter(positions, (String)"positions");
        this.setPositions(positions);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Position> getPositions(@NotNull String tag) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Iterable $this$filter$iv = this.getPositions();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Position it = (Position)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getTag(), (Object)tag)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Booking> calcProjection(@NotNull SimDate endDate, @NotNull Periodicity periodicity) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Iterable answer$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        Object $this$groupBy$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv2;
        Iterable $this$filterIsInstance$iv2;
        void $this$filterIsInstanceTo$iv$iv3;
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)endDate, (String)"endDate");
        Intrinsics.checkNotNullParameter((Object)((Object)periodicity), (String)"periodicity");
        if (!(periodicity == Periodicity.MONTHLY || periodicity == Periodicity.YEARLY)) {
            boolean $i$a$-check-PortfolioImpl$calcProjection$22 = false;
            String $i$a$-check-PortfolioImpl$calcProjection$22 = "periodicity must be MONTHLY or YEARLY";
            throw new IllegalStateException($i$a$-check-PortfolioImpl$calcProjection$22.toString());
        }
        this.bookings.clear();
        this.bookBalance(this.getReconDate());
        for (SimDate d : this.getReconDate().plus(1).rangeTo(periodicity.endOfPeriod(endDate))) {
            Position it;
            $this$forEach$iv = this.getPositions();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Position)element$iv;
                boolean bl = false;
                it.handlePositionLifecycle(d);
            }
            $this$forEach$iv = this.getPositions();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Position)element$iv;
                boolean bl = false;
                it.handlePortfolioLifecycle(d);
            }
            this.bookBalance(d);
        }
        if (periodicity == Periodicity.MONTHLY) {
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2 = this.bookings;
            boolean $i$f$filter = false;
            $this$forEach$iv = $this$filter$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Iterator<Object> element$iv$iv : $this$filterTo$iv$iv2) {
                Booking it = (Booking)((Object)element$iv$iv);
                boolean bl = false;
                if (!(it instanceof LifecycleBooking || it instanceof AggregateBooking)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        Iterable $this$filterIsInstance$iv3 = this.bookings;
        boolean $i$f$filterIsInstance22 = false;
        Iterable destination$iv$iv = $this$filterIsInstance$iv3;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv3) {
            if (!(element$iv$iv instanceof ReconciliationBooking)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List reconBookings = (List)destination$iv$iv2;
        Iterable $i$f$filterIsInstance22 = this.bookings;
        boolean $i$f$filterIsInstance = false;
        destination$iv$iv2 = $this$filterIsInstance$iv2;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof AggregateBooking)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filterIsInstance$iv2 = (List)destination$iv$iv3;
        boolean $i$f$filter22 = false;
        $this$filterIsInstanceTo$iv$iv2 = $this$filter$iv;
        destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AggregateBooking it = (AggregateBooking)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getDate(), (Object)this.getReconDate()) || Periodicity.isCashflowDate$default(periodicity, it.getDate(), null, null, 6, null))) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List eopAggregateBookings = (List)destination$iv$iv3;
        Iterable $i$f$filter22 = this.bookings;
        boolean $i$f$filterIsInstance3 = false;
        destination$iv$iv3 = $this$filterIsInstance$iv;
        Object destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterIsInstanceTo3 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof LifecycleBooking)) continue;
            destination$iv$iv4.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv4;
        boolean $i$f$groupBy = false;
        $this$filterIsInstanceTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv4 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            LifecycleBooking it = (LifecycleBooking)element$iv$iv;
            boolean bl = false;
            SimDate key$iv$iv = periodicity.endOfPeriod(it.getDate());
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv4;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv4;
        boolean $i$f$flatMap = false;
        $this$groupByTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv4 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator<Object> iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$groupByTo$iv$iv2;
            Object element$iv$iv;
            Object it = element$iv$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            SimDate date = (SimDate)it.getKey();
            List periodBookings = (List)it.getValue();
            Object $this$groupBy$iv2 = periodBookings;
            boolean $i$f$groupBy2 = false;
            answer$iv$iv$iv = $this$groupBy$iv2;
            Object destination$iv$iv5 = new LinkedHashMap();
            boolean $i$f$groupByTo2 = false;
            for (Object element$iv$iv2 : $this$groupByTo$iv$iv2) {
                Object object;
                LifecycleBooking it2 = (LifecycleBooking)element$iv$iv2;
                boolean bl3 = false;
                String key$iv$iv = it2.getPosition().getTag() + ":" + it2.getRefPosition().getTag() + ":" + it2.getRefCompo().getTag() + ":" + it2.getBookingKind().getCode();
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv5;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl4 = false;
                    List answer$iv$iv$iv2 = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv2);
                    object = answer$iv$iv$iv2;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv2);
            }
            $this$groupBy$iv2 = destination$iv$iv5;
            boolean $i$f$map = false;
            $this$groupByTo$iv$iv2 = $this$map$iv;
            destination$iv$iv5 = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator<Object> iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = (Map.Entry)iterator2.next();
                Object object = destination$iv$iv5;
                boolean bl5 = false;
                String key = (String)entry.getKey();
                List keyBookings = (List)entry.getValue();
                LifecycleBooking keyBooking = (LifecycleBooking)CollectionsKt.first((List)keyBookings);
                Iterable iterable = keyBookings;
                double d = 0.0;
                for (Object t : iterable) {
                    void it3;
                    LifecycleBooking lifecycleBooking = (LifecycleBooking)t;
                    double d2 = d;
                    boolean bl6 = false;
                    double d3 = it3.getAmount();
                    d = d2 + d3;
                }
                double amount = d;
                object.add(new LifecycleBooking(keyBooking.getPosition(), date, keyBooking.getBookingKind(), amount, keyBooking.getRefPosition(), keyBooking.getRefCompo()));
            }
            Iterable list$iv$iv = (List)destination$iv$iv5;
            CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv);
        }
        List eopLifecycleBookings = (List)destination$iv$iv4;
        Function1[] function1Array = new Function1[]{calcProjection.eopBookings.1.INSTANCE, calcProjection.eopBookings.2.INSTANCE};
        List eopBookings2 = CollectionsKt.sortedWith((Iterable)CollectionsKt.plus((Collection)eopAggregateBookings, (Iterable)eopLifecycleBookings), (Comparator)ComparisonsKt.compareBy((Function1[])function1Array));
        return CollectionsKt.plus((Collection)reconBookings, (Iterable)eopBookings2);
    }

    private final void bookBalance(SimDate d) {
        Iterable $this$forEach$iv = this.getPositions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Position it = (Position)element$iv;
            boolean bl = false;
            it.bookBalance(d);
        }
        this.getPocketMoney().bookBalance(d);
        this.getExternalMoney().bookBalance(d);
    }

    @Override
    public void addBooking(@NotNull Booking booking) {
        Intrinsics.checkNotNullParameter((Object)booking, (String)"booking");
        this.bookings.add(booking);
    }
}

