/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.portfolio;

import io.fincast.portfolio.SimDate;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0019B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0003J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0003J\u0011\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0000H\u0096\u0002J\u0006\u0010\u000b\u001a\u00020\u0000J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0000J\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0000J\u0011\u0010\u000f\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0003H\u0086\u0002J\u0006\u0010\u0010\u001a\u00020\u0003J\u000e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0000J\u0011\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0003H\u0086\u0002J\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00000\u00142\u0006\u0010\n\u001a\u00020\u0000H\u0086\u0002J\u0006\u0010\u0015\u001a\u00020\u0000J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0006\u0010\u0018\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/fincast/portfolio/SimDate;", "", "date", "", "(I)V", "addMonths", "monthCount", "addYears", "yearCount", "compareTo", "other", "endOfYear", "isAfter", "", "isBefore", "minus", "month", "monthsBetween", "plus", "rangeTo", "", "startOfYear", "toString", "", "year", "Companion", "fincast"})
public final class SimDate
implements Comparable<SimDate> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int date;
    public static final int MONTH_PER_YEAR = 12;
    @NotNull
    private static final Map<Integer, SimDate> simDates = new LinkedHashMap();

    public SimDate(int date) {
        this.date = date;
    }

    public final int year() {
        return this.date / 12;
    }

    public final int month() {
        return this.date % 12 + 1;
    }

    @NotNull
    public final SimDate addMonths(int monthCount) {
        return SimDate.Companion.of(this.date + monthCount);
    }

    @NotNull
    public final SimDate addYears(int yearCount) {
        return SimDate.Companion.of(this.date + yearCount * 12);
    }

    @NotNull
    public final SimDate startOfYear() {
        return Companion.of(this.year(), 1);
    }

    @NotNull
    public final SimDate endOfYear() {
        return Companion.of(this.year(), 12);
    }

    @NotNull
    public final SimDate plus(int monthCount) {
        return this.addMonths(monthCount);
    }

    @NotNull
    public final SimDate minus(int monthCount) {
        return this.addMonths(-monthCount);
    }

    public final int minus(@NotNull SimDate other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return other.monthsBetween(this);
    }

    @NotNull
    public final List<SimDate> rangeTo(@NotNull SimDate other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Companion.getSimDateList(this, other);
    }

    public final int monthsBetween(@NotNull SimDate other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return other.date - this.date;
    }

    @Override
    public int compareTo(@NotNull SimDate other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.date - other.date;
    }

    public final boolean isBefore(@NotNull SimDate other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.date < other.date;
    }

    public final boolean isAfter(@NotNull SimDate other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.date > other.date;
    }

    @NotNull
    public String toString() {
        String string = "%04d.%02d";
        Object[] objectArray = new Object[]{this.year(), this.month()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final SimDate now() {
        return Companion.now();
    }

    @JvmStatic
    @NotNull
    public static final SimDate of(int year, int month) {
        return Companion.of(year, month);
    }

    @JvmStatic
    @NotNull
    public static final SimDate of(@NotNull LocalDate localDate) {
        return Companion.of(localDate);
    }

    @JvmStatic
    @NotNull
    public static final SimDate of(@NotNull String date) {
        return Companion.of(date);
    }

    @JvmStatic
    @NotNull
    public static final List<SimDate> getSimDateList(@NotNull SimDate startDate, @NotNull SimDate endDate) {
        return Companion.getSimDateList(startDate, endDate);
    }

    @JvmStatic
    @NotNull
    public static final SimDate min(@NotNull SimDate a, @NotNull SimDate b) {
        return Companion.min(a, b);
    }

    @JvmStatic
    @NotNull
    public static final SimDate max(@NotNull SimDate a, @NotNull SimDate b) {
        return Companion.max(a, b);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0007J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0007J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0007J\b\u0010\u0010\u001a\u00020\u0007H\u0007J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0017H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/fincast/portfolio/SimDate$Companion;", "", "()V", "MONTH_PER_YEAR", "", "simDates", "", "Lio/fincast/portfolio/SimDate;", "getSimDateList", "", "startDate", "endDate", "max", "a", "b", "min", "now", "of", "localDate", "Ljava/time/LocalDate;", "date", "year", "month", "", "fincast"})
    @SourceDebugExtension(value={"SMAP\nSimDate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimDate.kt\nio/fincast/portfolio/SimDate$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,175:1\n1#2:176\n731#3,9:177\n37#4,2:186\n*S KotlinDebug\n*F\n+ 1 SimDate.kt\nio/fincast/portfolio/SimDate$Companion\n*L\n131#1:177,9\n131#1:186,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SimDate now() {
            LocalDate now = LocalDate.now();
            return this.of(now.getYear(), now.getMonthValue());
        }

        @JvmStatic
        @NotNull
        public final SimDate of(int year, int month) {
            if (!(1 <= month ? month < 13 : false)) {
                boolean bl = false;
                String string = "valid month";
                throw new IllegalArgumentException(string.toString());
            }
            return this.of(year * 12 + month - 1);
        }

        @JvmStatic
        @NotNull
        public final SimDate of(@NotNull LocalDate localDate) {
            Intrinsics.checkNotNullParameter((Object)localDate, (String)"localDate");
            return this.of(localDate.getYear(), localDate.getMonthValue());
        }

        @JvmStatic
        @NotNull
        public final SimDate of(@NotNull String date) {
            List list;
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            CharSequence charSequence = date;
            if (!new Regex("\\d{4}\\.\\d{2}").matches(charSequence)) {
                boolean $i$a$-require-SimDate$Companion$of$42 = false;
                String $i$a$-require-SimDate$Companion$of$42 = "valid date format";
                throw new IllegalArgumentException($i$a$-require-SimDate$Companion$of$42.toString());
            }
            CharSequence $i$a$-require-SimDate$Companion$of$42 = date;
            Regex regex = new Regex("\\.");
            int n = 0;
            List $this$dropLastWhile$iv = regex.split($i$a$-require-SimDate$Companion$of$42, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] parts = thisCollection$iv.toArray(new String[0]);
            if (!(2 == parts.length)) {
                boolean $i$a$-require-SimDate$Companion$of$52 = false;
                String $i$a$-require-SimDate$Companion$of$52 = "valid date";
                throw new IllegalArgumentException($i$a$-require-SimDate$Companion$of$52.toString());
            }
            int year = Integer.parseInt(parts[0]);
            int month = Integer.parseInt(parts[1]);
            return this.of(year, month);
        }

        private final SimDate of(int date) {
            SimDate simDate = simDates.computeIfAbsent(date, arg_0 -> Companion.of$lambda$4(of.4.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)simDate, (String)"simDates.computeIfAbsent\u2026 { d: Int -> SimDate(d) }");
            return simDate;
        }

        @JvmStatic
        @NotNull
        public final List<SimDate> getSimDateList(@NotNull SimDate startDate, @NotNull SimDate endDate) {
            int n;
            Intrinsics.checkNotNullParameter((Object)startDate, (String)"startDate");
            Intrinsics.checkNotNullParameter((Object)endDate, (String)"endDate");
            if (!(startDate.compareTo(endDate) <= 0)) {
                boolean $i$a$-require-SimDate$Companion$getSimDateList$22 = false;
                String $i$a$-require-SimDate$Companion$getSimDateList$22 = "valid date range";
                throw new IllegalArgumentException($i$a$-require-SimDate$Companion$getSimDateList$22.toString());
            }
            List dateList = new ArrayList();
            int i = startDate.date;
            if (i <= (n = endDate.date)) {
                while (true) {
                    dateList.add(this.of(i));
                    if (i == n) break;
                    ++i;
                }
            }
            return dateList;
        }

        @JvmStatic
        @NotNull
        public final SimDate min(@NotNull SimDate a, @NotNull SimDate b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return a.compareTo(b) < 0 ? a : b;
        }

        @JvmStatic
        @NotNull
        public final SimDate max(@NotNull SimDate a, @NotNull SimDate b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return a.compareTo(b) > 0 ? a : b;
        }

        private static final SimDate of$lambda$4(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (SimDate)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

