/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.portfolio;

import io.fincast.enums.BookingKind;
import io.fincast.portfolio.Booking;
import io.fincast.portfolio.Position;
import io.fincast.portfolio.SimDate;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lio/fincast/portfolio/ReconciliationBooking;", "Lio/fincast/portfolio/Booking;", "position", "Lio/fincast/portfolio/Position;", "date", "Lio/fincast/portfolio/SimDate;", "amount", "", "(Lio/fincast/portfolio/Position;Lio/fincast/portfolio/SimDate;D)V", "getAmount", "()D", "bookingKind", "Lio/fincast/enums/BookingKind;", "getBookingKind", "()Lio/fincast/enums/BookingKind;", "getDate", "()Lio/fincast/portfolio/SimDate;", "getPosition", "()Lio/fincast/portfolio/Position;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "fincast"})
public final class ReconciliationBooking
implements Booking {
    @NotNull
    private final Position position;
    @NotNull
    private final SimDate date;
    private final double amount;
    @NotNull
    private final BookingKind bookingKind;

    public ReconciliationBooking(@NotNull Position position, @NotNull SimDate date, double amount) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        this.position = position;
        this.date = date;
        this.amount = amount;
        this.bookingKind = BookingKind.RECONCILE;
    }

    @Override
    @NotNull
    public Position getPosition() {
        return this.position;
    }

    @Override
    @NotNull
    public SimDate getDate() {
        return this.date;
    }

    @Override
    public double getAmount() {
        return this.amount;
    }

    @Override
    @NotNull
    public BookingKind getBookingKind() {
        return this.bookingKind;
    }

    @NotNull
    public String toString() {
        SimDate simDate = this.getDate();
        String string = this.getBookingKind().getCode();
        String string2 = "%.0f";
        Object[] objectArray = new Object[]{this.getAmount()};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
        return simDate + ": " + string + " " + string3;
    }

    @NotNull
    public final Position component1() {
        return this.position;
    }

    @NotNull
    public final SimDate component2() {
        return this.date;
    }

    public final double component3() {
        return this.amount;
    }

    @NotNull
    public final ReconciliationBooking copy(@NotNull Position position, @NotNull SimDate date, double amount) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return new ReconciliationBooking(position, date, amount);
    }

    public static /* synthetic */ ReconciliationBooking copy$default(ReconciliationBooking reconciliationBooking, Position position, SimDate simDate, double d, int n, Object object) {
        if ((n & 1) != 0) {
            position = reconciliationBooking.position;
        }
        if ((n & 2) != 0) {
            simDate = reconciliationBooking.date;
        }
        if ((n & 4) != 0) {
            d = reconciliationBooking.amount;
        }
        return reconciliationBooking.copy(position, simDate, d);
    }

    public int hashCode() {
        int result = this.position.hashCode();
        result = result * 31 + this.date.hashCode();
        result = result * 31 + Double.hashCode(this.amount);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ReconciliationBooking)) {
            return false;
        }
        ReconciliationBooking reconciliationBooking = (ReconciliationBooking)other;
        if (!Intrinsics.areEqual((Object)this.position, (Object)reconciliationBooking.position)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.date, (Object)reconciliationBooking.date)) {
            return false;
        }
        return Double.compare(this.amount, reconciliationBooking.amount) == 0;
    }
}

