/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.portfolio;

import io.fincast.enums.BookingKind;
import io.fincast.portfolio.Booking;
import io.fincast.portfolio.Position;
import io.fincast.portfolio.PositionCompo;
import io.fincast.portfolio.SimDate;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\fH\u00c6\u0003JE\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u00d6\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J\b\u0010&\u001a\u00020'H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015\u00a8\u0006("}, d2={"Lio/fincast/portfolio/LifecycleBooking;", "Lio/fincast/portfolio/Booking;", "position", "Lio/fincast/portfolio/Position;", "date", "Lio/fincast/portfolio/SimDate;", "bookingKind", "Lio/fincast/enums/BookingKind;", "amount", "", "refPosition", "refCompo", "Lio/fincast/portfolio/PositionCompo;", "(Lio/fincast/portfolio/Position;Lio/fincast/portfolio/SimDate;Lio/fincast/enums/BookingKind;DLio/fincast/portfolio/Position;Lio/fincast/portfolio/PositionCompo;)V", "getAmount", "()D", "getBookingKind", "()Lio/fincast/enums/BookingKind;", "getDate", "()Lio/fincast/portfolio/SimDate;", "getPosition", "()Lio/fincast/portfolio/Position;", "getRefCompo", "()Lio/fincast/portfolio/PositionCompo;", "getRefPosition", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "fincast"})
public final class LifecycleBooking
implements Booking {
    @NotNull
    private final Position position;
    @NotNull
    private final SimDate date;
    @NotNull
    private final BookingKind bookingKind;
    private final double amount;
    @NotNull
    private final Position refPosition;
    @NotNull
    private final PositionCompo refCompo;

    public LifecycleBooking(@NotNull Position position, @NotNull SimDate date, @NotNull BookingKind bookingKind, double amount, @NotNull Position refPosition, @NotNull PositionCompo refCompo) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)((Object)bookingKind), (String)"bookingKind");
        Intrinsics.checkNotNullParameter((Object)refPosition, (String)"refPosition");
        Intrinsics.checkNotNullParameter((Object)refCompo, (String)"refCompo");
        this.position = position;
        this.date = date;
        this.bookingKind = bookingKind;
        this.amount = amount;
        this.refPosition = refPosition;
        this.refCompo = refCompo;
    }

    @Override
    @NotNull
    public Position getPosition() {
        return this.position;
    }

    @Override
    @NotNull
    public SimDate getDate() {
        return this.date;
    }

    @Override
    @NotNull
    public BookingKind getBookingKind() {
        return this.bookingKind;
    }

    @Override
    public double getAmount() {
        return this.amount;
    }

    @NotNull
    public final Position getRefPosition() {
        return this.refPosition;
    }

    @NotNull
    public final PositionCompo getRefCompo() {
        return this.refCompo;
    }

    @NotNull
    public String toString() {
        SimDate simDate = this.getDate();
        String string = this.getBookingKind().getCode();
        String string2 = "%.0f";
        Object[] objectArray = new Object[]{this.getAmount()};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
        return simDate + ": " + string + " " + string3 + " " + this.refCompo.getTag();
    }

    @NotNull
    public final Position component1() {
        return this.position;
    }

    @NotNull
    public final SimDate component2() {
        return this.date;
    }

    @NotNull
    public final BookingKind component3() {
        return this.bookingKind;
    }

    public final double component4() {
        return this.amount;
    }

    @NotNull
    public final Position component5() {
        return this.refPosition;
    }

    @NotNull
    public final PositionCompo component6() {
        return this.refCompo;
    }

    @NotNull
    public final LifecycleBooking copy(@NotNull Position position, @NotNull SimDate date, @NotNull BookingKind bookingKind, double amount, @NotNull Position refPosition, @NotNull PositionCompo refCompo) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)((Object)bookingKind), (String)"bookingKind");
        Intrinsics.checkNotNullParameter((Object)refPosition, (String)"refPosition");
        Intrinsics.checkNotNullParameter((Object)refCompo, (String)"refCompo");
        return new LifecycleBooking(position, date, bookingKind, amount, refPosition, refCompo);
    }

    public static /* synthetic */ LifecycleBooking copy$default(LifecycleBooking lifecycleBooking, Position position, SimDate simDate, BookingKind bookingKind, double d, Position position2, PositionCompo positionCompo, int n, Object object) {
        if ((n & 1) != 0) {
            position = lifecycleBooking.position;
        }
        if ((n & 2) != 0) {
            simDate = lifecycleBooking.date;
        }
        if ((n & 4) != 0) {
            bookingKind = lifecycleBooking.bookingKind;
        }
        if ((n & 8) != 0) {
            d = lifecycleBooking.amount;
        }
        if ((n & 0x10) != 0) {
            position2 = lifecycleBooking.refPosition;
        }
        if ((n & 0x20) != 0) {
            positionCompo = lifecycleBooking.refCompo;
        }
        return lifecycleBooking.copy(position, simDate, bookingKind, d, position2, positionCompo);
    }

    public int hashCode() {
        int result = this.position.hashCode();
        result = result * 31 + this.date.hashCode();
        result = result * 31 + this.bookingKind.hashCode();
        result = result * 31 + Double.hashCode(this.amount);
        result = result * 31 + this.refPosition.hashCode();
        result = result * 31 + this.refCompo.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LifecycleBooking)) {
            return false;
        }
        LifecycleBooking lifecycleBooking = (LifecycleBooking)other;
        if (!Intrinsics.areEqual((Object)this.position, (Object)lifecycleBooking.position)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.date, (Object)lifecycleBooking.date)) {
            return false;
        }
        if (this.bookingKind != lifecycleBooking.bookingKind) {
            return false;
        }
        if (Double.compare(this.amount, lifecycleBooking.amount) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.refPosition, (Object)lifecycleBooking.refPosition)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.refCompo, (Object)lifecycleBooking.refCompo);
    }
}

