/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.household.impl;

import io.fincast.enums.FundsAllocation;
import io.fincast.enums.Periodicity;
import io.fincast.enums.ProductType;
import io.fincast.household.Contract;
import io.fincast.portfolio.Portfolio;
import io.fincast.portfolio.Position;
import io.fincast.portfolio.PositionCompo;
import io.fincast.portfolio.SimDate;
import io.fincast.portfolio.ValueProvider;
import io.fincast.portfolio.ValueProviders;
import io.fincast.portfolio.impl.CashflowCompo;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001-B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\tH\u00c6\u0003J?\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u00d6\u0003J\t\u0010*\u001a\u00020+H\u00d6\u0001J\t\u0010,\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\n\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006."}, d2={"Lio/fincast/household/impl/Salary;", "Lio/fincast/household/Contract;", "tag", "", "amount", "", "periodicity", "Lio/fincast/enums/Periodicity;", "startDate", "Lio/fincast/portfolio/SimDate;", "endDate", "(Ljava/lang/String;DLio/fincast/enums/Periodicity;Lio/fincast/portfolio/SimDate;Lio/fincast/portfolio/SimDate;)V", "getAmount", "()D", "getEndDate", "()Lio/fincast/portfolio/SimDate;", "getPeriodicity", "()Lio/fincast/enums/Periodicity;", "productType", "Lio/fincast/enums/ProductType;", "getProductType", "()Lio/fincast/enums/ProductType;", "getStartDate", "getTag", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "copy", "createCompos", "", "Lio/fincast/portfolio/PositionCompo;", "portfolio", "Lio/fincast/portfolio/Portfolio;", "pos", "Lio/fincast/portfolio/Position;", "equals", "", "other", "", "hashCode", "", "toString", "Builder", "fincast"})
public final class Salary
implements Contract {
    @NotNull
    private final String tag;
    private final double amount;
    @NotNull
    private final Periodicity periodicity;
    @Nullable
    private final SimDate startDate;
    @Nullable
    private final SimDate endDate;
    @NotNull
    private final ProductType productType;

    public Salary(@NotNull String tag, double amount, @NotNull Periodicity periodicity, @Nullable SimDate startDate, @Nullable SimDate endDate) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)periodicity), (String)"periodicity");
        this.tag = tag;
        this.amount = amount;
        this.periodicity = periodicity;
        this.startDate = startDate;
        this.endDate = endDate;
        this.productType = ProductType.INCOME;
    }

    public /* synthetic */ Salary(String string, double d, Periodicity periodicity, SimDate simDate, SimDate simDate2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            periodicity = Periodicity.YEARLY;
        }
        if ((n & 8) != 0) {
            simDate = null;
        }
        if ((n & 0x10) != 0) {
            simDate2 = null;
        }
        this(string, d, periodicity, simDate, simDate2);
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    public final double getAmount() {
        return this.amount;
    }

    @NotNull
    public final Periodicity getPeriodicity() {
        return this.periodicity;
    }

    @Override
    @Nullable
    public SimDate getStartDate() {
        return this.startDate;
    }

    @Override
    @Nullable
    public SimDate getEndDate() {
        return this.endDate;
    }

    @Override
    @NotNull
    public ProductType getProductType() {
        return this.productType;
    }

    @Override
    @NotNull
    public List<PositionCompo> createCompos(@NotNull Portfolio portfolio, @NotNull Position pos) {
        Intrinsics.checkNotNullParameter((Object)portfolio, (String)"portfolio");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        SimDate simDate = this.getStartDate();
        if (simDate == null) {
            simDate = portfolio.getReconDate();
        }
        SimDate startDate = SimDate.Companion.max(simDate, portfolio.getReconDate());
        FundsAllocation fundsAllocation = FundsAllocation.DISBURSE;
        ValueProvider<Double> valueProvider = ValueProviders.INSTANCE.constValue(this.amount / (double)this.periodicity.getMonths());
        SimDate simDate2 = this.getEndDate();
        Periodicity periodicity = Periodicity.MONTHLY;
        CashflowCompo cf = new CashflowCompo(pos, "income", fundsAllocation, valueProvider, 1, periodicity, startDate, simDate2, false, 256, null);
        return CollectionsKt.listOf((Object)cf);
    }

    @Override
    @NotNull
    public Position createPosition(@NotNull Portfolio portfolio) {
        return Contract.DefaultImpls.createPosition(this, portfolio);
    }

    @NotNull
    public final String component1() {
        return this.tag;
    }

    public final double component2() {
        return this.amount;
    }

    @NotNull
    public final Periodicity component3() {
        return this.periodicity;
    }

    @Nullable
    public final SimDate component4() {
        return this.startDate;
    }

    @Nullable
    public final SimDate component5() {
        return this.endDate;
    }

    @NotNull
    public final Salary copy(@NotNull String tag, double amount, @NotNull Periodicity periodicity, @Nullable SimDate startDate, @Nullable SimDate endDate) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)periodicity), (String)"periodicity");
        return new Salary(tag, amount, periodicity, startDate, endDate);
    }

    public static /* synthetic */ Salary copy$default(Salary salary, String string, double d, Periodicity periodicity, SimDate simDate, SimDate simDate2, int n, Object object) {
        if ((n & 1) != 0) {
            string = salary.tag;
        }
        if ((n & 2) != 0) {
            d = salary.amount;
        }
        if ((n & 4) != 0) {
            periodicity = salary.periodicity;
        }
        if ((n & 8) != 0) {
            simDate = salary.startDate;
        }
        if ((n & 0x10) != 0) {
            simDate2 = salary.endDate;
        }
        return salary.copy(string, d, periodicity, simDate, simDate2);
    }

    @NotNull
    public String toString() {
        return "Salary(tag=" + this.tag + ", amount=" + this.amount + ", periodicity=" + this.periodicity + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ")";
    }

    public int hashCode() {
        int result = this.tag.hashCode();
        result = result * 31 + Double.hashCode(this.amount);
        result = result * 31 + this.periodicity.hashCode();
        result = result * 31 + (this.startDate == null ? 0 : this.startDate.hashCode());
        result = result * 31 + (this.endDate == null ? 0 : this.endDate.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Salary)) {
            return false;
        }
        Salary salary = (Salary)other;
        if (!Intrinsics.areEqual((Object)this.tag, (Object)salary.tag)) {
            return false;
        }
        if (Double.compare(this.amount, salary.amount) != 0) {
            return false;
        }
        if (this.periodicity != salary.periodicity) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.startDate, (Object)salary.startDate)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.endDate, (Object)salary.endDate);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0007J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fR\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/fincast/household/impl/Salary$Builder;", "", "()V", "amount", "", "Ljava/lang/Double;", "endDate", "Lio/fincast/portfolio/SimDate;", "periodicity", "Lio/fincast/enums/Periodicity;", "startDate", "tag", "", "build", "Lio/fincast/household/impl/Salary;", "fincast"})
    @SourceDebugExtension(value={"SMAP\nSalary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Salary.kt\nio/fincast/household/impl/Salary$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1#2:60\n*E\n"})
    public static final class Builder {
        @Nullable
        private String tag;
        @Nullable
        private Double amount;
        @Nullable
        private Periodicity periodicity;
        @Nullable
        private SimDate startDate;
        @Nullable
        private SimDate endDate;

        @NotNull
        public final Builder tag(@NotNull String tag) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Builder $this$tag_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$tag_u24lambda_u240.tag = tag;
            return builder;
        }

        @NotNull
        public final Builder amount(double amount) {
            Builder builder;
            Builder $this$amount_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$amount_u24lambda_u241.amount = amount;
            return builder;
        }

        @NotNull
        public final Builder periodicity(@NotNull Periodicity periodicity) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)periodicity), (String)"periodicity");
            Builder $this$periodicity_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$periodicity_u24lambda_u242.periodicity = periodicity;
            return builder;
        }

        @NotNull
        public final Builder startDate(@NotNull SimDate startDate) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)startDate, (String)"startDate");
            Builder $this$startDate_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$startDate_u24lambda_u243.startDate = startDate;
            return builder;
        }

        @NotNull
        public final Builder endDate(@NotNull SimDate endDate) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)endDate, (String)"endDate");
            Builder $this$endDate_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$endDate_u24lambda_u244.endDate = endDate;
            return builder;
        }

        @NotNull
        public final Salary build() {
            String string = this.tag;
            if (string == null) {
                throw new IllegalArgumentException("tag is required");
            }
            Double d = this.amount;
            if (d == null) {
                throw new IllegalArgumentException("amount is required");
            }
            double d2 = d;
            Periodicity periodicity = this.periodicity;
            if (periodicity == null) {
                periodicity = Periodicity.YEARLY;
            }
            return new Salary(string, d2, periodicity, this.startDate, this.endDate);
        }
    }
}

