/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.household.impl;

import io.fincast.enums.BookingKind;
import io.fincast.enums.FundsAllocation;
import io.fincast.enums.Periodicity;
import io.fincast.enums.ProductType;
import io.fincast.household.Valuable;
import io.fincast.portfolio.Portfolio;
import io.fincast.portfolio.Position;
import io.fincast.portfolio.PositionCompo;
import io.fincast.portfolio.ValueProviders;
import io.fincast.portfolio.impl.YieldCompo;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001-B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\nH\u00c6\u0003J;\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u00d6\u0003J\t\u0010*\u001a\u00020+H\u00d6\u0001J\t\u0010,\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006."}, d2={"Lio/fincast/household/impl/Liability;", "Lio/fincast/household/Valuable;", "tag", "", "reconBalance", "", "interestRate", "interestPeriodicity", "Lio/fincast/enums/Periodicity;", "interestAllocation", "Lio/fincast/enums/FundsAllocation;", "(Ljava/lang/String;DDLio/fincast/enums/Periodicity;Lio/fincast/enums/FundsAllocation;)V", "getInterestAllocation", "()Lio/fincast/enums/FundsAllocation;", "getInterestPeriodicity", "()Lio/fincast/enums/Periodicity;", "getInterestRate", "()D", "productType", "Lio/fincast/enums/ProductType;", "getProductType", "()Lio/fincast/enums/ProductType;", "getReconBalance", "getTag", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "copy", "createCompos", "", "Lio/fincast/portfolio/PositionCompo;", "portfolio", "Lio/fincast/portfolio/Portfolio;", "pos", "Lio/fincast/portfolio/Position;", "equals", "", "other", "", "hashCode", "", "toString", "Builder", "fincast"})
public final class Liability
implements Valuable {
    @NotNull
    private final String tag;
    private final double reconBalance;
    private final double interestRate;
    @NotNull
    private final Periodicity interestPeriodicity;
    @NotNull
    private final FundsAllocation interestAllocation;
    @NotNull
    private final ProductType productType;

    public Liability(@NotNull String tag, double reconBalance, double interestRate, @NotNull Periodicity interestPeriodicity, @NotNull FundsAllocation interestAllocation) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)interestPeriodicity), (String)"interestPeriodicity");
        Intrinsics.checkNotNullParameter((Object)((Object)interestAllocation), (String)"interestAllocation");
        this.tag = tag;
        this.reconBalance = reconBalance;
        this.interestRate = interestRate;
        this.interestPeriodicity = interestPeriodicity;
        this.interestAllocation = interestAllocation;
        this.productType = ProductType.LIABILITY;
    }

    public /* synthetic */ Liability(String string, double d, double d2, Periodicity periodicity, FundsAllocation fundsAllocation, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = 0.0;
        }
        if ((n & 4) != 0) {
            d2 = 0.0;
        }
        if ((n & 8) != 0) {
            periodicity = Periodicity.YEARLY;
        }
        if ((n & 0x10) != 0) {
            fundsAllocation = FundsAllocation.DISBURSE;
        }
        this(string, d, d2, periodicity, fundsAllocation);
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @Override
    public double getReconBalance() {
        return this.reconBalance;
    }

    public final double getInterestRate() {
        return this.interestRate;
    }

    @NotNull
    public final Periodicity getInterestPeriodicity() {
        return this.interestPeriodicity;
    }

    @NotNull
    public final FundsAllocation getInterestAllocation() {
        return this.interestAllocation;
    }

    @Override
    @NotNull
    public ProductType getProductType() {
        return this.productType;
    }

    @Override
    @NotNull
    public List<PositionCompo> createCompos(@NotNull Portfolio portfolio, @NotNull Position pos) {
        Intrinsics.checkNotNullParameter((Object)portfolio, (String)"portfolio");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        List compos = new ArrayList();
        if (!(this.interestRate == 0.0)) {
            compos.add(new YieldCompo(pos, "interest", ValueProviders.INSTANCE.eomBalance(pos), ValueProviders.INSTANCE.constValue(this.interestRate), this.interestPeriodicity, BookingKind.INTEREST, this.interestAllocation));
        }
        return compos;
    }

    @Override
    @NotNull
    public Position createPosition(@NotNull Portfolio portfolio) {
        return Valuable.DefaultImpls.createPosition(this, portfolio);
    }

    @NotNull
    public final String component1() {
        return this.tag;
    }

    public final double component2() {
        return this.reconBalance;
    }

    public final double component3() {
        return this.interestRate;
    }

    @NotNull
    public final Periodicity component4() {
        return this.interestPeriodicity;
    }

    @NotNull
    public final FundsAllocation component5() {
        return this.interestAllocation;
    }

    @NotNull
    public final Liability copy(@NotNull String tag, double reconBalance, double interestRate, @NotNull Periodicity interestPeriodicity, @NotNull FundsAllocation interestAllocation) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)interestPeriodicity), (String)"interestPeriodicity");
        Intrinsics.checkNotNullParameter((Object)((Object)interestAllocation), (String)"interestAllocation");
        return new Liability(tag, reconBalance, interestRate, interestPeriodicity, interestAllocation);
    }

    public static /* synthetic */ Liability copy$default(Liability liability, String string, double d, double d2, Periodicity periodicity, FundsAllocation fundsAllocation, int n, Object object) {
        if ((n & 1) != 0) {
            string = liability.tag;
        }
        if ((n & 2) != 0) {
            d = liability.reconBalance;
        }
        if ((n & 4) != 0) {
            d2 = liability.interestRate;
        }
        if ((n & 8) != 0) {
            periodicity = liability.interestPeriodicity;
        }
        if ((n & 0x10) != 0) {
            fundsAllocation = liability.interestAllocation;
        }
        return liability.copy(string, d, d2, periodicity, fundsAllocation);
    }

    @NotNull
    public String toString() {
        return "Liability(tag=" + this.tag + ", reconBalance=" + this.reconBalance + ", interestRate=" + this.interestRate + ", interestPeriodicity=" + this.interestPeriodicity + ", interestAllocation=" + this.interestAllocation + ")";
    }

    public int hashCode() {
        int result = this.tag.hashCode();
        result = result * 31 + Double.hashCode(this.reconBalance);
        result = result * 31 + Double.hashCode(this.interestRate);
        result = result * 31 + this.interestPeriodicity.hashCode();
        result = result * 31 + this.interestAllocation.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Liability)) {
            return false;
        }
        Liability liability = (Liability)other;
        if (!Intrinsics.areEqual((Object)this.tag, (Object)liability.tag)) {
            return false;
        }
        if (Double.compare(this.reconBalance, liability.reconBalance) != 0) {
            return false;
        }
        if (Double.compare(this.interestRate, liability.interestRate) != 0) {
            return false;
        }
        if (this.interestPeriodicity != liability.interestPeriodicity) {
            return false;
        }
        return this.interestAllocation == liability.interestAllocation;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0012\u0010\n\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/fincast/household/impl/Liability$Builder;", "", "()V", "interestAllocation", "Lio/fincast/enums/FundsAllocation;", "interestPeriodicity", "Lio/fincast/enums/Periodicity;", "interestRate", "", "Ljava/lang/Double;", "reconBalance", "tag", "", "build", "Lio/fincast/household/impl/Liability;", "fundsAllocation", "fincast"})
    @SourceDebugExtension(value={"SMAP\nLiability.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Liability.kt\nio/fincast/household/impl/Liability$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n1#2:67\n*E\n"})
    public static final class Builder {
        @Nullable
        private String tag;
        @Nullable
        private Double reconBalance;
        @Nullable
        private Double interestRate;
        @Nullable
        private Periodicity interestPeriodicity;
        @Nullable
        private FundsAllocation interestAllocation;

        @NotNull
        public final Builder tag(@NotNull String tag) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Builder $this$tag_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$tag_u24lambda_u240.tag = tag;
            return builder;
        }

        @NotNull
        public final Builder reconBalance(double reconBalance) {
            Builder builder;
            Builder $this$reconBalance_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$reconBalance_u24lambda_u241.reconBalance = reconBalance;
            return builder;
        }

        @NotNull
        public final Builder interestRate(double interestRate) {
            Builder builder;
            Builder $this$interestRate_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$interestRate_u24lambda_u242.interestRate = interestRate;
            return builder;
        }

        @NotNull
        public final Builder interestPeriodicity(@NotNull Periodicity interestPeriodicity) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)interestPeriodicity), (String)"interestPeriodicity");
            Builder $this$interestPeriodicity_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$interestPeriodicity_u24lambda_u243.interestPeriodicity = interestPeriodicity;
            return builder;
        }

        @NotNull
        public final Builder interestAllocation(@NotNull FundsAllocation fundsAllocation) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)fundsAllocation), (String)"fundsAllocation");
            Builder $this$interestAllocation_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$interestAllocation_u24lambda_u244.interestAllocation = fundsAllocation;
            return builder;
        }

        @NotNull
        public final Liability build() {
            FundsAllocation fundsAllocation;
            String string = this.tag;
            if (string == null) {
                throw new IllegalArgumentException("tag is required");
            }
            Double d = this.reconBalance;
            double d2 = d != null ? d : 0.0;
            Double d3 = this.interestRate;
            double d4 = d3 != null ? d3 : 0.0;
            Periodicity periodicity = this.interestPeriodicity;
            if (periodicity == null) {
                periodicity = Periodicity.YEARLY;
            }
            if ((fundsAllocation = this.interestAllocation) == null) {
                fundsAllocation = FundsAllocation.DISBURSE;
            }
            return new Liability(string, d2, d4, periodicity, fundsAllocation);
        }
    }
}

