/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.household.impl;

import io.fincast.enums.BookingKind;
import io.fincast.enums.Periodicity;
import io.fincast.household.AggregateBooking;
import io.fincast.household.Booking;
import io.fincast.household.Holding;
import io.fincast.household.Household;
import io.fincast.household.LifecycleBooking;
import io.fincast.household.Person;
import io.fincast.household.ReconciliationBooking;
import io.fincast.household.impl.MoneyAccount;
import io.fincast.portfolio.Portfolio;
import io.fincast.portfolio.Position;
import io.fincast.portfolio.SimDate;
import io.fincast.portfolio.impl.PortfolioImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00032\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0016H\u0002J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#H\u0002R\u0014\u0010\n\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0014\u0010\u0013\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\fR\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006$"}, d2={"Lio/fincast/household/impl/HouseholdImpl;", "Lio/fincast/household/Household;", "persons", "", "Lio/fincast/household/Person;", "reconDate", "Lio/fincast/portfolio/SimDate;", "holdings", "Lio/fincast/household/Holding;", "(Ljava/util/List;Lio/fincast/portfolio/SimDate;Ljava/util/List;)V", "externalMoney", "getExternalMoney", "()Lio/fincast/household/Holding;", "getHoldings", "()Ljava/util/List;", "holdingsByTag", "", "", "getPersons", "pocketMoney", "getPocketMoney", "portfolio", "Lio/fincast/portfolio/Portfolio;", "getPortfolio", "()Lio/fincast/portfolio/Portfolio;", "getReconDate", "()Lio/fincast/portfolio/SimDate;", "calcProjection", "Lio/fincast/household/Booking;", "endDate", "periodicity", "Lio/fincast/enums/Periodicity;", "createPortfolio", "fromBooking", "booking", "Lio/fincast/portfolio/Booking;", "fincast"})
@SourceDebugExtension(value={"SMAP\nHouseholdImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HouseholdImpl.kt\nio/fincast/household/impl/HouseholdImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1194#2,2:76\n1222#2,4:78\n1549#2:83\n1620#2,3:84\n1549#2:87\n1620#2,3:88\n1#3:82\n*S KotlinDebug\n*F\n+ 1 HouseholdImpl.kt\nio/fincast/household/impl/HouseholdImpl\n*L\n29#1:76,2\n29#1:78,4\n35#1:83\n35#1:84,3\n43#1:87\n43#1:88,3\n*E\n"})
public final class HouseholdImpl
implements Household {
    @NotNull
    private final List<Person> persons;
    @NotNull
    private final SimDate reconDate;
    @NotNull
    private final List<Holding> holdings;
    @NotNull
    private final Holding pocketMoney;
    @NotNull
    private final Holding externalMoney;
    @NotNull
    private final Portfolio portfolio;
    @NotNull
    private final Map<String, Holding> holdingsByTag;

    /*
     * WARNING - void declaration
     */
    public HouseholdImpl(@NotNull List<? extends Person> persons, @NotNull SimDate reconDate, @NotNull List<? extends Holding> holdings) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter(persons, (String)"persons");
        Intrinsics.checkNotNullParameter((Object)reconDate, (String)"reconDate");
        Intrinsics.checkNotNullParameter(holdings, (String)"holdings");
        this.persons = persons;
        this.reconDate = reconDate;
        this.holdings = holdings;
        this.pocketMoney = new MoneyAccount("#pocketMoney", 0.0, null, null, null, 30, null);
        this.externalMoney = new MoneyAccount("#externalMoney", 0.0, null, null, null, 30, null);
        List allHoldings = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.getHoldings(), (Object)this.getPocketMoney()), (Object)this.getExternalMoney());
        Iterable iterable = allHoldings;
        HouseholdImpl householdImpl = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var8_9 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Holding holding = (Holding)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getTag(), element$iv$iv);
        }
        householdImpl.holdingsByTag = destination$iv$iv;
        this.portfolio = this.createPortfolio();
    }

    @Override
    @NotNull
    public List<Person> getPersons() {
        return this.persons;
    }

    @Override
    @NotNull
    public SimDate getReconDate() {
        return this.reconDate;
    }

    @Override
    @NotNull
    public List<Holding> getHoldings() {
        return this.holdings;
    }

    @Override
    @NotNull
    public Holding getPocketMoney() {
        return this.pocketMoney;
    }

    @Override
    @NotNull
    public Holding getExternalMoney() {
        return this.externalMoney;
    }

    @Override
    @NotNull
    public Portfolio getPortfolio() {
        return this.portfolio;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Booking> calcProjection(@NotNull SimDate endDate, @NotNull Periodicity periodicity) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)endDate, (String)"endDate");
        Intrinsics.checkNotNullParameter((Object)((Object)periodicity), (String)"periodicity");
        if (!(periodicity == Periodicity.MONTHLY || periodicity == Periodicity.YEARLY)) {
            boolean $i$a$-check-HouseholdImpl$calcProjection$22 = false;
            String $i$a$-check-HouseholdImpl$calcProjection$22 = "periodicity must be MONTHLY or YEARLY";
            throw new IllegalStateException($i$a$-check-HouseholdImpl$calcProjection$22.toString());
        }
        Iterable $this$map$iv = this.getPortfolio().calcProjection(endDate, periodicity);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            io.fincast.portfolio.Booking booking = (io.fincast.portfolio.Booking)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.fromBooking((io.fincast.portfolio.Booking)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Portfolio createPortfolio() {
        void $this$mapTo$iv$iv;
        Portfolio portfolio = new PortfolioImpl(this.getReconDate());
        Position pocketMoney = this.getPocketMoney().createPosition(portfolio);
        Position externalMoney = this.getExternalMoney().createPosition(portfolio);
        portfolio.initAuxPositions(pocketMoney, externalMoney);
        Iterable $this$map$iv = this.getHoldings();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Holding holding = (Holding)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.createPosition(portfolio));
        }
        List positions = (List)destination$iv$iv;
        portfolio.initPositions(positions);
        return portfolio;
    }

    private final Booking fromBooking(io.fincast.portfolio.Booking booking) {
        Booking booking2;
        io.fincast.portfolio.Booking booking3 = booking;
        if (booking3 instanceof io.fincast.portfolio.ReconciliationBooking) {
            Holding holding = this.holdingsByTag.get(booking.getPosition().getTag());
            Intrinsics.checkNotNull((Object)holding);
            booking2 = new ReconciliationBooking(holding, booking.getDate(), booking.getAmount());
        } else if (booking3 instanceof io.fincast.portfolio.LifecycleBooking) {
            Holding holding = this.holdingsByTag.get(booking.getPosition().getTag());
            Intrinsics.checkNotNull((Object)holding);
            Holding holding2 = holding;
            SimDate simDate = booking.getDate();
            double d = booking.getAmount();
            BookingKind bookingKind = booking.getBookingKind();
            Position it = ((io.fincast.portfolio.LifecycleBooking)booking).getRefPosition();
            boolean bl = false;
            Holding holding3 = this.holdingsByTag.get(it.getTag());
            Intrinsics.checkNotNull((Object)holding3);
            Holding holding4 = holding3;
            String string = ((io.fincast.portfolio.LifecycleBooking)booking).getRefCompo().getTag();
            booking2 = new LifecycleBooking(holding2, simDate, bookingKind, d, holding4, string);
        } else if (booking3 instanceof io.fincast.portfolio.AggregateBooking) {
            Holding holding = this.holdingsByTag.get(booking.getPosition().getTag());
            Intrinsics.checkNotNull((Object)holding);
            booking2 = new AggregateBooking(holding, booking.getDate(), booking.getAmount(), ((io.fincast.portfolio.AggregateBooking)booking).getYield());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return booking2;
    }
}

