/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.household.impl;

import io.fincast.enums.FundsAllocation;
import io.fincast.enums.Periodicity;
import io.fincast.enums.ProductType;
import io.fincast.household.Contract;
import io.fincast.portfolio.Portfolio;
import io.fincast.portfolio.Position;
import io.fincast.portfolio.PositionCompo;
import io.fincast.portfolio.SimDate;
import io.fincast.portfolio.ValueProvider;
import io.fincast.portfolio.ValueProviders;
import io.fincast.portfolio.impl.CashflowCompo;
import io.fincast.portfolio.impl.TransferCompo;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u00015B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J\t\u0010!\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003JE\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u0005H\u00c6\u0001J\u001e\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020,2\u0006\u0010)\u001a\u00020*H\u0016J\u0013\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u000101H\u00d6\u0003J\t\u00102\u001a\u000203H\u00d6\u0001J\t\u00104\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\r\u00a8\u00066"}, d2={"Lio/fincast/household/impl/ChPillarTwo;", "Lio/fincast/household/Contract;", "tag", "", "reconBalance", "", "retirementDate", "Lio/fincast/portfolio/SimDate;", "vestedBenefits", "capitalWithdrawal", "conversionRate", "(Ljava/lang/String;DLio/fincast/portfolio/SimDate;DDD)V", "getCapitalWithdrawal", "()D", "getConversionRate", "endDate", "", "getEndDate", "()Ljava/lang/Void;", "productType", "Lio/fincast/enums/ProductType;", "getProductType", "()Lio/fincast/enums/ProductType;", "getReconBalance", "getRetirementDate", "()Lio/fincast/portfolio/SimDate;", "startDate", "getStartDate", "getTag", "()Ljava/lang/String;", "getVestedBenefits", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "createCompos", "", "Lio/fincast/portfolio/PositionCompo;", "portfolio", "Lio/fincast/portfolio/Portfolio;", "pos", "Lio/fincast/portfolio/Position;", "createPosition", "equals", "", "other", "", "hashCode", "", "toString", "Builder", "fincast"})
public final class ChPillarTwo
implements Contract {
    @NotNull
    private final String tag;
    private final double reconBalance;
    @NotNull
    private final SimDate retirementDate;
    private final double vestedBenefits;
    private final double capitalWithdrawal;
    private final double conversionRate;
    @NotNull
    private final ProductType productType;
    @NotNull
    private final SimDate startDate;
    @Nullable
    private final Void endDate;

    public ChPillarTwo(@NotNull String tag, double reconBalance, @NotNull SimDate retirementDate, double vestedBenefits, double capitalWithdrawal, double conversionRate) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)retirementDate, (String)"retirementDate");
        this.tag = tag;
        this.reconBalance = reconBalance;
        this.retirementDate = retirementDate;
        this.vestedBenefits = vestedBenefits;
        this.capitalWithdrawal = capitalWithdrawal;
        this.conversionRate = conversionRate;
        this.productType = ProductType.INCOME;
        this.startDate = this.retirementDate;
    }

    public /* synthetic */ ChPillarTwo(String string, double d, SimDate simDate, double d2, double d3, double d4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = 0.0;
        }
        if ((n & 8) != 0) {
            d2 = 0.0;
        }
        if ((n & 0x10) != 0) {
            d3 = 0.0;
        }
        if ((n & 0x20) != 0) {
            d4 = 0.0;
        }
        this(string, d, simDate, d2, d3, d4);
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    public final double getReconBalance() {
        return this.reconBalance;
    }

    @NotNull
    public final SimDate getRetirementDate() {
        return this.retirementDate;
    }

    public final double getVestedBenefits() {
        return this.vestedBenefits;
    }

    public final double getCapitalWithdrawal() {
        return this.capitalWithdrawal;
    }

    public final double getConversionRate() {
        return this.conversionRate;
    }

    @Override
    @NotNull
    public ProductType getProductType() {
        return this.productType;
    }

    @Override
    @NotNull
    public SimDate getStartDate() {
        return this.startDate;
    }

    @Nullable
    public Void getEndDate() {
        return this.endDate;
    }

    @Override
    @NotNull
    public Position createPosition(@NotNull Portfolio portfolio) {
        Intrinsics.checkNotNullParameter((Object)portfolio, (String)"portfolio");
        Position pos = Contract.DefaultImpls.createPosition(this, portfolio);
        if (!(this.reconBalance == 0.0)) {
            pos.bookReconciliation(portfolio.getReconDate(), this.reconBalance);
        }
        return pos;
    }

    @Override
    @NotNull
    public List<PositionCompo> createCompos(@NotNull Portfolio portfolio, @NotNull Position pos) {
        Periodicity periodicity;
        SimDate simDate;
        ValueProvider<Double> valueProvider;
        Object object;
        Intrinsics.checkNotNullParameter((Object)portfolio, (String)"portfolio");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (this.vestedBenefits == 0.0) {
            return CollectionsKt.emptyList();
        }
        List compos = new ArrayList();
        double capitalContribution = this.vestedBenefits - this.reconBalance;
        double monthlyContribution = capitalContribution / (double)this.retirementDate.minus(portfolio.getReconDate());
        ValueProvider<Double> valueProvider2 = ValueProviders.INSTANCE.constValue(monthlyContribution);
        SimDate simDate2 = this.retirementDate;
        Periodicity periodicity2 = Periodicity.MONTHLY;
        FundsAllocation fundsAllocation = FundsAllocation.COMPOUND;
        compos.add(new CashflowCompo(pos, "capitalContribution", fundsAllocation, valueProvider2, 1, periodicity2, null, simDate2, false, 320, null));
        double capital = this.capitalWithdrawal <= 100.0 ? this.capitalWithdrawal / 100.0 * this.vestedBenefits : this.capitalWithdrawal;
        double pensionBase = this.vestedBenefits - capital;
        if (!(capital == 0.0)) {
            object = portfolio.getPocketMoney();
            valueProvider = ValueProviders.INSTANCE.constValue(capital);
            simDate = this.retirementDate.plus(1);
            periodicity = Periodicity.MATURITY;
            compos.add(new TransferCompo(pos, "capitalWithdrawal", pos, (Position)object, valueProvider, -1, periodicity, null, simDate, 128, null));
        }
        if (!(pensionBase == 0.0)) {
            object = FundsAllocation.DISBURSE;
            valueProvider = ValueProviders.INSTANCE.constValue(pensionBase * this.conversionRate / 100.0 / (double)12);
            simDate = this.retirementDate.plus(1);
            periodicity = Periodicity.MONTHLY;
            compos.add(new CashflowCompo(pos, "pension", (FundsAllocation)((Object)object), valueProvider, 1, periodicity, simDate, null, false, 384, null));
        }
        return compos;
    }

    @NotNull
    public final String component1() {
        return this.tag;
    }

    public final double component2() {
        return this.reconBalance;
    }

    @NotNull
    public final SimDate component3() {
        return this.retirementDate;
    }

    public final double component4() {
        return this.vestedBenefits;
    }

    public final double component5() {
        return this.capitalWithdrawal;
    }

    public final double component6() {
        return this.conversionRate;
    }

    @NotNull
    public final ChPillarTwo copy(@NotNull String tag, double reconBalance, @NotNull SimDate retirementDate, double vestedBenefits, double capitalWithdrawal, double conversionRate) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)retirementDate, (String)"retirementDate");
        return new ChPillarTwo(tag, reconBalance, retirementDate, vestedBenefits, capitalWithdrawal, conversionRate);
    }

    public static /* synthetic */ ChPillarTwo copy$default(ChPillarTwo chPillarTwo, String string, double d, SimDate simDate, double d2, double d3, double d4, int n, Object object) {
        if ((n & 1) != 0) {
            string = chPillarTwo.tag;
        }
        if ((n & 2) != 0) {
            d = chPillarTwo.reconBalance;
        }
        if ((n & 4) != 0) {
            simDate = chPillarTwo.retirementDate;
        }
        if ((n & 8) != 0) {
            d2 = chPillarTwo.vestedBenefits;
        }
        if ((n & 0x10) != 0) {
            d3 = chPillarTwo.capitalWithdrawal;
        }
        if ((n & 0x20) != 0) {
            d4 = chPillarTwo.conversionRate;
        }
        return chPillarTwo.copy(string, d, simDate, d2, d3, d4);
    }

    @NotNull
    public String toString() {
        return "ChPillarTwo(tag=" + this.tag + ", reconBalance=" + this.reconBalance + ", retirementDate=" + this.retirementDate + ", vestedBenefits=" + this.vestedBenefits + ", capitalWithdrawal=" + this.capitalWithdrawal + ", conversionRate=" + this.conversionRate + ")";
    }

    public int hashCode() {
        int result = this.tag.hashCode();
        result = result * 31 + Double.hashCode(this.reconBalance);
        result = result * 31 + this.retirementDate.hashCode();
        result = result * 31 + Double.hashCode(this.vestedBenefits);
        result = result * 31 + Double.hashCode(this.capitalWithdrawal);
        result = result * 31 + Double.hashCode(this.conversionRate);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ChPillarTwo)) {
            return false;
        }
        ChPillarTwo chPillarTwo = (ChPillarTwo)other;
        if (!Intrinsics.areEqual((Object)this.tag, (Object)chPillarTwo.tag)) {
            return false;
        }
        if (Double.compare(this.reconBalance, chPillarTwo.reconBalance) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.retirementDate, (Object)chPillarTwo.retirementDate)) {
            return false;
        }
        if (Double.compare(this.vestedBenefits, chPillarTwo.vestedBenefits) != 0) {
            return false;
        }
        if (Double.compare(this.capitalWithdrawal, chPillarTwo.capitalWithdrawal) != 0) {
            return false;
        }
        return Double.compare(this.conversionRate, chPillarTwo.conversionRate) == 0;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0004R\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006\u000f"}, d2={"Lio/fincast/household/impl/ChPillarTwo$Builder;", "", "()V", "capitalWithdrawal", "", "Ljava/lang/Double;", "conversionRate", "reconBalance", "retirementDate", "Lio/fincast/portfolio/SimDate;", "tag", "", "vestedBenefits", "build", "Lio/fincast/household/impl/ChPillarTwo;", "fincast"})
    @SourceDebugExtension(value={"SMAP\nChPillarTwo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChPillarTwo.kt\nio/fincast/household/impl/ChPillarTwo$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1#2:113\n*E\n"})
    public static final class Builder {
        @Nullable
        private String tag;
        @Nullable
        private Double reconBalance;
        @Nullable
        private SimDate retirementDate;
        @Nullable
        private Double capitalWithdrawal;
        @Nullable
        private Double vestedBenefits;
        @Nullable
        private Double conversionRate;

        @NotNull
        public final Builder tag(@NotNull String tag) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Builder $this$tag_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$tag_u24lambda_u240.tag = tag;
            return builder;
        }

        @NotNull
        public final Builder reconBalance(double reconBalance) {
            Builder builder;
            Builder $this$reconBalance_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$reconBalance_u24lambda_u241.reconBalance = reconBalance;
            return builder;
        }

        @NotNull
        public final Builder retirementDate(@NotNull SimDate retirementDate) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)retirementDate, (String)"retirementDate");
            Builder $this$retirementDate_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$retirementDate_u24lambda_u242.retirementDate = retirementDate;
            return builder;
        }

        @NotNull
        public final Builder capitalWithdrawal(double capitalWithdrawal) {
            Builder builder;
            Builder $this$capitalWithdrawal_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$capitalWithdrawal_u24lambda_u243.capitalWithdrawal = capitalWithdrawal;
            return builder;
        }

        @NotNull
        public final Builder vestedBenefits(double vestedBenefits) {
            Builder builder;
            Builder $this$vestedBenefits_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$vestedBenefits_u24lambda_u244.vestedBenefits = vestedBenefits;
            return builder;
        }

        @NotNull
        public final Builder conversionRate(double conversionRate) {
            Builder builder;
            Builder $this$conversionRate_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$conversionRate_u24lambda_u245.conversionRate = conversionRate;
            return builder;
        }

        @NotNull
        public final ChPillarTwo build() {
            String string = this.tag;
            if (string == null) {
                throw new IllegalArgumentException("tag is required");
            }
            String string2 = string;
            SimDate simDate = this.retirementDate;
            if (simDate == null) {
                throw new IllegalArgumentException("retirementDate is required");
            }
            SimDate simDate2 = simDate;
            Double d = this.capitalWithdrawal;
            double d2 = d != null ? d : 0.0;
            Double d3 = this.vestedBenefits;
            double d4 = d3 != null ? d3 : 0.0;
            Double d5 = this.conversionRate;
            double d6 = d5 != null ? d5 : 0.0;
            return new ChPillarTwo(string2, 0.0, simDate2, d4, d2, d6, 2, null);
        }
    }
}

