/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.household;

import io.fincast.enums.BookingKind;
import io.fincast.household.Booking;
import io.fincast.household.Holding;
import io.fincast.portfolio.SimDate;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\fH\u00c6\u0003JE\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u00d6\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J\b\u0010&\u001a\u00020\fH\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015\u00a8\u0006'"}, d2={"Lio/fincast/household/LifecycleBooking;", "Lio/fincast/household/Booking;", "holding", "Lio/fincast/household/Holding;", "date", "Lio/fincast/portfolio/SimDate;", "bookingKind", "Lio/fincast/enums/BookingKind;", "amount", "", "refHolding", "refCompo", "", "(Lio/fincast/household/Holding;Lio/fincast/portfolio/SimDate;Lio/fincast/enums/BookingKind;DLio/fincast/household/Holding;Ljava/lang/String;)V", "getAmount", "()D", "getBookingKind", "()Lio/fincast/enums/BookingKind;", "getDate", "()Lio/fincast/portfolio/SimDate;", "getHolding", "()Lio/fincast/household/Holding;", "getRefCompo", "()Ljava/lang/String;", "getRefHolding", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "", "hashCode", "", "toString", "fincast"})
public final class LifecycleBooking
implements Booking {
    @NotNull
    private final Holding holding;
    @NotNull
    private final SimDate date;
    @NotNull
    private final BookingKind bookingKind;
    private final double amount;
    @NotNull
    private final Holding refHolding;
    @NotNull
    private final String refCompo;

    public LifecycleBooking(@NotNull Holding holding, @NotNull SimDate date, @NotNull BookingKind bookingKind, double amount, @NotNull Holding refHolding, @NotNull String refCompo) {
        Intrinsics.checkNotNullParameter((Object)holding, (String)"holding");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)((Object)bookingKind), (String)"bookingKind");
        Intrinsics.checkNotNullParameter((Object)refHolding, (String)"refHolding");
        Intrinsics.checkNotNullParameter((Object)refCompo, (String)"refCompo");
        this.holding = holding;
        this.date = date;
        this.bookingKind = bookingKind;
        this.amount = amount;
        this.refHolding = refHolding;
        this.refCompo = refCompo;
    }

    @Override
    @NotNull
    public Holding getHolding() {
        return this.holding;
    }

    @Override
    @NotNull
    public SimDate getDate() {
        return this.date;
    }

    @Override
    @NotNull
    public BookingKind getBookingKind() {
        return this.bookingKind;
    }

    @Override
    public double getAmount() {
        return this.amount;
    }

    @NotNull
    public final Holding getRefHolding() {
        return this.refHolding;
    }

    @NotNull
    public final String getRefCompo() {
        return this.refCompo;
    }

    @NotNull
    public String toString() {
        SimDate simDate = this.getDate();
        String string = this.getBookingKind().getCode();
        String string2 = this.getHolding().getTag();
        String string3 = "%.0f";
        Object[] objectArray = new Object[]{this.getAmount()};
        String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
        return simDate + ": " + string + " " + string2 + " " + string4 + " (" + this.refHolding.getTag() + "." + this.refCompo + ")";
    }

    @NotNull
    public final Holding component1() {
        return this.holding;
    }

    @NotNull
    public final SimDate component2() {
        return this.date;
    }

    @NotNull
    public final BookingKind component3() {
        return this.bookingKind;
    }

    public final double component4() {
        return this.amount;
    }

    @NotNull
    public final Holding component5() {
        return this.refHolding;
    }

    @NotNull
    public final String component6() {
        return this.refCompo;
    }

    @NotNull
    public final LifecycleBooking copy(@NotNull Holding holding, @NotNull SimDate date, @NotNull BookingKind bookingKind, double amount, @NotNull Holding refHolding, @NotNull String refCompo) {
        Intrinsics.checkNotNullParameter((Object)holding, (String)"holding");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)((Object)bookingKind), (String)"bookingKind");
        Intrinsics.checkNotNullParameter((Object)refHolding, (String)"refHolding");
        Intrinsics.checkNotNullParameter((Object)refCompo, (String)"refCompo");
        return new LifecycleBooking(holding, date, bookingKind, amount, refHolding, refCompo);
    }

    public static /* synthetic */ LifecycleBooking copy$default(LifecycleBooking lifecycleBooking, Holding holding, SimDate simDate, BookingKind bookingKind, double d, Holding holding2, String string, int n, Object object) {
        if ((n & 1) != 0) {
            holding = lifecycleBooking.holding;
        }
        if ((n & 2) != 0) {
            simDate = lifecycleBooking.date;
        }
        if ((n & 4) != 0) {
            bookingKind = lifecycleBooking.bookingKind;
        }
        if ((n & 8) != 0) {
            d = lifecycleBooking.amount;
        }
        if ((n & 0x10) != 0) {
            holding2 = lifecycleBooking.refHolding;
        }
        if ((n & 0x20) != 0) {
            string = lifecycleBooking.refCompo;
        }
        return lifecycleBooking.copy(holding, simDate, bookingKind, d, holding2, string);
    }

    public int hashCode() {
        int result = this.holding.hashCode();
        result = result * 31 + this.date.hashCode();
        result = result * 31 + this.bookingKind.hashCode();
        result = result * 31 + Double.hashCode(this.amount);
        result = result * 31 + this.refHolding.hashCode();
        result = result * 31 + this.refCompo.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LifecycleBooking)) {
            return false;
        }
        LifecycleBooking lifecycleBooking = (LifecycleBooking)other;
        if (!Intrinsics.areEqual((Object)this.holding, (Object)lifecycleBooking.holding)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.date, (Object)lifecycleBooking.date)) {
            return false;
        }
        if (this.bookingKind != lifecycleBooking.bookingKind) {
            return false;
        }
        if (Double.compare(this.amount, lifecycleBooking.amount) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.refHolding, (Object)lifecycleBooking.refHolding)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.refCompo, (Object)lifecycleBooking.refCompo);
    }
}

