/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.household;

import io.fincast.household.Aggregate;
import io.fincast.portfolio.SimDate;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J;\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lio/fincast/household/HouseholdPeriod;", "Lio/fincast/household/Aggregate;", "date", "Lio/fincast/portfolio/SimDate;", "assets", "", "liabilities", "income", "expense", "(Lio/fincast/portfolio/SimDate;DDDD)V", "getAssets", "()D", "getDate", "()Lio/fincast/portfolio/SimDate;", "getExpense", "getIncome", "getLiabilities", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "fincast"})
public final class HouseholdPeriod
implements Aggregate {
    @NotNull
    private final SimDate date;
    private final double assets;
    private final double liabilities;
    private final double income;
    private final double expense;

    public HouseholdPeriod(@NotNull SimDate date, double assets, double liabilities, double income, double expense) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        this.date = date;
        this.assets = assets;
        this.liabilities = liabilities;
        this.income = income;
        this.expense = expense;
    }

    @Override
    @NotNull
    public SimDate getDate() {
        return this.date;
    }

    public final double getAssets() {
        return this.assets;
    }

    public final double getLiabilities() {
        return this.liabilities;
    }

    public final double getIncome() {
        return this.income;
    }

    public final double getExpense() {
        return this.expense;
    }

    @NotNull
    public String toString() {
        SimDate simDate = this.getDate();
        String string = "%.0f";
        Object[] objectArray = new Object[]{this.assets};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        string = "%.0f";
        objectArray = new Object[]{this.liabilities};
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
        string = "%.0f";
        objectArray = new Object[]{this.income};
        String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
        string = "%.0f";
        objectArray = new Object[]{this.expense};
        String string5 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(format, *args)");
        return simDate + ": HH  " + string2 + " " + string3 + " " + string4 + " " + string5;
    }

    @NotNull
    public final SimDate component1() {
        return this.date;
    }

    public final double component2() {
        return this.assets;
    }

    public final double component3() {
        return this.liabilities;
    }

    public final double component4() {
        return this.income;
    }

    public final double component5() {
        return this.expense;
    }

    @NotNull
    public final HouseholdPeriod copy(@NotNull SimDate date, double assets, double liabilities, double income, double expense) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return new HouseholdPeriod(date, assets, liabilities, income, expense);
    }

    public static /* synthetic */ HouseholdPeriod copy$default(HouseholdPeriod householdPeriod, SimDate simDate, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 1) != 0) {
            simDate = householdPeriod.date;
        }
        if ((n & 2) != 0) {
            d = householdPeriod.assets;
        }
        if ((n & 4) != 0) {
            d2 = householdPeriod.liabilities;
        }
        if ((n & 8) != 0) {
            d3 = householdPeriod.income;
        }
        if ((n & 0x10) != 0) {
            d4 = householdPeriod.expense;
        }
        return householdPeriod.copy(simDate, d, d2, d3, d4);
    }

    public int hashCode() {
        int result = this.date.hashCode();
        result = result * 31 + Double.hashCode(this.assets);
        result = result * 31 + Double.hashCode(this.liabilities);
        result = result * 31 + Double.hashCode(this.income);
        result = result * 31 + Double.hashCode(this.expense);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HouseholdPeriod)) {
            return false;
        }
        HouseholdPeriod householdPeriod = (HouseholdPeriod)other;
        if (!Intrinsics.areEqual((Object)this.date, (Object)householdPeriod.date)) {
            return false;
        }
        if (Double.compare(this.assets, householdPeriod.assets) != 0) {
            return false;
        }
        if (Double.compare(this.liabilities, householdPeriod.liabilities) != 0) {
            return false;
        }
        if (Double.compare(this.income, householdPeriod.income) != 0) {
            return false;
        }
        return Double.compare(this.expense, householdPeriod.expense) == 0;
    }
}

