/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.household;

import io.fincast.household.Aggregate;
import io.fincast.household.Holding;
import io.fincast.portfolio.SimDate;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J;\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\b\u0010\u001f\u001a\u00020 H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006!"}, d2={"Lio/fincast/household/HoldingPeriod;", "Lio/fincast/household/Aggregate;", "date", "Lio/fincast/portfolio/SimDate;", "holding", "Lio/fincast/household/Holding;", "balance", "", "income", "expense", "(Lio/fincast/portfolio/SimDate;Lio/fincast/household/Holding;DDD)V", "getBalance", "()D", "getDate", "()Lio/fincast/portfolio/SimDate;", "getExpense", "getHolding", "()Lio/fincast/household/Holding;", "getIncome", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "fincast"})
public final class HoldingPeriod
implements Aggregate {
    @NotNull
    private final SimDate date;
    @NotNull
    private final Holding holding;
    private final double balance;
    private final double income;
    private final double expense;

    public HoldingPeriod(@NotNull SimDate date, @NotNull Holding holding, double balance, double income, double expense) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)holding, (String)"holding");
        this.date = date;
        this.holding = holding;
        this.balance = balance;
        this.income = income;
        this.expense = expense;
    }

    @Override
    @NotNull
    public SimDate getDate() {
        return this.date;
    }

    @NotNull
    public final Holding getHolding() {
        return this.holding;
    }

    public final double getBalance() {
        return this.balance;
    }

    public final double getIncome() {
        return this.income;
    }

    public final double getExpense() {
        return this.expense;
    }

    @NotNull
    public String toString() {
        SimDate simDate = this.getDate();
        String string = this.holding.getTag();
        String string2 = "%.0f";
        Object[] objectArray = new Object[]{this.balance};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
        string2 = "%.0f";
        objectArray = new Object[]{this.income};
        String string4 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
        string2 = "%.0f";
        objectArray = new Object[]{this.expense};
        String string5 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(format, *args)");
        return simDate + ": Hld " + string + " " + string3 + " " + string4 + " " + string5;
    }

    @NotNull
    public final SimDate component1() {
        return this.date;
    }

    @NotNull
    public final Holding component2() {
        return this.holding;
    }

    public final double component3() {
        return this.balance;
    }

    public final double component4() {
        return this.income;
    }

    public final double component5() {
        return this.expense;
    }

    @NotNull
    public final HoldingPeriod copy(@NotNull SimDate date, @NotNull Holding holding, double balance, double income, double expense) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)holding, (String)"holding");
        return new HoldingPeriod(date, holding, balance, income, expense);
    }

    public static /* synthetic */ HoldingPeriod copy$default(HoldingPeriod holdingPeriod, SimDate simDate, Holding holding, double d, double d2, double d3, int n, Object object) {
        if ((n & 1) != 0) {
            simDate = holdingPeriod.date;
        }
        if ((n & 2) != 0) {
            holding = holdingPeriod.holding;
        }
        if ((n & 4) != 0) {
            d = holdingPeriod.balance;
        }
        if ((n & 8) != 0) {
            d2 = holdingPeriod.income;
        }
        if ((n & 0x10) != 0) {
            d3 = holdingPeriod.expense;
        }
        return holdingPeriod.copy(simDate, holding, d, d2, d3);
    }

    public int hashCode() {
        int result = this.date.hashCode();
        result = result * 31 + this.holding.hashCode();
        result = result * 31 + Double.hashCode(this.balance);
        result = result * 31 + Double.hashCode(this.income);
        result = result * 31 + Double.hashCode(this.expense);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HoldingPeriod)) {
            return false;
        }
        HoldingPeriod holdingPeriod = (HoldingPeriod)other;
        if (!Intrinsics.areEqual((Object)this.date, (Object)holdingPeriod.date)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.holding, (Object)holdingPeriod.holding)) {
            return false;
        }
        if (Double.compare(this.balance, holdingPeriod.balance) != 0) {
            return false;
        }
        if (Double.compare(this.income, holdingPeriod.income) != 0) {
            return false;
        }
        return Double.compare(this.expense, holdingPeriod.expense) == 0;
    }
}

