/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.household;

import io.fincast.enums.BookingKind;
import io.fincast.household.Booking;
import io.fincast.household.Holding;
import io.fincast.portfolio.SimDate;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\b\u0010 \u001a\u00020!H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000b\u00a8\u0006\""}, d2={"Lio/fincast/household/AggregateBooking;", "Lio/fincast/household/Booking;", "holding", "Lio/fincast/household/Holding;", "date", "Lio/fincast/portfolio/SimDate;", "amount", "", "yield", "(Lio/fincast/household/Holding;Lio/fincast/portfolio/SimDate;DD)V", "getAmount", "()D", "bookingKind", "Lio/fincast/enums/BookingKind;", "getBookingKind", "()Lio/fincast/enums/BookingKind;", "getDate", "()Lio/fincast/portfolio/SimDate;", "getHolding", "()Lio/fincast/household/Holding;", "getYield", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "fincast"})
public final class AggregateBooking
implements Booking {
    @NotNull
    private final Holding holding;
    @NotNull
    private final SimDate date;
    private final double amount;
    private final double yield;
    @NotNull
    private final BookingKind bookingKind;

    public AggregateBooking(@NotNull Holding holding, @NotNull SimDate date, double amount, double yield) {
        Intrinsics.checkNotNullParameter((Object)holding, (String)"holding");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        this.holding = holding;
        this.date = date;
        this.amount = amount;
        this.yield = yield;
        this.bookingKind = BookingKind.AGGREGATE;
    }

    @Override
    @NotNull
    public Holding getHolding() {
        return this.holding;
    }

    @Override
    @NotNull
    public SimDate getDate() {
        return this.date;
    }

    @Override
    public double getAmount() {
        return this.amount;
    }

    public final double getYield() {
        return this.yield;
    }

    @Override
    @NotNull
    public BookingKind getBookingKind() {
        return this.bookingKind;
    }

    @NotNull
    public String toString() {
        SimDate simDate = this.getDate();
        String string = this.getBookingKind().getCode();
        String string2 = this.getHolding().getTag();
        String string3 = "%.0f";
        Object[] objectArray = new Object[]{this.getAmount()};
        String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
        string3 = "%.0f";
        objectArray = new Object[]{this.yield};
        String string5 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(format, *args)");
        return simDate + ": " + string + " " + string2 + " " + string4 + " " + string5;
    }

    @NotNull
    public final Holding component1() {
        return this.holding;
    }

    @NotNull
    public final SimDate component2() {
        return this.date;
    }

    public final double component3() {
        return this.amount;
    }

    public final double component4() {
        return this.yield;
    }

    @NotNull
    public final AggregateBooking copy(@NotNull Holding holding, @NotNull SimDate date, double amount, double yield) {
        Intrinsics.checkNotNullParameter((Object)holding, (String)"holding");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return new AggregateBooking(holding, date, amount, yield);
    }

    public static /* synthetic */ AggregateBooking copy$default(AggregateBooking aggregateBooking, Holding holding, SimDate simDate, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            holding = aggregateBooking.holding;
        }
        if ((n & 2) != 0) {
            simDate = aggregateBooking.date;
        }
        if ((n & 4) != 0) {
            d = aggregateBooking.amount;
        }
        if ((n & 8) != 0) {
            d2 = aggregateBooking.yield;
        }
        return aggregateBooking.copy(holding, simDate, d, d2);
    }

    public int hashCode() {
        int result = this.holding.hashCode();
        result = result * 31 + this.date.hashCode();
        result = result * 31 + Double.hashCode(this.amount);
        result = result * 31 + Double.hashCode(this.yield);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AggregateBooking)) {
            return false;
        }
        AggregateBooking aggregateBooking = (AggregateBooking)other;
        if (!Intrinsics.areEqual((Object)this.holding, (Object)aggregateBooking.holding)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.date, (Object)aggregateBooking.date)) {
            return false;
        }
        if (Double.compare(this.amount, aggregateBooking.amount) != 0) {
            return false;
        }
        return Double.compare(this.yield, aggregateBooking.yield) == 0;
    }
}

