package io.fincast.portfolio.impl

import io.fincast.portfolio.SimDate
import io.fincast.portfolio.ValueProvider
import io.fincast.portfolio.Position
import io.fincast.enums.Periodicity

data class TransferCompo(
	override val position: Position,
	override val tag: String,
	val fromPosition: Position,
	val toPosition: Position,
	val amount: ValueProvider<Double>,
	val sign: Int,
	val periodicity: Periodicity,
	val startDate: SimDate? = null,
	val endDate: SimDate? = null,
) : PositionCompoBase() {

	override fun handleLifecycle(date: SimDate) {
		if (periodicity.isCashflowDate(date, startDate, endDate)) {
			val amount = amount.getValue(date) * sign
			this.bookTransfer(date, fromPosition, toPosition, amount)
		}
	}

}
