package io.fincast.portfolio.impl

import io.fincast.enums.FundsAllocation
import io.fincast.portfolio.SimDate
import io.fincast.portfolio.ValueProvider
import io.fincast.portfolio.Position
import io.fincast.enums.Periodicity

/**
 * A cashflow component generates external cashflows (incoming or outgoing).
 */
data class CashflowCompo(
	override val position: Position,
	override val tag: String,
	val fundsAllocation: FundsAllocation,
	val amount: ValueProvider<Double>,
	val sign: Int,
	val periodicity: Periodicity,
	val startDate: SimDate? = null,
	val endDate: SimDate? = null,
	val proRata: Boolean = true,
) : PositionCompoBase() {

	override fun handleLifecycle(date: SimDate) {
		if (periodicity.isCashflowDate(date, startDate, endDate)) {
			var amount = amount.getValue(date) * sign
			val sop = periodicity.startOfPeriod(date)
			if (proRata && startDate != null && periodicity.months > 1 && sop < startDate) {
				amount = amount * (date - startDate) / periodicity.months
			}
			this.bookCashflow(date, amount, fundsAllocation)
		}
	}

}
