package io.fincast.portfolio

import io.fincast.enums.ProductType
import io.fincast.enums.BookingKind

interface Position {

	val portfolio: Portfolio

	val tag: String

	val productType: ProductType

	val compos: List<PositionCompo>

	fun getCompo(tag: String): PositionCompo? = compos.find { it.tag == tag }

	fun handlePositionLifecycle(date: SimDate)

	fun handlePortfolioLifecycle(date: SimDate)

	fun isReconciled(date: SimDate): Boolean

	fun getBalance(date: SimDate): Double

	fun getYield(date: SimDate): Double

	fun getTurnover(date: SimDate): Double

	fun getBookings(): List<Booking>

	fun getBookings(date: SimDate): List<Booking>

	fun getRefBookings(date: SimDate, refPos: Position): List<Booking>

	fun getPeriods(): List<Booking>

	fun getYield(): Double = compos.sumOf { it.getYield() }

	fun bookReconciliation(date: SimDate, balance: Double)

	fun bookTurnover(date: SimDate, bookingKind: BookingKind, turnover: Double, refCompo: PositionCompo)

	fun bookBalance(date: SimDate)

}
