package io.fincast.portfolio

import io.fincast.enums.Periodicity
import io.fincast.household.Holding
import io.fincast.portfolio.impl.PortfolioImpl

interface Portfolio {

	val reconDate: SimDate

	val positions: List<Position>

	val pocketMoney: Position

	val externalMoney: Position

	fun initAuxPositions(pocketMoney: Position, externalMoney: Position)

	fun initPositions(positions: List<Position>)

	fun getPositions(tag: String): List<Position>

	fun calcProjection(endDate: SimDate, periodicity: Periodicity): List<Booking>

	fun addBooking(booking: Booking)

}
