package io.fincast.household

import io.fincast.portfolio.Portfolio
import io.fincast.portfolio.Position

interface Valuable : Holding {

	val reconBalance: Double

	override fun createPosition(portfolio: Portfolio): Position {
		val pos = super.createPosition(portfolio)
		if (0.0 != reconBalance) {
			pos.bookReconciliation(portfolio.reconDate, reconBalance)
		}
		return pos
	}

}
