package io.fincast.portfolio.impl

import io.fincast.enums.BookingKind
import io.fincast.enums.FundsAllocation
import io.fincast.enums.Periodicity
import io.fincast.portfolio.ValueProvider
import io.fincast.util.SimDate

abstract class YieldCompoBase : PositionCompoBase() {

	abstract val amount: ValueProvider<Double> // eomBalance, eomCreditBalance, eomDebitBalance

	abstract val yieldRate: ValueProvider<Double>

	abstract val yieldPeriodicity: Periodicity

	abstract val bookingKind: BookingKind

	abstract val fundsAllocation: FundsAllocation

	override fun handleLifecycle(date: SimDate) {
		val amount = amount.getValue(this, date)
		val yieldRate = yieldRate.getValue(this, date)
		val yield = (amount ?: 0.0) * (yieldRate ?: 0.0) / 100 / Periodicity.MONTHS_IN_YEAR
		addYield(yield)
		if (yieldPeriodicity.isCashflowDate(date)) {
			bookYield(date, bookingKind, fundsAllocation)
		}
	}

}
