package io.fincast.portfolio.impl

import io.fincast.enums.Periodicity
import io.fincast.portfolio.Position
import io.fincast.portfolio.ValueProvider
import io.fincast.util.SimDate

data class TransferCompo(
	override val position: Position,
	override val tag: String,
	val fromPosition: Position,
	val toPosition: Position,
	val amount: ValueProvider<Double>,
	val sign: Int,
	val periodicity: Periodicity,
	val startDate: SimDate? = null,
	val endDate: SimDate? = null,
) : PositionCompoBase() {

	override val execSeqNr: Int = 2

	override fun handleLifecycle(date: SimDate) {
		if (periodicity.isCashflowDate(date, startDate, endDate)) {
			val amount = (amount.getValue(this, date) ?: 0.0) * sign
			this.bookTransfer(date, fromPosition, toPosition, amount)
		}
	}

}
