package io.fincast.portfolio.impl

import io.fincast.enums.BookingKind
import io.fincast.enums.FundsAllocation
import io.fincast.enums.Periodicity
import io.fincast.portfolio.Position
import io.fincast.portfolio.ValueProvider
import io.fincast.portfolio.ValueProviders

data class InterestCompo(
	override val position: Position,
	override val tag: String = "interest",
	override val amount: ValueProvider<Double> = ValueProviders.prevEomBalance(),
	val interestRate: ValueProvider<Double>,
	val interestPeriodicity: Periodicity,
	override val fundsAllocation: FundsAllocation
) : YieldCompoBase() {

	override val yieldRate: ValueProvider<Double> = interestRate

	override val yieldPeriodicity: Periodicity = interestPeriodicity

	override val bookingKind: BookingKind = BookingKind.INTEREST

}
