package io.fincast.portfolio.impl

import io.fincast.enums.BookingKind
import io.fincast.enums.FundsAllocation
import io.fincast.enums.Periodicity
import io.fincast.portfolio.Position
import io.fincast.portfolio.ValueProvider
import io.fincast.portfolio.ValueProviders

data class DividendCompo(
	override val position: Position,
	val dividendYield: ValueProvider<Double>,
	val dividendPeriodicity: Periodicity,
	override val fundsAllocation: FundsAllocation
) : YieldCompoBase() {

	override val tag: String = "dividend"

	override val amount: ValueProvider<Double> = ValueProviders.prevEomBalance()

	override val yieldRate: ValueProvider<Double> = dividendYield

	override val yieldPeriodicity: Periodicity = dividendPeriodicity

	override val bookingKind: BookingKind = BookingKind.DIVIDEND

}
