package io.fincast.portfolio.impl

import io.fincast.enums.BookingKind
import io.fincast.enums.FundsAllocation
import io.fincast.enums.Periodicity
import io.fincast.portfolio.Position
import io.fincast.portfolio.ValueProvider
import io.fincast.portfolio.ValueProviders

data class CapitalGainCompo(
	override val position: Position,
	val capitalGainRate: ValueProvider<Double>,
	val capitalGainPeriodicity: Periodicity = Periodicity.YEARLY
) : YieldCompoBase() {

	override val tag: String = "capitalGain"

	override val amount: ValueProvider<Double> = ValueProviders.prevEomBalance()

	override val yieldRate: ValueProvider<Double> = capitalGainRate

	override val yieldPeriodicity: Periodicity = capitalGainPeriodicity

	override val fundsAllocation: FundsAllocation = FundsAllocation.COMPOUND

	override val bookingKind: BookingKind = BookingKind.CAPITAL_GAIN

}
