package io.fincast.portfolio

object ValueProviders {

	@JvmStatic
	fun <T> constValue(value: T): ValueProvider<T> {
		return ValueProvider { _, _ ->
			return@ValueProvider value
		}
	}

	@JvmStatic
	fun currentRelativeValue(percentage: Double): ValueProvider<Double> {
		return ValueProvider { compo, date ->
			return@ValueProvider percentage / 100.0 * compo.position.getBalance(date)
		}
	}

	@JvmStatic
	fun prevEomBalance(): ValueProvider<Double> {
		return ValueProvider { compo, date ->
			return@ValueProvider compo.position.getBalance(date - 1)
		}
	}

	@JvmStatic
	fun prevEomCreditBalance(): ValueProvider<Double> {
		return ValueProvider { compo, date ->
			val eomBalance = compo.position.getBalance(date - 1)
			return@ValueProvider eomBalance.coerceAtLeast(0.0)
		}
	}

	@JvmStatic
	fun prevEomDebitBalance(): ValueProvider<Double> {
		return ValueProvider { compo, date ->
			val eomBalance = compo.position.getBalance(date - 1)
			return@ValueProvider eomBalance.coerceAtMost(0.0)
		}
	}

}
