package io.fincast.portfolio

import io.fincast.enums.BookingKind
import io.fincast.enums.ProductType
import io.fincast.util.SimDate

interface Position {

	val portfolio: Portfolio

	val tag: String

	val productType: ProductType

	val compos: List<PositionCompo>

	val isAux: Boolean get() = tag.startsWith("#")

	val isExternal: Boolean get() = tag == Portfolio.EXTERNAL_MONEY_TAG

	val isPocket: Boolean get() = tag == Portfolio.POCKET_MONEY_TAG

	fun getCompo(tag: String): PositionCompo? = compos.find { it.tag == tag }

	fun handlePositionLifecycle(date: SimDate)

	fun handlePortfolioLifecycle(date: SimDate)

	fun isReconciled(date: SimDate): Boolean

	fun getBalance(date: SimDate): Double

	fun getYield(date: SimDate): Double

	fun getTurnover(date: SimDate): Double

	fun getBookings(): List<PositionBooking>

	fun getBookings(date: SimDate): List<PositionBooking>

	fun getRefBookings(date: SimDate, refPos: Position): List<PositionBooking>

	fun getPeriods(): List<PositionAggregate>

	fun getYield(): Double = compos.sumOf { it.getYield() }

	fun bookReconciliation(date: SimDate, balance: Double)

	fun bookTurnover(date: SimDate, bookingKind: BookingKind, turnover: Double, refCompo: PositionCompo)

	fun addAggregate(date: SimDate)

}
