package io.fincast.portfolio

import io.fincast.enums.Periodicity
import io.fincast.util.SimDate

/**
 * A periodic aggregate for a position.
 *
 * First level of aggregation, reports the eop balance and yield of the position at a certain date.
 */
data class PositionAggregate(
	val position: Position,
	val date: SimDate,
	val balance: Double,
	val yield: Double,
	val inflows: Double,
	val outflows: Double,
	val gain: Double,
) {

	override fun toString(): String {
		return "${date}: ${position.tag} [${String.format("%.0f", balance)}, ${String.format("%.0f", yield)}] {->${String.format("%.0f", inflows)}, ${String.format("%.0f", outflows)}->, ${String.format("%.0f", gain)}}"
	}

}

/**
 * A periodic aggregate for a portfolio.
 *
 * Second level of aggregation, reports the eop balance and yield of the portfolio at a certain date.
 */
data class PortfolioAggregate(
	val date: SimDate,
	val assets: Double,
	val liabilities: Double,
	val yield: Double,
	val inflows: Double,
	val outflows: Double,
	val gain: Double,
) {

	override fun toString(): String {
		val balance = assets + liabilities
		return "${date}: [${String.format("%.0f", balance)}, ${String.format("%.0f", yield)}] {->${String.format("%.0f", inflows)}, ${String.format("%.0f", outflows)}->, ${String.format("%.0f", gain)}}"
	}

}

data class PortfolioProjectionResult(
	val reconDate: SimDate,
	val endDate: SimDate,
	val periodicity: Periodicity,
	val positions: List<Position>,
	val pocketMoney: Position,
	val externalMoney: Position,
	val portfolioAggregates: List<PortfolioAggregate>,
	val positionAggregates: List<PositionAggregate>,
	val bookings: List<PositionBooking>,
)
