package io.fincast.portfolio

import io.fincast.enums.Periodicity
import io.fincast.util.SimDate

interface Portfolio {

	val reconDate: SimDate

	val positions: List<Position>

	val pocketMoney: Position

	val externalMoney: Position

	fun initAuxPositions(pocketMoney: Position, externalMoney: Position)

	fun initPositions(positions: List<Position>)

	fun getPositions(tag: String): List<Position>

	fun calcProjection(endDate: SimDate, periodicity: Periodicity): PortfolioProjectionResult

	fun calcProjection(tag: String, endDate: SimDate, periodicity: Periodicity): PortfolioProjectionResult

	fun addBooking(booking: PositionBooking)

	fun addAggregate(aggregate: PositionAggregate)

	fun addAggregate(date: SimDate)

	companion object {

		const val POCKET_MONEY_TAG = "#pocketMoney"
		const val EXTERNAL_MONEY_TAG = "#externalMoney"

	}

}
