package io.fincast.household

import io.fincast.household.impl.PersonImpl
import io.fincast.util.SimDate

/**
 * A person is a member of a household.
 * A person can be a partner or a child.
 *
 * @property tag a unique identifier for this person
 * @property retirementDate the retirement date of the person
 * @property deathDate the (optional) death date of the person, if omitted the person will live until the end of the simulation
 */
interface Person {

	val tag: String

	val retirementDate: SimDate

	val deathDate: SimDate?

	class Builder {
		private var tag: String? = null
		private var retirementDate: SimDate? = null
		private var deathDate: SimDate? = null
		fun tag(tag: String) = apply { this.tag = tag }
		fun retirementDate(retirementDate: SimDate?) = apply { this.retirementDate = retirementDate }
		fun deathDate(deathDate: SimDate?) = apply { this.deathDate = deathDate }
		fun build(): Person {
			return PersonImpl(
				tag = tag ?: throw IllegalArgumentException("tag is required"),
				retirementDate = retirementDate ?: throw IllegalArgumentException("retirement date is required"),
				deathDate = deathDate,
			)
		}
	}

	companion object {

		@JvmStatic
		fun createPerson(tag: String, retirementDate: SimDate?, deathDate: SimDate?): Person {
			return Builder()
				.tag(tag)
				.retirementDate(retirementDate)
				.deathDate(deathDate)
				.build()
		}

	}

}
