package io.fincast.household

import io.fincast.enums.Periodicity
import io.fincast.household.impl.HouseholdImpl
import io.fincast.portfolio.Portfolio
import io.fincast.util.SimDate

interface Household {

	val partner1: Person

	val partner2: Person?

	val reconDate: SimDate

	val holdings: List<Holding>

	val pocketMoney: Holding

	val externalMoney: Holding

	val portfolio: Portfolio

	fun calcProjection(endDate: SimDate, periodicity: Periodicity = Periodicity.MONTHLY): ProjectionResult

	fun calcProjection(holding: Holding, endDate: SimDate, periodicity: Periodicity = Periodicity.MONTHLY): ProjectionResult

	class Builder {
		private var partner1: Person? = null
		private var partner2: Person? = null
		private var reconDate: SimDate? = null
		private var holdings: List<Holding> = emptyList()
		fun partner1(partner1: Person) = apply { this.partner1 = partner1 }
		fun partner2(partner2: Person) = apply { this.partner2 = partner2 }
		fun reconDate(reconDate: SimDate) = apply { this.reconDate = reconDate }
		fun holdings(holdings: List<Holding>) = apply { this.holdings = holdings }
		fun build(): Household {
			return HouseholdImpl(
				partner1 = partner1 ?: throw IllegalArgumentException("partner1 is required"),
				partner2 = partner2,
				reconDate = reconDate ?: throw IllegalArgumentException("reconDate is required"),
				holdings = holdings,
			)
		}
	}

	companion object {

		const val POCKET_MONEY_TAG = Portfolio.POCKET_MONEY_TAG
		const val EXTERNAL_MONEY_TAG = Portfolio.EXTERNAL_MONEY_TAG

		@JvmStatic
		fun createHousehold(partner1: Person, reconDate: SimDate, holdings: List<Holding>): Household {
			return Builder()
				.partner1(partner1)
				.reconDate(reconDate)
				.holdings(holdings)
				.build()
		}

		@JvmStatic
		fun createHousehold(partner1: Person, partner2: Person, reconDate: SimDate, holdings: List<Holding>): Household {
			return Builder()
				.partner1(partner1)
				.partner2(partner2)
				.reconDate(reconDate)
				.holdings(holdings)
				.build()
		}

	}

}
