package io.fincast.household

import io.fincast.enums.ProductType
import io.fincast.portfolio.Portfolio
import io.fincast.portfolio.Position
import io.fincast.portfolio.PositionCompo
import io.fincast.portfolio.impl.PositionImpl

interface Holding {

	val tag: String

	val productType: ProductType

	val owner: Person?

	fun createPosition(portfolio: Portfolio): Position {
		val pos = PositionImpl(portfolio, tag, productType)
		pos.compos = createCompos(portfolio, pos)
		return pos
	}

	fun createCompos(portfolio: Portfolio, pos: Position): List<PositionCompo>

}
