/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.portfolio.impl;

import io.fincast.enums.BookingKind;
import io.fincast.enums.BookingType;
import io.fincast.enums.ProductType;
import io.fincast.portfolio.Portfolio;
import io.fincast.portfolio.Position;
import io.fincast.portfolio.PositionAggregate;
import io.fincast.portfolio.PositionBooking;
import io.fincast.portfolio.PositionCompo;
import io.fincast.portfolio.PositionLifecycleBooking;
import io.fincast.portfolio.PositionReconciliationBooking;
import io.fincast.portfolio.impl.PositionImpl;
import io.fincast.util.SimDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000bH\u0016J\u0010\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020\u0011H\u0002J\u0018\u0010(\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010)\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u0014H\u0016J\u0010\u0010.\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\u000bH\u0016J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u0016J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00110\u00132\u0006\u0010%\u001a\u00020\u000bH\u0016J\n\u00100\u001a\u0004\u0018\u00010\u000bH\u0002J\n\u00101\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u00102\u001a\u00020\f2\u0006\u0010%\u001a\u00020\u000bH\u0002J\u000e\u00103\u001a\b\u0012\u0004\u0012\u00020\f0\u0013H\u0016J\u001e\u00104\u001a\b\u0012\u0004\u0012\u00020\u00110\u00132\u0006\u0010%\u001a\u00020\u000b2\u0006\u00105\u001a\u00020\u0001H\u0016J\u0010\u00106\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\u000bH\u0016J\u0010\u00107\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\u000bH\u0016J\u0010\u00108\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000bH\u0016J\u0010\u00109\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000bH\u0016J\u0010\u0010:\u001a\u00020;2\u0006\u0010%\u001a\u00020\u000bH\u0016R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0010\u0010 \u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006<"}, d2={"Lio/fincast/portfolio/impl/PositionImpl;", "Lio/fincast/portfolio/Position;", "portfolio", "Lio/fincast/portfolio/Portfolio;", "tag", "", "productType", "Lio/fincast/enums/ProductType;", "(Lio/fincast/portfolio/Portfolio;Ljava/lang/String;Lio/fincast/enums/ProductType;)V", "aggregates", "", "Lio/fincast/util/SimDate;", "Lio/fincast/portfolio/PositionAggregate;", "balance", "", "bookings", "", "Lio/fincast/portfolio/PositionBooking;", "compos", "", "Lio/fincast/portfolio/PositionCompo;", "getCompos", "()Ljava/util/List;", "setCompos", "(Ljava/util/List;)V", "gain", "inflows", "outflows", "getPortfolio", "()Lio/fincast/portfolio/Portfolio;", "getProductType", "()Lio/fincast/enums/ProductType;", "reconDate", "getTag", "()Ljava/lang/String;", "addAggregate", "", "date", "addBooking", "booking", "bookReconciliation", "bookTurnover", "bookingKind", "Lio/fincast/enums/BookingKind;", "turnover", "refCompo", "getBalance", "getBookings", "getFirstDate", "getLastDate", "getPeriod", "getPeriods", "getRefBookings", "refPos", "getTurnover", "getYield", "handlePortfolioLifecycle", "handlePositionLifecycle", "isReconciled", "", "fincast"})
@SourceDebugExtension(value={"SMAP\nPositionImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PositionImpl.kt\nio/fincast/portfolio/impl/PositionImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n1855#2,2:139\n766#2:141\n857#2,2:142\n1045#2:144\n1#3:145\n*S KotlinDebug\n*F\n+ 1 PositionImpl.kt\nio/fincast/portfolio/impl/PositionImpl\n*L\n29#1:139,2\n54#1:141\n54#1:142,2\n66#1:144\n*E\n"})
public final class PositionImpl
implements Position {
    @NotNull
    private final Portfolio portfolio;
    @NotNull
    private final String tag;
    @NotNull
    private final ProductType productType;
    @NotNull
    private List<? extends PositionCompo> compos;
    @NotNull
    private final List<PositionBooking> bookings;
    @NotNull
    private final Map<SimDate, PositionAggregate> aggregates;
    @Nullable
    private SimDate reconDate;
    private double balance;
    private double inflows;
    private double outflows;
    private double gain;

    public PositionImpl(@NotNull Portfolio portfolio, @NotNull String tag, @NotNull ProductType productType) {
        Intrinsics.checkNotNullParameter((Object)portfolio, (String)"portfolio");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)productType), (String)"productType");
        this.portfolio = portfolio;
        this.tag = tag;
        this.productType = productType;
        this.compos = CollectionsKt.emptyList();
        this.bookings = new ArrayList();
        this.aggregates = new LinkedHashMap();
    }

    @Override
    @NotNull
    public Portfolio getPortfolio() {
        return this.portfolio;
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @Override
    @NotNull
    public ProductType getProductType() {
        return this.productType;
    }

    @Override
    @NotNull
    public List<PositionCompo> getCompos() {
        return this.compos;
    }

    public void setCompos(@NotNull List<? extends PositionCompo> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.compos = list;
    }

    @Override
    public void handlePositionLifecycle(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Iterable $this$forEach$iv = this.getCompos();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PositionCompo it = (PositionCompo)element$iv;
            boolean bl = false;
            it.handleLifecycle(date);
        }
    }

    @Override
    public void handlePortfolioLifecycle(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
    }

    @Override
    public boolean isReconciled(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return this.reconDate != null && Intrinsics.areEqual((Object)this.reconDate, (Object)date);
    }

    @Override
    public double getBalance(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return this.getPeriod(date).getBalance();
    }

    @Override
    public double getYield(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return this.getPeriod(date).getYield();
    }

    @Override
    public double getTurnover(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return this.getBalance(date) - this.getBalance(date.minus(1));
    }

    @Override
    @NotNull
    public List<PositionBooking> getBookings() {
        return this.bookings;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<PositionBooking> getBookings(@NotNull SimDate date) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Iterable $this$filter$iv = this.bookings;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PositionBooking it = (PositionBooking)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getDate(), (Object)date)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public List<PositionBooking> getRefBookings(@NotNull SimDate date, @NotNull Position refPos) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)refPos, (String)"refPos");
        List<Object> list = this.getBookings(date).stream().filter(arg_0 -> PositionImpl.getRefBookings$lambda$2(getRefBookings.1.INSTANCE, arg_0)).filter(arg_0 -> PositionImpl.getRefBookings$lambda$3((Function1)new Function1<PositionBooking, Boolean>(refPos){
            final /* synthetic */ Position $refPos;
            {
                this.$refPos = $refPos;
                super(1);
            }

            @NotNull
            public final Boolean invoke(PositionBooking b) {
                Intrinsics.checkNotNull((Object)b, (String)"null cannot be cast to non-null type io.fincast.portfolio.PositionLifecycleBooking");
                return ((PositionLifecycleBooking)b).getRefPosition() == this.$refPos;
            }
        }, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"refPos: Position): List<\u2026=== refPos }\n\t\t\t.toList()");
        return list;
    }

    @Override
    @NotNull
    public List<PositionAggregate> getPeriods() {
        Iterable $this$sortedBy$iv = this.aggregates.values();
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PositionAggregate it = (PositionAggregate)a;
                boolean bl = false;
                Comparable comparable = it.getDate();
                it = (PositionAggregate)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getDate());
            }
        });
    }

    private final PositionAggregate getPeriod(SimDate date) {
        block3: {
            block2: {
                if (this.aggregates.isEmpty()) break block2;
                SimDate simDate = this.getFirstDate();
                Intrinsics.checkNotNull((Object)simDate);
                if (date.compareTo(simDate) >= 0) break block3;
            }
            return new PositionAggregate(this, date, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        PositionAggregate positionAggregate = this.aggregates.get(date);
        Intrinsics.checkNotNull((Object)positionAggregate);
        return positionAggregate;
    }

    @Override
    public void bookReconciliation(@NotNull SimDate date, double balance) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        this.addBooking(new PositionReconciliationBooking(this, date, balance));
    }

    @Override
    public void bookTurnover(@NotNull SimDate date, @NotNull BookingKind bookingKind, double turnover, @NotNull PositionCompo refCompo) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)((Object)bookingKind), (String)"bookingKind");
        Intrinsics.checkNotNullParameter((Object)refCompo, (String)"refCompo");
        this.addBooking(new PositionLifecycleBooking(this, date, bookingKind, turnover, refCompo.getPosition(), refCompo));
    }

    @Override
    public void addAggregate(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        if (!((Collection)this.bookings).isEmpty()) {
            PositionAggregate aggregate = new PositionAggregate(this, date, this.balance, this.getYield(), this.inflows, this.outflows, this.gain);
            this.aggregates.put(date, aggregate);
            this.getPortfolio().addAggregate(aggregate);
            this.inflows = 0.0;
            this.outflows = 0.0;
            this.gain = 0.0;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void addBooking(PositionBooking booking) {
        v0 = booking.getDate();
        v1 = this.getLastDate();
        if (v1 == null) {
            v1 = booking.getDate();
        }
        if (!(v0.compareTo(v1) >= 0)) {
            $i$a$-require-PositionImpl$addBooking$1 = false;
            $i$a$-require-PositionImpl$addBooking$1 = "bookings must be sequential: " + booking.getDate() + " >= " + this.getLastDate();
            throw new IllegalArgumentException($i$a$-require-PositionImpl$addBooking$1.toString());
        }
        if (this.reconDate == null) ** GOTO lbl-1000
        v2 = booking.getDate();
        v3 = this.reconDate;
        Intrinsics.checkNotNull((Object)v3);
        if (v2.compareTo(v3) > 0) lbl-1000:
        // 2 sources

        {
            v4 = true;
        } else {
            v4 = false;
        }
        if (!v4) {
            $i$a$-require-PositionImpl$addBooking$2 = false;
            var2_5 = "cannot add booking to reconciled period";
            throw new IllegalArgumentException(var2_5.toString());
        }
        if (0.0 == booking.getAmount()) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[booking.getBookingKind().getBookingType().ordinal()]) {
            case 1: {
                turnover = booking.getAmount() - this.balance;
                if (turnover > 0.0) {
                    this.inflows += turnover;
                } else {
                    this.outflows += turnover;
                }
                this.balance = booking.getAmount();
                this.reconDate = booking.getDate();
                break;
            }
            case 2: {
                if (booking.getBookingKind() == BookingKind.CAPITAL_GAIN) {
                    this.gain += booking.getAmount();
                } else if (booking.getAmount() > 0.0) {
                    this.inflows += booking.getAmount();
                } else {
                    this.outflows += booking.getAmount();
                }
                this.balance += booking.getAmount();
            }
        }
        this.bookings.add(booking);
        this.getPortfolio().addBooking(booking);
    }

    private final SimDate getFirstDate() {
        return !((Collection)this.bookings).isEmpty() ? this.bookings.get(0).getDate() : null;
    }

    private final SimDate getLastDate() {
        return !((Collection)this.bookings).isEmpty() ? this.bookings.get(CollectionsKt.getLastIndex(this.bookings)).getDate() : null;
    }

    @Override
    public double getYield() {
        return Position.DefaultImpls.getYield(this);
    }

    @Override
    @Nullable
    public PositionCompo getCompo(@NotNull String tag) {
        return Position.DefaultImpls.getCompo(this, tag);
    }

    private static final boolean getRefBookings$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getRefBookings$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BookingType.values().length];
            try {
                nArray[BookingType.RECONCILE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BookingType.TURNOVER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

