/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.portfolio.impl;

import io.fincast.enums.BookingKind;
import io.fincast.enums.FundsAllocation;
import io.fincast.portfolio.Portfolio;
import io.fincast.portfolio.Position;
import io.fincast.portfolio.PositionCompo;
import io.fincast.util.SimDate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004J\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ&\u0010\r\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0004J\u001e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\u0014\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/fincast/portfolio/impl/PositionCompoBase;", "Lio/fincast/portfolio/PositionCompo;", "()V", "yield", "", "addYield", "", "bookCashflow", "date", "Lio/fincast/util/SimDate;", "amount", "fundsAllocation", "Lio/fincast/enums/FundsAllocation;", "bookTransfer", "from", "Lio/fincast/portfolio/Position;", "to", "bookYield", "bookingKind", "Lio/fincast/enums/BookingKind;", "getYield", "fincast"})
public abstract class PositionCompoBase
implements PositionCompo {
    private double yield;

    public final void bookCashflow(@NotNull SimDate date, double amount, @NotNull FundsAllocation fundsAllocation) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)((Object)fundsAllocation), (String)"fundsAllocation");
        if (!(amount == 0.0)) {
            if (fundsAllocation == FundsAllocation.DISBURSE) {
                this.getPortfolio().getPocketMoney().bookTurnover(date, BookingKind.TURNOVER, amount, this);
            } else {
                this.getPosition().bookTurnover(date, BookingKind.TURNOVER, amount, this);
            }
            this.getPortfolio().getExternalMoney().bookTurnover(date, BookingKind.TURNOVER, -amount, this);
        }
    }

    public final void bookTransfer(@NotNull SimDate date, @NotNull Position from, @NotNull Position to, double amount) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        if (!(amount == 0.0)) {
            from.bookTurnover(date, BookingKind.TRANSFER, amount, this);
            to.bookTurnover(date, BookingKind.TRANSFER, -amount, this);
        }
    }

    public final void addYield(double yield) {
        this.yield += yield;
    }

    @Override
    public double getYield() {
        return this.yield;
    }

    public final void bookYield(@NotNull SimDate date, @NotNull BookingKind bookingKind, @NotNull FundsAllocation fundsAllocation) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)((Object)bookingKind), (String)"bookingKind");
        Intrinsics.checkNotNullParameter((Object)((Object)fundsAllocation), (String)"fundsAllocation");
        if (!(this.yield == 0.0)) {
            this.getPortfolio().getExternalMoney().bookTurnover(date, bookingKind, -this.yield, this);
            if (fundsAllocation == FundsAllocation.COMPOUND) {
                this.getPosition().bookTurnover(date, bookingKind, this.yield, this);
            } else {
                this.getPortfolio().getPocketMoney().bookTurnover(date, bookingKind, this.yield, this);
            }
            this.yield = 0.0;
        }
    }

    @Override
    @NotNull
    public Portfolio getPortfolio() {
        return PositionCompo.DefaultImpls.getPortfolio(this);
    }

    @Override
    public void handleLifecycle(@NotNull SimDate date) {
        PositionCompo.DefaultImpls.handleLifecycle(this, date);
    }
}

