/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.portfolio.impl;

import io.fincast.enums.BookingType;
import io.fincast.enums.Periodicity;
import io.fincast.portfolio.Portfolio;
import io.fincast.portfolio.PortfolioAggregate;
import io.fincast.portfolio.PortfolioProjectionResult;
import io.fincast.portfolio.Position;
import io.fincast.portfolio.PositionAggregate;
import io.fincast.portfolio.PositionBooking;
import io.fincast.portfolio.PositionLifecycleBooking;
import io.fincast.util.SimDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0019H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010&\u001a\u00020\u0003H\u0016J\u0010\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020\u0003H\u0002J\u0010\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020\fH\u0016J\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00032\u0006\u0010.\u001a\u00020/H\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001b2\u0006\u00100\u001a\u000201H\u0016J\u0018\u00102\u001a\u00020$2\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0016\u00103\u001a\u00020$2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u001bH\u0016J\u0010\u00104\u001a\u00020$2\u0006\u00105\u001a\u00020,H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u001bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lio/fincast/portfolio/impl/PortfolioImpl;", "Lio/fincast/portfolio/Portfolio;", "reconDate", "Lio/fincast/util/SimDate;", "(Lio/fincast/util/SimDate;)V", "_externalMoney", "Lio/fincast/portfolio/Position;", "_pocketMoney", "assets", "", "bookings", "", "Lio/fincast/portfolio/PositionBooking;", "externalMoney", "getExternalMoney", "()Lio/fincast/portfolio/Position;", "gain", "inflows", "liabilities", "outflows", "pocketMoney", "getPocketMoney", "portfolioAggregates", "Lio/fincast/portfolio/PortfolioAggregate;", "positionAggregates", "Lio/fincast/portfolio/PositionAggregate;", "positions", "", "getPositions", "()Ljava/util/List;", "setPositions", "(Ljava/util/List;)V", "getReconDate", "()Lio/fincast/util/SimDate;", "yield", "addAggregate", "", "aggregate", "date", "addAggregates", "d", "addBooking", "booking", "calcProjection", "Lio/fincast/portfolio/PortfolioProjectionResult;", "endDate", "periodicity", "Lio/fincast/enums/Periodicity;", "tag", "", "initAuxPositions", "initPositions", "printProjectionResult", "projectionResult", "fincast"})
@SourceDebugExtension(value={"SMAP\nPortfolioImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PortfolioImpl.kt\nio/fincast/portfolio/impl/PortfolioImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,234:1\n766#2:235\n857#2,2:236\n1855#2,2:239\n1855#2,2:241\n1477#2:243\n1502#2,3:244\n1505#2,3:254\n1963#2,14:260\n1477#2:275\n1502#2,3:276\n1505#2,3:286\n1963#2,14:292\n800#2,11:307\n1477#2:318\n1502#2,3:319\n1505#2,3:329\n1477#2:335\n1502#2,3:336\n1505#2,3:346\n1855#2,2:356\n1#3:238\n361#4,7:247\n361#4,7:279\n361#4,7:322\n361#4,7:339\n125#5:257\n152#5,2:258\n154#5:274\n125#5:289\n152#5,2:290\n154#5:306\n76#5:332\n96#5,2:333\n125#5:349\n152#5,3:350\n98#5,3:353\n*S KotlinDebug\n*F\n+ 1 PortfolioImpl.kt\nio/fincast/portfolio/impl/PortfolioImpl\n*L\n44#1:235\n44#1:236,2\n59#1:239,2\n61#1:241,2\n84#1:243\n84#1:244,3\n84#1:254,3\n86#1:260,14\n93#1:275\n93#1:276,3\n93#1:286,3\n95#1:292,14\n102#1:307,11\n103#1:318\n103#1:319,3\n103#1:329,3\n105#1:335\n105#1:336,3\n105#1:346,3\n129#1:356,2\n84#1:247,7\n93#1:279,7\n103#1:322,7\n105#1:339,7\n85#1:257\n85#1:258,2\n85#1:274\n94#1:289\n94#1:290,2\n94#1:306\n104#1:332\n104#1:333,2\n106#1:349\n106#1:350,3\n104#1:353,3\n*E\n"})
public final class PortfolioImpl
implements Portfolio {
    @NotNull
    private final SimDate reconDate;
    @Nullable
    private Position _pocketMoney;
    @Nullable
    private Position _externalMoney;
    @NotNull
    private List<? extends Position> positions;
    @NotNull
    private final List<PositionBooking> bookings;
    @NotNull
    private final List<PositionAggregate> positionAggregates;
    @NotNull
    private final List<PortfolioAggregate> portfolioAggregates;
    private double assets;
    private double liabilities;
    private double inflows;
    private double outflows;
    private double yield;
    private double gain;

    public PortfolioImpl(@NotNull SimDate reconDate) {
        Intrinsics.checkNotNullParameter((Object)reconDate, (String)"reconDate");
        this.reconDate = reconDate;
        this.positions = CollectionsKt.emptyList();
        this.bookings = new ArrayList();
        this.positionAggregates = new ArrayList();
        this.portfolioAggregates = new ArrayList();
    }

    @Override
    @NotNull
    public SimDate getReconDate() {
        return this.reconDate;
    }

    @Override
    @NotNull
    public List<Position> getPositions() {
        return this.positions;
    }

    public void setPositions(@NotNull List<? extends Position> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.positions = list;
    }

    @Override
    @NotNull
    public Position getPocketMoney() {
        Position position = this._pocketMoney;
        if (position == null) {
            throw new IllegalStateException("pocketMoney not initialized");
        }
        return position;
    }

    @Override
    @NotNull
    public Position getExternalMoney() {
        Position position = this._externalMoney;
        if (position == null) {
            throw new IllegalStateException("externalMoney not initialized");
        }
        return position;
    }

    @Override
    public void initAuxPositions(@NotNull Position pocketMoney, @NotNull Position externalMoney) {
        Intrinsics.checkNotNullParameter((Object)pocketMoney, (String)"pocketMoney");
        Intrinsics.checkNotNullParameter((Object)externalMoney, (String)"externalMoney");
        this._pocketMoney = pocketMoney;
        this._externalMoney = externalMoney;
    }

    @Override
    public void initPositions(@NotNull List<? extends Position> positions) {
        Intrinsics.checkNotNullParameter(positions, (String)"positions");
        this.setPositions(positions);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Position> getPositions(@NotNull String tag) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Iterable $this$filter$iv = this.getPositions();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Position it = (Position)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getTag(), (Object)tag)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PortfolioProjectionResult calcProjection(@NotNull SimDate endDate, @NotNull Periodicity periodicity) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Iterable answer$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Object object;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$groupByTo$iv$iv2;
        Map $this$groupBy$iv2;
        double d;
        double inflows;
        Object object2;
        void $this$mapTo$iv$iv2;
        boolean bl;
        Object it2;
        Map $this$groupByTo$iv$iv3;
        Iterator it;
        Intrinsics.checkNotNullParameter((Object)endDate, (String)"endDate");
        Intrinsics.checkNotNullParameter((Object)((Object)periodicity), (String)"periodicity");
        if (!(periodicity == Periodicity.MONTHLY || periodicity == Periodicity.YEARLY)) {
            boolean $i$a$-require-PortfolioImpl$calcProjection$232 = false;
            String $i$a$-require-PortfolioImpl$calcProjection$232 = "periodicity must be MONTHLY or YEARLY";
            throw new IllegalArgumentException($i$a$-require-PortfolioImpl$calcProjection$232.toString());
        }
        this.positionAggregates.clear();
        this.addAggregates(this.getReconDate());
        SimDate periodEndDate = periodicity.endOfPeriod(endDate);
        for (SimDate simDate : this.getReconDate().plus(1).rangeTo(periodEndDate)) {
            boolean bl2;
            Iterable $this$forEach$iv = this.getPositions();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Position it3 = (Position)element$iv;
                bl2 = false;
                it3.handlePositionLifecycle(simDate);
            }
            $this$forEach$iv = this.getPositions();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Position)element$iv;
                bl2 = false;
                it.handlePortfolioLifecycle(simDate);
            }
            this.addAggregates(simDate);
        }
        if (periodicity == Periodicity.MONTHLY) {
            return new PortfolioProjectionResult(this.getReconDate(), periodEndDate, periodicity, this.getPositions(), this.getPocketMoney(), this.getExternalMoney(), this.portfolioAggregates, this.positionAggregates, this.bookings);
        }
        Iterable iterable = this.positionAggregates;
        boolean $i$f$groupBy = false;
        Iterable $i$f$forEach = iterable;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        it = $this$groupByTo$iv$iv3.iterator();
        while (it.hasNext()) {
            Object object3;
            Object element$iv$iv = it.next();
            it2 = (PositionAggregate)element$iv$iv;
            bl = false;
            String key$iv$iv = ((PositionAggregate)it2).getPosition().getTag() + ":" + periodicity.endOfPeriod(((PositionAggregate)it2).getDate());
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv2 = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv2);
                object3 = answer$iv$iv$iv2;
            } else {
                object3 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object3;
            list$iv$iv.add(element$iv$iv);
        }
        Map map = destination$iv$iv;
        boolean $i$f$map232 = false;
        $this$groupByTo$iv$iv3 = map;
        destination$iv$iv = new ArrayList(map.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv2.entrySet()) {
            double d2;
            double d3;
            Object v$iv;
            Iterator<Object> e$iv;
            Object maxValue$iv;
            Object v1;
            it2 = item$iv$iv;
            object2 = destination$iv$iv;
            bl = false;
            String date = (String)it2.getKey();
            List aggregates = (List)it2.getValue();
            Iterable $this$maxByOrNull$iv = aggregates;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v1 = maxElem$iv;
                } else {
                    PositionAggregate it4 = (PositionAggregate)maxElem$iv;
                    boolean bl3 = false;
                    maxValue$iv = it4.getDate();
                    do {
                        e$iv = iterator$iv.next();
                        PositionAggregate it5 = (PositionAggregate)((Object)e$iv);
                        boolean positionAggregate = false;
                        v$iv = it5.getDate();
                        if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v1 = maxElem$iv;
                }
            }
            Intrinsics.checkNotNull(v1);
            PositionAggregate lastAggregate = v1;
            iterator$iv = aggregates;
            double entry = 0.0;
            e$iv = iterator$iv.iterator();
            while (e$iv.hasNext()) {
                void it6;
                v$iv = e$iv.next();
                PositionAggregate positionAggregate = (PositionAggregate)v$iv;
                d3 = entry;
                boolean bl4 = false;
                d2 = it6.getInflows();
                entry = d3 + d2;
            }
            inflows = entry;
            maxValue$iv = aggregates;
            d = 0.0;
            Iterator it6 = maxValue$iv.iterator();
            while (it6.hasNext()) {
                void it7;
                Object bl4 = it6.next();
                PositionAggregate positionAggregate = (PositionAggregate)bl4;
                d3 = d;
                boolean bl5 = false;
                d2 = it7.getOutflows();
                d = d3 + d2;
            }
            double outflows = d;
            object2.add(PositionAggregate.copy$default(lastAggregate, null, null, 0.0, 0.0, inflows, outflows, 0.0, 79, null));
        }
        List eopPositionAggregates = (List)destination$iv$iv;
        Iterable $i$f$map232 = this.portfolioAggregates;
        boolean $i$f$groupBy2 = false;
        destination$iv$iv = $this$groupBy$iv2;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo2 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
            Object object4;
            PortfolioAggregate it8 = (PortfolioAggregate)element$iv$iv;
            boolean bl3 = false;
            SimDate key$iv$iv = periodicity.endOfPeriod(it8.getDate());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl6 = false;
                List answer$iv$iv$iv3 = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv3);
                object4 = answer$iv$iv$iv3;
            } else {
                object4 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object4;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv2 = destination$iv$iv2;
        boolean $i$f$map332 = false;
        $this$groupByTo$iv$iv2 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo2 = false;
        Iterator<Object> item$iv$iv = $this$mapTo$iv$iv.entrySet().iterator();
        while (item$iv$iv.hasNext()) {
            double d4;
            Iterator<Object> e$iv;
            Object maxValue$iv;
            Object v3;
            Map.Entry item$iv$iv2;
            Map.Entry it8 = item$iv$iv2 = (Map.Entry)item$iv$iv.next();
            object2 = destination$iv$iv3;
            boolean bl4 = false;
            SimDate date = (SimDate)it8.getKey();
            List aggregates = (List)it8.getValue();
            Iterable $this$maxByOrNull$iv = aggregates;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v3 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v3 = maxElem$iv;
                } else {
                    PortfolioAggregate it9 = (PortfolioAggregate)maxElem$iv;
                    boolean bl7 = false;
                    maxValue$iv = it9.getDate();
                    do {
                        e$iv = iterator$iv.next();
                        PortfolioAggregate it3 = (PortfolioAggregate)((Object)e$iv);
                        boolean portfolioAggregate = false;
                        Comparable v$iv = it3.getDate();
                        if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v3 = maxElem$iv;
                }
            }
            Intrinsics.checkNotNull(v3);
            PortfolioAggregate lastAggregate = v3;
            iterator$iv = aggregates;
            double d5 = 0.0;
            e$iv = iterator$iv.iterator();
            while (e$iv.hasNext()) {
                void it10;
                object = e$iv.next();
                PortfolioAggregate portfolioAggregate = (PortfolioAggregate)object;
                d4 = d5;
                boolean bl8 = false;
                inflows = it10.getInflows();
                d5 = d4 + inflows;
            }
            double inflows2 = d5;
            maxValue$iv = aggregates;
            double d6 = 0.0;
            Iterator it10 = maxValue$iv.iterator();
            while (it10.hasNext()) {
                void it11;
                Object bl8 = it10.next();
                PortfolioAggregate bl5 = (PortfolioAggregate)bl8;
                d4 = d6;
                boolean bl9 = false;
                inflows = it11.getOutflows();
                d6 = d4 + inflows;
            }
            double outflows = d6;
            object2.add(PortfolioAggregate.copy$default(lastAggregate, null, 0.0, 0.0, 0.0, inflows2, outflows, 0.0, 79, null));
        }
        List list = (List)destination$iv$iv3;
        Iterable $i$f$map332 = this.bookings;
        boolean $i$f$filterIsInstance = false;
        destination$iv$iv3 = $this$filterIsInstance$iv;
        Collection destination$iv$iv32 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PositionLifecycleBooking)) continue;
            destination$iv$iv32.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv32;
        boolean $i$f$groupBy3 = false;
        $this$filterIsInstanceTo$iv$iv = $this$groupBy$iv;
        Object destination$iv$iv4 = new LinkedHashMap();
        boolean $i$f$groupByTo3 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object5;
            PositionLifecycleBooking it12 = (PositionLifecycleBooking)element$iv$iv;
            boolean bl5 = false;
            SimDate key$iv$iv = periodicity.endOfPeriod(it12.getDate());
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv4;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl10 = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object5 = answer$iv$iv$iv;
            } else {
                object5 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object5;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv4;
        boolean $i$f$flatMap = false;
        $this$groupByTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv4 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator<Object> iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv3;
            void $this$map$iv3;
            void $this$groupByTo$iv$iv4;
            Map.Entry element$iv$iv;
            Map.Entry it12 = element$iv$iv = (Map.Entry)iterator.next();
            boolean bl6 = false;
            SimDate date = (SimDate)it12.getKey();
            List periodBookings = (List)it12.getValue();
            Object $this$groupBy$iv4 = periodBookings;
            boolean $i$f$groupBy4 = false;
            answer$iv$iv$iv = $this$groupBy$iv4;
            Map destination$iv$iv42 = new LinkedHashMap();
            boolean $i$f$groupByTo4 = false;
            for (Object element$iv$iv2 : $this$groupByTo$iv$iv4) {
                Object object6;
                PositionLifecycleBooking it13 = (PositionLifecycleBooking)element$iv$iv2;
                boolean bl11 = false;
                String key$iv$iv = it13.getPosition().getTag() + ":" + it13.getBookingKind().getCode() + ":" + it13.getRefPosition().getTag() + ":" + it13.getRefCompo().getTag();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv42;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl12 = false;
                    List answer$iv$iv$iv4 = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv4);
                    object6 = answer$iv$iv$iv4;
                } else {
                    object6 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object6;
                list$iv$iv.add(element$iv$iv2);
            }
            $this$groupBy$iv4 = destination$iv$iv42;
            boolean $i$f$map = false;
            $this$groupByTo$iv$iv4 = $this$map$iv3;
            Collection destination$iv$iv5 = new ArrayList($this$map$iv3.size());
            boolean $i$f$mapTo3 = false;
            object = $this$mapTo$iv$iv3.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry item$iv$iv3;
                Map.Entry entry = item$iv$iv3 = (Map.Entry)object.next();
                Collection collection = destination$iv$iv5;
                boolean bl13 = false;
                List keyBookings = (List)entry.getValue();
                PositionLifecycleBooking keyBooking = (PositionLifecycleBooking)CollectionsKt.first((List)keyBookings);
                Iterable iterable2 = keyBookings;
                d = 0.0;
                for (Object e : iterable2) {
                    void it14;
                    PositionLifecycleBooking bl9 = (PositionLifecycleBooking)e;
                    double d7 = d;
                    boolean bl14 = false;
                    double d8 = it14.getAmount();
                    d = d7 + d8;
                }
                double amount = d;
                collection.add(new PositionLifecycleBooking(keyBooking.getPosition(), date, keyBooking.getBookingKind(), amount, keyBooking.getRefPosition(), keyBooking.getRefCompo()));
            }
            Iterable list$iv$iv = (List)destination$iv$iv5;
            CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv);
        }
        List eopBookings = (List)destination$iv$iv4;
        return new PortfolioProjectionResult(this.getReconDate(), periodEndDate, periodicity, this.getPositions(), this.getPocketMoney(), this.getExternalMoney(), list, eopPositionAggregates, eopBookings);
    }

    private final void addAggregates(SimDate d) {
        Iterable $this$forEach$iv = this.getPositions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Position it = (Position)element$iv;
            boolean bl = false;
            it.addAggregate(d);
        }
        this.getPocketMoney().addAggregate(d);
        this.getExternalMoney().addAggregate(d);
        this.addAggregate(d);
    }

    @Override
    public void addBooking(@NotNull PositionBooking booking) {
        Intrinsics.checkNotNullParameter((Object)booking, (String)"booking");
        this.bookings.add(booking);
        if (Intrinsics.areEqual((Object)booking.getPosition(), (Object)this.getExternalMoney())) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[booking.getBookingKind().getBookingType().ordinal()]) {
            case 1: {
                double turnover = booking.getAmount() - booking.getPosition().getBalance(booking.getDate().minus(1));
                if (turnover > 0.0) {
                    this.inflows += turnover;
                    break;
                }
                this.outflows += turnover;
                break;
            }
            case 2: {
                if (!booking.getBookingKind().isCashflow()) break;
                if (booking.getAmount() > 0.0) {
                    this.inflows += booking.getAmount();
                    break;
                }
                this.outflows += booking.getAmount();
            }
        }
    }

    @Override
    public void addAggregate(@NotNull PositionAggregate aggregate) {
        Intrinsics.checkNotNullParameter((Object)aggregate, (String)"aggregate");
        this.positionAggregates.add(aggregate);
        if (Intrinsics.areEqual((Object)aggregate.getPosition(), (Object)this.getExternalMoney())) {
            return;
        }
        if (aggregate.getBalance() > 0.0) {
            this.assets += aggregate.getBalance();
        } else {
            this.liabilities += aggregate.getBalance();
        }
        this.yield += aggregate.getYield();
        this.gain += aggregate.getGain();
    }

    @Override
    public void addAggregate(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        this.portfolioAggregates.add(new PortfolioAggregate(date, this.assets, this.liabilities, this.yield, this.inflows, this.outflows, this.gain));
        this.assets = 0.0;
        this.liabilities = 0.0;
        this.inflows = 0.0;
        this.outflows = 0.0;
        this.yield = 0.0;
        this.gain = 0.0;
    }

    private final void printProjectionResult(PortfolioProjectionResult projectionResult) {
        System.out.println((Object)("\nPORTFOLIO Projection from " + projectionResult.getReconDate() + " to " + projectionResult.getEndDate() + " with periodicity " + projectionResult.getPeriodicity()));
        System.out.println((Object)"\nPortfolio Aggregates:");
        System.out.println((Object)"---------------------");
        for (PortfolioAggregate portfolioAggregate : projectionResult.getPortfolioAggregates()) {
            System.out.println(portfolioAggregate);
        }
        System.out.println((Object)"\nPosition Aggregates:");
        System.out.println((Object)"--------------------");
        for (PositionAggregate positionAggregate : projectionResult.getPositionAggregates()) {
            System.out.println(positionAggregate);
        }
        System.out.println((Object)"\nBookings:");
        System.out.println((Object)"---------");
        for (PositionBooking positionBooking : projectionResult.getBookings()) {
            System.out.println(positionBooking);
        }
        System.out.println((Object)"\nPosition Bookings:");
        System.out.println((Object)"------------------");
        for (Position position : this.getPositions()) {
            System.out.println((Object)("\n" + position.getTag() + " Bookings:"));
            System.out.println((Object)"------------------");
            for (PositionBooking booking : position.getBookings()) {
                System.out.println(booking);
            }
        }
        System.out.println((Object)"\nPocketMoney Bookings:");
        System.out.println((Object)"---------------------");
        for (PositionBooking positionBooking : this.getPocketMoney().getBookings()) {
            System.out.println(positionBooking);
        }
        System.out.println((Object)"\nExternalMoney Bookings:");
        System.out.println((Object)"-----------------------");
        for (PositionBooking positionBooking : this.getExternalMoney().getBookings()) {
            System.out.println(positionBooking);
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BookingType.values().length];
            try {
                nArray[BookingType.RECONCILE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BookingType.TURNOVER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

