/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.portfolio.impl;

import io.fincast.enums.FundsAllocation;
import io.fincast.enums.Periodicity;
import io.fincast.portfolio.Position;
import io.fincast.portfolio.ValueProvider;
import io.fincast.portfolio.impl.PositionCompoBase;
import io.fincast.util.SimDate;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u001e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0010\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\u0005H\u00c6\u0003J\t\u0010(\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010)\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\t\u0010*\u001a\u00020\fH\u00c6\u0003J\t\u0010+\u001a\u00020\u000eH\u00c6\u0003J\u000b\u0010,\u001a\u0004\u0018\u00010\u0010H\u00c6\u0003J\u000b\u0010-\u001a\u0004\u0018\u00010\u0010H\u00c6\u0003J\t\u0010.\u001a\u00020\u0013H\u00c6\u0003Jm\u0010/\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u00c6\u0001J\u0013\u00100\u001a\u00020\u00132\b\u00101\u001a\u0004\u0018\u000102H\u00d6\u0003J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0010H\u0016J\t\u00106\u001a\u00020\fH\u00d6\u0001J\t\u00107\u001a\u00020\u0005H\u00d6\u0001R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0018R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u00068"}, d2={"Lio/fincast/portfolio/impl/CashflowCompo;", "Lio/fincast/portfolio/impl/PositionCompoBase;", "position", "Lio/fincast/portfolio/Position;", "tag", "", "fundsAllocation", "Lio/fincast/enums/FundsAllocation;", "amount", "Lio/fincast/portfolio/ValueProvider;", "", "sign", "", "periodicity", "Lio/fincast/enums/Periodicity;", "startDate", "Lio/fincast/util/SimDate;", "endDate", "proRata", "", "(Lio/fincast/portfolio/Position;Ljava/lang/String;Lio/fincast/enums/FundsAllocation;Lio/fincast/portfolio/ValueProvider;ILio/fincast/enums/Periodicity;Lio/fincast/util/SimDate;Lio/fincast/util/SimDate;Z)V", "getAmount", "()Lio/fincast/portfolio/ValueProvider;", "getEndDate", "()Lio/fincast/util/SimDate;", "getFundsAllocation", "()Lio/fincast/enums/FundsAllocation;", "getPeriodicity", "()Lio/fincast/enums/Periodicity;", "getPosition", "()Lio/fincast/portfolio/Position;", "getProRata", "()Z", "getSign", "()I", "getStartDate", "getTag", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "", "handleLifecycle", "", "date", "hashCode", "toString", "fincast"})
public final class CashflowCompo
extends PositionCompoBase {
    @NotNull
    private final Position position;
    @NotNull
    private final String tag;
    @NotNull
    private final FundsAllocation fundsAllocation;
    @NotNull
    private final ValueProvider<Double> amount;
    private final int sign;
    @NotNull
    private final Periodicity periodicity;
    @Nullable
    private final SimDate startDate;
    @Nullable
    private final SimDate endDate;
    private final boolean proRata;

    public CashflowCompo(@NotNull Position position, @NotNull String tag, @NotNull FundsAllocation fundsAllocation, @NotNull ValueProvider<Double> amount, int sign, @NotNull Periodicity periodicity, @Nullable SimDate startDate, @Nullable SimDate endDate, boolean proRata) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)fundsAllocation), (String)"fundsAllocation");
        Intrinsics.checkNotNullParameter(amount, (String)"amount");
        Intrinsics.checkNotNullParameter((Object)((Object)periodicity), (String)"periodicity");
        this.position = position;
        this.tag = tag;
        this.fundsAllocation = fundsAllocation;
        this.amount = amount;
        this.sign = sign;
        this.periodicity = periodicity;
        this.startDate = startDate;
        this.endDate = endDate;
        this.proRata = proRata;
    }

    public /* synthetic */ CashflowCompo(Position position, String string, FundsAllocation fundsAllocation, ValueProvider valueProvider, int n, Periodicity periodicity, SimDate simDate, SimDate simDate2, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x40) != 0) {
            simDate = null;
        }
        if ((n2 & 0x80) != 0) {
            simDate2 = null;
        }
        if ((n2 & 0x100) != 0) {
            bl = true;
        }
        this(position, string, fundsAllocation, valueProvider, n, periodicity, simDate, simDate2, bl);
    }

    @Override
    @NotNull
    public Position getPosition() {
        return this.position;
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @NotNull
    public final FundsAllocation getFundsAllocation() {
        return this.fundsAllocation;
    }

    @NotNull
    public final ValueProvider<Double> getAmount() {
        return this.amount;
    }

    public final int getSign() {
        return this.sign;
    }

    @NotNull
    public final Periodicity getPeriodicity() {
        return this.periodicity;
    }

    @Nullable
    public final SimDate getStartDate() {
        return this.startDate;
    }

    @Nullable
    public final SimDate getEndDate() {
        return this.endDate;
    }

    public final boolean getProRata() {
        return this.proRata;
    }

    @Override
    public void handleLifecycle(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        if (this.periodicity.isCashflowDate(date, this.startDate, this.endDate)) {
            double amount = ((Number)this.amount.getValue(date)).doubleValue() * (double)this.sign;
            SimDate sop = this.periodicity.startOfPeriod(date);
            if (this.proRata && this.startDate != null && this.periodicity.getMonths() > 1 && sop.compareTo(this.startDate) < 0) {
                amount = amount * (double)date.minus(this.startDate) / (double)this.periodicity.getMonths();
            }
            this.bookCashflow(date, amount, this.fundsAllocation);
        }
    }

    @NotNull
    public final Position component1() {
        return this.position;
    }

    @NotNull
    public final String component2() {
        return this.tag;
    }

    @NotNull
    public final FundsAllocation component3() {
        return this.fundsAllocation;
    }

    @NotNull
    public final ValueProvider<Double> component4() {
        return this.amount;
    }

    public final int component5() {
        return this.sign;
    }

    @NotNull
    public final Periodicity component6() {
        return this.periodicity;
    }

    @Nullable
    public final SimDate component7() {
        return this.startDate;
    }

    @Nullable
    public final SimDate component8() {
        return this.endDate;
    }

    public final boolean component9() {
        return this.proRata;
    }

    @NotNull
    public final CashflowCompo copy(@NotNull Position position, @NotNull String tag, @NotNull FundsAllocation fundsAllocation, @NotNull ValueProvider<Double> amount, int sign, @NotNull Periodicity periodicity, @Nullable SimDate startDate, @Nullable SimDate endDate, boolean proRata) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)fundsAllocation), (String)"fundsAllocation");
        Intrinsics.checkNotNullParameter(amount, (String)"amount");
        Intrinsics.checkNotNullParameter((Object)((Object)periodicity), (String)"periodicity");
        return new CashflowCompo(position, tag, fundsAllocation, amount, sign, periodicity, startDate, endDate, proRata);
    }

    public static /* synthetic */ CashflowCompo copy$default(CashflowCompo cashflowCompo, Position position, String string, FundsAllocation fundsAllocation, ValueProvider valueProvider, int n, Periodicity periodicity, SimDate simDate, SimDate simDate2, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            position = cashflowCompo.position;
        }
        if ((n2 & 2) != 0) {
            string = cashflowCompo.tag;
        }
        if ((n2 & 4) != 0) {
            fundsAllocation = cashflowCompo.fundsAllocation;
        }
        if ((n2 & 8) != 0) {
            valueProvider = cashflowCompo.amount;
        }
        if ((n2 & 0x10) != 0) {
            n = cashflowCompo.sign;
        }
        if ((n2 & 0x20) != 0) {
            periodicity = cashflowCompo.periodicity;
        }
        if ((n2 & 0x40) != 0) {
            simDate = cashflowCompo.startDate;
        }
        if ((n2 & 0x80) != 0) {
            simDate2 = cashflowCompo.endDate;
        }
        if ((n2 & 0x100) != 0) {
            bl = cashflowCompo.proRata;
        }
        return cashflowCompo.copy(position, string, fundsAllocation, valueProvider, n, periodicity, simDate, simDate2, bl);
    }

    @NotNull
    public String toString() {
        return "CashflowCompo(position=" + this.position + ", tag=" + this.tag + ", fundsAllocation=" + this.fundsAllocation + ", amount=" + this.amount + ", sign=" + this.sign + ", periodicity=" + this.periodicity + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", proRata=" + this.proRata + ")";
    }

    public int hashCode() {
        int result = this.position.hashCode();
        result = result * 31 + this.tag.hashCode();
        result = result * 31 + this.fundsAllocation.hashCode();
        result = result * 31 + this.amount.hashCode();
        result = result * 31 + Integer.hashCode(this.sign);
        result = result * 31 + this.periodicity.hashCode();
        result = result * 31 + (this.startDate == null ? 0 : this.startDate.hashCode());
        result = result * 31 + (this.endDate == null ? 0 : this.endDate.hashCode());
        int n = this.proRata ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CashflowCompo)) {
            return false;
        }
        CashflowCompo cashflowCompo = (CashflowCompo)other;
        if (!Intrinsics.areEqual((Object)this.position, (Object)cashflowCompo.position)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tag, (Object)cashflowCompo.tag)) {
            return false;
        }
        if (this.fundsAllocation != cashflowCompo.fundsAllocation) {
            return false;
        }
        if (!Intrinsics.areEqual(this.amount, cashflowCompo.amount)) {
            return false;
        }
        if (this.sign != cashflowCompo.sign) {
            return false;
        }
        if (this.periodicity != cashflowCompo.periodicity) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.startDate, (Object)cashflowCompo.startDate)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.endDate, (Object)cashflowCompo.endDate)) {
            return false;
        }
        return this.proRata == cashflowCompo.proRata;
    }
}

