/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.portfolio;

import io.fincast.portfolio.Position;
import io.fincast.portfolio.ValueProvider;
import io.fincast.util.SimDate;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u0002H\u0005H\u0007\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\u000e"}, d2={"Lio/fincast/portfolio/ValueProviders;", "", "()V", "constValue", "Lio/fincast/portfolio/ValueProvider;", "T", "value", "(Ljava/lang/Object;)Lio/fincast/portfolio/ValueProvider;", "eomBalance", "", "pos", "Lio/fincast/portfolio/Position;", "eomCreditBalance", "eomDebitBalance", "fincast"})
public final class ValueProviders {
    @NotNull
    public static final ValueProviders INSTANCE = new ValueProviders();

    private ValueProviders() {
    }

    @JvmStatic
    @NotNull
    public static final <T> ValueProvider<T> constValue(T value) {
        return arg_0 -> ValueProviders.constValue$lambda$0(value, arg_0);
    }

    @JvmStatic
    @NotNull
    public static final ValueProvider<Double> eomBalance(@NotNull Position pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return arg_0 -> ValueProviders.eomBalance$lambda$1(pos, arg_0);
    }

    @JvmStatic
    @NotNull
    public static final ValueProvider<Double> eomCreditBalance(@NotNull Position pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return arg_0 -> ValueProviders.eomCreditBalance$lambda$2(pos, arg_0);
    }

    @JvmStatic
    @NotNull
    public static final ValueProvider<Double> eomDebitBalance(@NotNull Position pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return arg_0 -> ValueProviders.eomDebitBalance$lambda$3(pos, arg_0);
    }

    private static final Object constValue$lambda$0(Object $value, SimDate it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $value;
    }

    private static final double eomBalance$lambda$1(Position $pos, SimDate date) {
        Intrinsics.checkNotNullParameter((Object)$pos, (String)"$pos");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return $pos.getBalance(date.minus(1));
    }

    private static final double eomCreditBalance$lambda$2(Position $pos, SimDate date) {
        Intrinsics.checkNotNullParameter((Object)$pos, (String)"$pos");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        double eomBalance = $pos.getBalance(date.minus(1));
        return RangesKt.coerceAtLeast((double)eomBalance, (double)0.0);
    }

    private static final double eomDebitBalance$lambda$3(Position $pos, SimDate date) {
        Intrinsics.checkNotNullParameter((Object)$pos, (String)"$pos");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        double eomBalance = $pos.getBalance(date.minus(1));
        return RangesKt.coerceAtMost((double)eomBalance, (double)0.0);
    }
}

