/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.portfolio;

import io.fincast.util.SimDate;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003JO\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\b\u0010\"\u001a\u00020#H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\r\u00a8\u0006$"}, d2={"Lio/fincast/portfolio/PortfolioAggregate;", "", "date", "Lio/fincast/util/SimDate;", "assets", "", "liabilities", "yield", "inflows", "outflows", "gain", "(Lio/fincast/util/SimDate;DDDDDD)V", "getAssets", "()D", "getDate", "()Lio/fincast/util/SimDate;", "getGain", "getInflows", "getLiabilities", "getOutflows", "getYield", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "", "toString", "", "fincast"})
public final class PortfolioAggregate {
    @NotNull
    private final SimDate date;
    private final double assets;
    private final double liabilities;
    private final double yield;
    private final double inflows;
    private final double outflows;
    private final double gain;

    public PortfolioAggregate(@NotNull SimDate date, double assets, double liabilities, double yield, double inflows, double outflows, double gain) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        this.date = date;
        this.assets = assets;
        this.liabilities = liabilities;
        this.yield = yield;
        this.inflows = inflows;
        this.outflows = outflows;
        this.gain = gain;
    }

    @NotNull
    public final SimDate getDate() {
        return this.date;
    }

    public final double getAssets() {
        return this.assets;
    }

    public final double getLiabilities() {
        return this.liabilities;
    }

    public final double getYield() {
        return this.yield;
    }

    public final double getInflows() {
        return this.inflows;
    }

    public final double getOutflows() {
        return this.outflows;
    }

    public final double getGain() {
        return this.gain;
    }

    @NotNull
    public String toString() {
        double balance = this.assets + this.liabilities;
        String string = "%.0f";
        Object[] objectArray = new Object[]{balance};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        string = "%.0f";
        objectArray = new Object[]{this.yield};
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
        string = "%.0f";
        objectArray = new Object[]{this.inflows};
        String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
        string = "%.0f";
        objectArray = new Object[]{this.outflows};
        String string5 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(format, *args)");
        string = "%.0f";
        objectArray = new Object[]{this.gain};
        String string6 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(format, *args)");
        return this.date + ": [" + string2 + ", " + string3 + "] {->" + string4 + ", " + string5 + "->, " + string6 + "}";
    }

    @NotNull
    public final SimDate component1() {
        return this.date;
    }

    public final double component2() {
        return this.assets;
    }

    public final double component3() {
        return this.liabilities;
    }

    public final double component4() {
        return this.yield;
    }

    public final double component5() {
        return this.inflows;
    }

    public final double component6() {
        return this.outflows;
    }

    public final double component7() {
        return this.gain;
    }

    @NotNull
    public final PortfolioAggregate copy(@NotNull SimDate date, double assets, double liabilities, double yield, double inflows, double outflows, double gain) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return new PortfolioAggregate(date, assets, liabilities, yield, inflows, outflows, gain);
    }

    public static /* synthetic */ PortfolioAggregate copy$default(PortfolioAggregate portfolioAggregate, SimDate simDate, double d, double d2, double d3, double d4, double d5, double d6, int n, Object object) {
        if ((n & 1) != 0) {
            simDate = portfolioAggregate.date;
        }
        if ((n & 2) != 0) {
            d = portfolioAggregate.assets;
        }
        if ((n & 4) != 0) {
            d2 = portfolioAggregate.liabilities;
        }
        if ((n & 8) != 0) {
            d3 = portfolioAggregate.yield;
        }
        if ((n & 0x10) != 0) {
            d4 = portfolioAggregate.inflows;
        }
        if ((n & 0x20) != 0) {
            d5 = portfolioAggregate.outflows;
        }
        if ((n & 0x40) != 0) {
            d6 = portfolioAggregate.gain;
        }
        return portfolioAggregate.copy(simDate, d, d2, d3, d4, d5, d6);
    }

    public int hashCode() {
        int result = this.date.hashCode();
        result = result * 31 + Double.hashCode(this.assets);
        result = result * 31 + Double.hashCode(this.liabilities);
        result = result * 31 + Double.hashCode(this.yield);
        result = result * 31 + Double.hashCode(this.inflows);
        result = result * 31 + Double.hashCode(this.outflows);
        result = result * 31 + Double.hashCode(this.gain);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PortfolioAggregate)) {
            return false;
        }
        PortfolioAggregate portfolioAggregate = (PortfolioAggregate)other;
        if (!Intrinsics.areEqual((Object)this.date, (Object)portfolioAggregate.date)) {
            return false;
        }
        if (Double.compare(this.assets, portfolioAggregate.assets) != 0) {
            return false;
        }
        if (Double.compare(this.liabilities, portfolioAggregate.liabilities) != 0) {
            return false;
        }
        if (Double.compare(this.yield, portfolioAggregate.yield) != 0) {
            return false;
        }
        if (Double.compare(this.inflows, portfolioAggregate.inflows) != 0) {
            return false;
        }
        if (Double.compare(this.outflows, portfolioAggregate.outflows) != 0) {
            return false;
        }
        return Double.compare(this.gain, portfolioAggregate.gain) == 0;
    }
}

