/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.household.impl;

import io.fincast.enums.BookingKind;
import io.fincast.enums.FundsAllocation;
import io.fincast.enums.Periodicity;
import io.fincast.enums.ProductType;
import io.fincast.household.Valuable;
import io.fincast.portfolio.Portfolio;
import io.fincast.portfolio.Position;
import io.fincast.portfolio.PositionCompo;
import io.fincast.portfolio.ValueProviders;
import io.fincast.portfolio.impl.YieldCompo;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001.B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ\t\u0010\u001d\u001a\u00020\tH\u00c6\u0003JD\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u001fJ\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u00d6\u0003J\t\u0010+\u001a\u00020,H\u00d6\u0001J\t\u0010-\u001a\u00020\u0003H\u00d6\u0001R\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006/"}, d2={"Lio/fincast/household/impl/MoneyAccount;", "Lio/fincast/household/Valuable;", "tag", "", "reconBalance", "", "creditInterestRate", "debitInterestRate", "interestPeriodicity", "Lio/fincast/enums/Periodicity;", "(Ljava/lang/String;DLjava/lang/Double;Ljava/lang/Double;Lio/fincast/enums/Periodicity;)V", "getCreditInterestRate", "()Ljava/lang/Double;", "Ljava/lang/Double;", "getDebitInterestRate", "getInterestPeriodicity", "()Lio/fincast/enums/Periodicity;", "productType", "Lio/fincast/enums/ProductType;", "getProductType", "()Lio/fincast/enums/ProductType;", "getReconBalance", "()D", "getTag", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "copy", "(Ljava/lang/String;DLjava/lang/Double;Ljava/lang/Double;Lio/fincast/enums/Periodicity;)Lio/fincast/household/impl/MoneyAccount;", "createCompos", "", "Lio/fincast/portfolio/PositionCompo;", "portfolio", "Lio/fincast/portfolio/Portfolio;", "pos", "Lio/fincast/portfolio/Position;", "equals", "", "other", "", "hashCode", "", "toString", "Builder", "fincast"})
public final class MoneyAccount
implements Valuable {
    @NotNull
    private final String tag;
    private final double reconBalance;
    @Nullable
    private final Double creditInterestRate;
    @Nullable
    private final Double debitInterestRate;
    @NotNull
    private final Periodicity interestPeriodicity;
    @NotNull
    private final ProductType productType;

    public MoneyAccount(@NotNull String tag, double reconBalance, @Nullable Double creditInterestRate, @Nullable Double debitInterestRate, @NotNull Periodicity interestPeriodicity) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)interestPeriodicity), (String)"interestPeriodicity");
        this.tag = tag;
        this.reconBalance = reconBalance;
        this.creditInterestRate = creditInterestRate;
        this.debitInterestRate = debitInterestRate;
        this.interestPeriodicity = interestPeriodicity;
        this.productType = ProductType.VALUABLE;
    }

    public /* synthetic */ MoneyAccount(String string, double d, Double d2, Double d3, Periodicity periodicity, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = 0.0;
        }
        if ((n & 4) != 0) {
            d2 = 0.0;
        }
        if ((n & 8) != 0) {
            d3 = 0.0;
        }
        if ((n & 0x10) != 0) {
            periodicity = Periodicity.YEARLY;
        }
        this(string, d, d2, d3, periodicity);
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @Override
    public double getReconBalance() {
        return this.reconBalance;
    }

    @Nullable
    public final Double getCreditInterestRate() {
        return this.creditInterestRate;
    }

    @Nullable
    public final Double getDebitInterestRate() {
        return this.debitInterestRate;
    }

    @NotNull
    public final Periodicity getInterestPeriodicity() {
        return this.interestPeriodicity;
    }

    @Override
    @NotNull
    public ProductType getProductType() {
        return this.productType;
    }

    @Override
    @NotNull
    public List<PositionCompo> createCompos(@NotNull Portfolio portfolio, @NotNull Position pos) {
        Intrinsics.checkNotNullParameter((Object)portfolio, (String)"portfolio");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        List compos = new ArrayList();
        if (this.creditInterestRate != null && !Intrinsics.areEqual((Double)this.creditInterestRate, (double)0.0)) {
            compos.add(new YieldCompo(pos, "creditInterest", ValueProviders.eomCreditBalance(pos), ValueProviders.constValue(this.creditInterestRate), this.interestPeriodicity, BookingKind.INTEREST, FundsAllocation.COMPOUND));
        }
        if (this.debitInterestRate != null && !Intrinsics.areEqual((Double)this.debitInterestRate, (double)0.0)) {
            compos.add(new YieldCompo(pos, "debitInterest", ValueProviders.eomDebitBalance(pos), ValueProviders.constValue(this.debitInterestRate), this.interestPeriodicity, BookingKind.INTEREST, FundsAllocation.COMPOUND));
        }
        return compos;
    }

    @Override
    @NotNull
    public Position createPosition(@NotNull Portfolio portfolio) {
        return Valuable.DefaultImpls.createPosition(this, portfolio);
    }

    @NotNull
    public final String component1() {
        return this.tag;
    }

    public final double component2() {
        return this.reconBalance;
    }

    @Nullable
    public final Double component3() {
        return this.creditInterestRate;
    }

    @Nullable
    public final Double component4() {
        return this.debitInterestRate;
    }

    @NotNull
    public final Periodicity component5() {
        return this.interestPeriodicity;
    }

    @NotNull
    public final MoneyAccount copy(@NotNull String tag, double reconBalance, @Nullable Double creditInterestRate, @Nullable Double debitInterestRate, @NotNull Periodicity interestPeriodicity) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)interestPeriodicity), (String)"interestPeriodicity");
        return new MoneyAccount(tag, reconBalance, creditInterestRate, debitInterestRate, interestPeriodicity);
    }

    public static /* synthetic */ MoneyAccount copy$default(MoneyAccount moneyAccount, String string, double d, Double d2, Double d3, Periodicity periodicity, int n, Object object) {
        if ((n & 1) != 0) {
            string = moneyAccount.tag;
        }
        if ((n & 2) != 0) {
            d = moneyAccount.reconBalance;
        }
        if ((n & 4) != 0) {
            d2 = moneyAccount.creditInterestRate;
        }
        if ((n & 8) != 0) {
            d3 = moneyAccount.debitInterestRate;
        }
        if ((n & 0x10) != 0) {
            periodicity = moneyAccount.interestPeriodicity;
        }
        return moneyAccount.copy(string, d, d2, d3, periodicity);
    }

    @NotNull
    public String toString() {
        return "MoneyAccount(tag=" + this.tag + ", reconBalance=" + this.reconBalance + ", creditInterestRate=" + this.creditInterestRate + ", debitInterestRate=" + this.debitInterestRate + ", interestPeriodicity=" + this.interestPeriodicity + ")";
    }

    public int hashCode() {
        int result = this.tag.hashCode();
        result = result * 31 + Double.hashCode(this.reconBalance);
        result = result * 31 + (this.creditInterestRate == null ? 0 : ((Object)this.creditInterestRate).hashCode());
        result = result * 31 + (this.debitInterestRate == null ? 0 : ((Object)this.debitInterestRate).hashCode());
        result = result * 31 + this.interestPeriodicity.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MoneyAccount)) {
            return false;
        }
        MoneyAccount moneyAccount = (MoneyAccount)other;
        if (!Intrinsics.areEqual((Object)this.tag, (Object)moneyAccount.tag)) {
            return false;
        }
        if (Double.compare(this.reconBalance, moneyAccount.reconBalance) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.creditInterestRate, (Object)moneyAccount.creditInterestRate)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.debitInterestRate, (Object)moneyAccount.debitInterestRate)) {
            return false;
        }
        return this.interestPeriodicity == moneyAccount.interestPeriodicity;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\rJ\u0015\u0010\u0003\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u0006\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0007\u001a\u00020\u00002\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0015\u0010\t\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bR\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/fincast/household/impl/MoneyAccount$Builder;", "", "()V", "creditInterestRate", "", "Ljava/lang/Double;", "debitInterestRate", "interestPeriodicity", "Lio/fincast/enums/Periodicity;", "reconBalance", "tag", "", "build", "Lio/fincast/household/impl/MoneyAccount;", "(Ljava/lang/Double;)Lio/fincast/household/impl/MoneyAccount$Builder;", "fincast"})
    @SourceDebugExtension(value={"SMAP\nMoneyAccount.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MoneyAccount.kt\nio/fincast/household/impl/MoneyAccount$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n1#2:81\n*E\n"})
    public static final class Builder {
        @Nullable
        private String tag;
        @Nullable
        private Double reconBalance;
        @Nullable
        private Double creditInterestRate;
        @Nullable
        private Double debitInterestRate;
        @Nullable
        private Periodicity interestPeriodicity;

        @NotNull
        public final Builder tag(@NotNull String tag) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Builder $this$tag_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$tag_u24lambda_u240.tag = tag;
            return builder;
        }

        @NotNull
        public final Builder reconBalance(@Nullable Double reconBalance) {
            Builder builder;
            Builder $this$reconBalance_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$reconBalance_u24lambda_u241.reconBalance = reconBalance;
            return builder;
        }

        @NotNull
        public final Builder creditInterestRate(@Nullable Double creditInterestRate) {
            Builder builder;
            Builder $this$creditInterestRate_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$creditInterestRate_u24lambda_u242.creditInterestRate = creditInterestRate;
            return builder;
        }

        @NotNull
        public final Builder debitInterestRate(@Nullable Double debitInterestRate) {
            Builder builder;
            Builder $this$debitInterestRate_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$debitInterestRate_u24lambda_u243.debitInterestRate = debitInterestRate;
            return builder;
        }

        @NotNull
        public final Builder interestPeriodicity(@Nullable Periodicity interestPeriodicity) {
            Builder builder;
            Builder $this$interestPeriodicity_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$interestPeriodicity_u24lambda_u244.interestPeriodicity = interestPeriodicity;
            return builder;
        }

        @NotNull
        public final MoneyAccount build() {
            String string = this.tag;
            if (string == null) {
                throw new IllegalArgumentException("tag is required");
            }
            Double d = this.reconBalance;
            double d2 = d != null ? d : 0.0;
            Double d3 = this.creditInterestRate;
            Double d4 = d3 != null ? d3 : 0.0;
            Double d5 = this.debitInterestRate;
            Double d6 = d5 != null ? d5 : 0.0;
            Periodicity periodicity = this.interestPeriodicity;
            if (periodicity == null) {
                periodicity = Periodicity.YEARLY;
            }
            return new MoneyAccount(string, d2, d4, d6, periodicity);
        }
    }
}

