/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.household.impl;

import io.fincast.enums.BookingKind;
import io.fincast.enums.FundsAllocation;
import io.fincast.enums.Periodicity;
import io.fincast.enums.ProductType;
import io.fincast.household.Valuable;
import io.fincast.portfolio.Portfolio;
import io.fincast.portfolio.Position;
import io.fincast.portfolio.PositionCompo;
import io.fincast.portfolio.ValueProvider;
import io.fincast.portfolio.ValueProviders;
import io.fincast.portfolio.impl.CashflowCompo;
import io.fincast.portfolio.impl.TransferCompo;
import io.fincast.portfolio.impl.YieldCompo;
import io.fincast.util.SimDate;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0002\b$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001bB\u00f1\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\f\u001a\u00020\u0005\u0012\b\b\u0002\u0010\r\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0012\u0012\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u001cJ\t\u0010=\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010>\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010?\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u001eJ\t\u0010@\u001a\u00020\u0012H\u00c6\u0003J\u0010\u0010A\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u001eJ\t\u0010B\u001a\u00020\u0012H\u00c6\u0003J\u0010\u0010C\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010D\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010E\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010F\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u001eJ\u000b\u0010G\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\t\u0010H\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010I\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000b\u0010J\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u0010\u0010K\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u001eJ\u000b\u0010L\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u0010M\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000b\u0010N\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\t\u0010O\u001a\u00020\u0005H\u00c6\u0003J\t\u0010P\u001a\u00020\u0005H\u00c6\u0003J\t\u0010Q\u001a\u00020\u0005H\u00c6\u0003J\u00fc\u0001\u0010R\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\f\u001a\u00020\u00052\b\b\u0002\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u00052\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0014\u001a\u00020\u00122\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\nH\u00c6\u0001\u00a2\u0006\u0002\u0010SJ\u001e\u0010T\u001a\b\u0012\u0004\u0012\u00020V0U2\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020ZH\u0016J\u0013\u0010[\u001a\u00020\\2\b\u0010]\u001a\u0004\u0018\u00010^H\u00d6\u0003J\t\u0010_\u001a\u00020`H\u00d6\u0001J\t\u0010a\u001a\u00020\u0003H\u00d6\u0001R\u0015\u0010\u0010\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u001f\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0015\u0010\u000f\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u001f\u001a\u0004\b\"\u0010\u001eR\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010!R\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u001f\u001a\u0004\b$\u0010\u001eR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010&R\u0011\u0010\u0014\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010+R\u0015\u0010\u0016\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u001f\u001a\u0004\b-\u0010\u001eR\u0015\u0010\u0017\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u001f\u001a\u0004\b.\u0010\u001eR\u0014\u0010/\u001a\u000200X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010!R\u0015\u0010\u0015\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u001f\u001a\u0004\b4\u0010\u001eR\u0015\u0010\u0013\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u001f\u001a\u0004\b5\u0010\u001eR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010!R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0015\u0010\u0018\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u001f\u001a\u0004\b9\u0010\u001eR\u0013\u0010\u001b\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010&R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010(R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010&\u00a8\u0006c"}, d2={"Lio/fincast/household/impl/InvestmentAccount;", "Lio/fincast/household/Valuable;", "tag", "", "reconBalance", "", "contributionAmount", "contributionPeriodicity", "Lio/fincast/enums/Periodicity;", "contributionStartDate", "Lio/fincast/util/SimDate;", "contributionEndDate", "cashPart", "bondPart", "stockPart", "cashInterestRate", "bondInterestRate", "interestAllocation", "Lio/fincast/enums/FundsAllocation;", "stockDividendYield", "dividendAllocation", "stockCapitalGain", "managementFee", "performanceFee", "withdrawalAmount", "withdrawalPeriodicity", "withdrawalStartDate", "withdrawalEndDate", "(Ljava/lang/String;DLjava/lang/Double;Lio/fincast/enums/Periodicity;Lio/fincast/util/SimDate;Lio/fincast/util/SimDate;DDDLjava/lang/Double;Ljava/lang/Double;Lio/fincast/enums/FundsAllocation;Ljava/lang/Double;Lio/fincast/enums/FundsAllocation;Ljava/lang/Double;Ljava/lang/Double;Ljava/lang/Double;Ljava/lang/Double;Lio/fincast/enums/Periodicity;Lio/fincast/util/SimDate;Lio/fincast/util/SimDate;)V", "getBondInterestRate", "()Ljava/lang/Double;", "Ljava/lang/Double;", "getBondPart", "()D", "getCashInterestRate", "getCashPart", "getContributionAmount", "getContributionEndDate", "()Lio/fincast/util/SimDate;", "getContributionPeriodicity", "()Lio/fincast/enums/Periodicity;", "getContributionStartDate", "getDividendAllocation", "()Lio/fincast/enums/FundsAllocation;", "getInterestAllocation", "getManagementFee", "getPerformanceFee", "productType", "Lio/fincast/enums/ProductType;", "getProductType", "()Lio/fincast/enums/ProductType;", "getReconBalance", "getStockCapitalGain", "getStockDividendYield", "getStockPart", "getTag", "()Ljava/lang/String;", "getWithdrawalAmount", "getWithdrawalEndDate", "getWithdrawalPeriodicity", "getWithdrawalStartDate", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component18", "component19", "component2", "component20", "component21", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Ljava/lang/String;DLjava/lang/Double;Lio/fincast/enums/Periodicity;Lio/fincast/util/SimDate;Lio/fincast/util/SimDate;DDDLjava/lang/Double;Ljava/lang/Double;Lio/fincast/enums/FundsAllocation;Ljava/lang/Double;Lio/fincast/enums/FundsAllocation;Ljava/lang/Double;Ljava/lang/Double;Ljava/lang/Double;Ljava/lang/Double;Lio/fincast/enums/Periodicity;Lio/fincast/util/SimDate;Lio/fincast/util/SimDate;)Lio/fincast/household/impl/InvestmentAccount;", "createCompos", "", "Lio/fincast/portfolio/PositionCompo;", "portfolio", "Lio/fincast/portfolio/Portfolio;", "pos", "Lio/fincast/portfolio/Position;", "equals", "", "other", "", "hashCode", "", "toString", "Builder", "fincast"})
public final class InvestmentAccount
implements Valuable {
    @NotNull
    private final String tag;
    private final double reconBalance;
    @Nullable
    private final Double contributionAmount;
    @Nullable
    private final Periodicity contributionPeriodicity;
    @Nullable
    private final SimDate contributionStartDate;
    @Nullable
    private final SimDate contributionEndDate;
    private final double cashPart;
    private final double bondPart;
    private final double stockPart;
    @Nullable
    private final Double cashInterestRate;
    @Nullable
    private final Double bondInterestRate;
    @NotNull
    private final FundsAllocation interestAllocation;
    @Nullable
    private final Double stockDividendYield;
    @NotNull
    private final FundsAllocation dividendAllocation;
    @Nullable
    private final Double stockCapitalGain;
    @Nullable
    private final Double managementFee;
    @Nullable
    private final Double performanceFee;
    @Nullable
    private final Double withdrawalAmount;
    @Nullable
    private final Periodicity withdrawalPeriodicity;
    @Nullable
    private final SimDate withdrawalStartDate;
    @Nullable
    private final SimDate withdrawalEndDate;
    @NotNull
    private final ProductType productType;

    public InvestmentAccount(@NotNull String tag, double reconBalance, @Nullable Double contributionAmount, @Nullable Periodicity contributionPeriodicity, @Nullable SimDate contributionStartDate, @Nullable SimDate contributionEndDate, double cashPart, double bondPart, double stockPart, @Nullable Double cashInterestRate, @Nullable Double bondInterestRate, @NotNull FundsAllocation interestAllocation, @Nullable Double stockDividendYield, @NotNull FundsAllocation dividendAllocation, @Nullable Double stockCapitalGain, @Nullable Double managementFee, @Nullable Double performanceFee, @Nullable Double withdrawalAmount, @Nullable Periodicity withdrawalPeriodicity, @Nullable SimDate withdrawalStartDate, @Nullable SimDate withdrawalEndDate) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)interestAllocation), (String)"interestAllocation");
        Intrinsics.checkNotNullParameter((Object)((Object)dividendAllocation), (String)"dividendAllocation");
        this.tag = tag;
        this.reconBalance = reconBalance;
        this.contributionAmount = contributionAmount;
        this.contributionPeriodicity = contributionPeriodicity;
        this.contributionStartDate = contributionStartDate;
        this.contributionEndDate = contributionEndDate;
        this.cashPart = cashPart;
        this.bondPart = bondPart;
        this.stockPart = stockPart;
        this.cashInterestRate = cashInterestRate;
        this.bondInterestRate = bondInterestRate;
        this.interestAllocation = interestAllocation;
        this.stockDividendYield = stockDividendYield;
        this.dividendAllocation = dividendAllocation;
        this.stockCapitalGain = stockCapitalGain;
        this.managementFee = managementFee;
        this.performanceFee = performanceFee;
        this.withdrawalAmount = withdrawalAmount;
        this.withdrawalPeriodicity = withdrawalPeriodicity;
        this.withdrawalStartDate = withdrawalStartDate;
        this.withdrawalEndDate = withdrawalEndDate;
        this.productType = ProductType.ASSET;
    }

    public /* synthetic */ InvestmentAccount(String string, double d, Double d2, Periodicity periodicity, SimDate simDate, SimDate simDate2, double d3, double d4, double d5, Double d6, Double d7, FundsAllocation fundsAllocation, Double d8, FundsAllocation fundsAllocation2, Double d9, Double d10, Double d11, Double d12, Periodicity periodicity2, SimDate simDate3, SimDate simDate4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = 0.0;
        }
        if ((n & 4) != 0) {
            d2 = null;
        }
        if ((n & 8) != 0) {
            periodicity = null;
        }
        if ((n & 0x10) != 0) {
            simDate = null;
        }
        if ((n & 0x20) != 0) {
            simDate2 = null;
        }
        if ((n & 0x40) != 0) {
            d3 = 0.0;
        }
        if ((n & 0x80) != 0) {
            d4 = 0.0;
        }
        if ((n & 0x100) != 0) {
            d5 = 0.0;
        }
        if ((n & 0x200) != 0) {
            d6 = null;
        }
        if ((n & 0x400) != 0) {
            d7 = null;
        }
        if ((n & 0x800) != 0) {
            fundsAllocation = FundsAllocation.COMPOUND;
        }
        if ((n & 0x1000) != 0) {
            d8 = null;
        }
        if ((n & 0x2000) != 0) {
            fundsAllocation2 = FundsAllocation.DISBURSE;
        }
        if ((n & 0x4000) != 0) {
            d9 = null;
        }
        if ((n & 0x8000) != 0) {
            d10 = 0.0;
        }
        if ((n & 0x10000) != 0) {
            d11 = 0.0;
        }
        if ((n & 0x20000) != 0) {
            d12 = null;
        }
        if ((n & 0x40000) != 0) {
            periodicity2 = null;
        }
        if ((n & 0x80000) != 0) {
            simDate3 = null;
        }
        if ((n & 0x100000) != 0) {
            simDate4 = null;
        }
        this(string, d, d2, periodicity, simDate, simDate2, d3, d4, d5, d6, d7, fundsAllocation, d8, fundsAllocation2, d9, d10, d11, d12, periodicity2, simDate3, simDate4);
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @Override
    public double getReconBalance() {
        return this.reconBalance;
    }

    @Nullable
    public final Double getContributionAmount() {
        return this.contributionAmount;
    }

    @Nullable
    public final Periodicity getContributionPeriodicity() {
        return this.contributionPeriodicity;
    }

    @Nullable
    public final SimDate getContributionStartDate() {
        return this.contributionStartDate;
    }

    @Nullable
    public final SimDate getContributionEndDate() {
        return this.contributionEndDate;
    }

    public final double getCashPart() {
        return this.cashPart;
    }

    public final double getBondPart() {
        return this.bondPart;
    }

    public final double getStockPart() {
        return this.stockPart;
    }

    @Nullable
    public final Double getCashInterestRate() {
        return this.cashInterestRate;
    }

    @Nullable
    public final Double getBondInterestRate() {
        return this.bondInterestRate;
    }

    @NotNull
    public final FundsAllocation getInterestAllocation() {
        return this.interestAllocation;
    }

    @Nullable
    public final Double getStockDividendYield() {
        return this.stockDividendYield;
    }

    @NotNull
    public final FundsAllocation getDividendAllocation() {
        return this.dividendAllocation;
    }

    @Nullable
    public final Double getStockCapitalGain() {
        return this.stockCapitalGain;
    }

    @Nullable
    public final Double getManagementFee() {
        return this.managementFee;
    }

    @Nullable
    public final Double getPerformanceFee() {
        return this.performanceFee;
    }

    @Nullable
    public final Double getWithdrawalAmount() {
        return this.withdrawalAmount;
    }

    @Nullable
    public final Periodicity getWithdrawalPeriodicity() {
        return this.withdrawalPeriodicity;
    }

    @Nullable
    public final SimDate getWithdrawalStartDate() {
        return this.withdrawalStartDate;
    }

    @Nullable
    public final SimDate getWithdrawalEndDate() {
        return this.withdrawalEndDate;
    }

    @Override
    @NotNull
    public ProductType getProductType() {
        return this.productType;
    }

    @Override
    @NotNull
    public List<PositionCompo> createCompos(@NotNull Portfolio portfolio, @NotNull Position pos) {
        Periodicity periodicity;
        SimDate simDate;
        ValueProvider<Double> valueProvider;
        Position position;
        SimDate startDate;
        Intrinsics.checkNotNullParameter((Object)portfolio, (String)"portfolio");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        List compos = new ArrayList();
        if (this.contributionAmount != null && this.contributionAmount > 0.0) {
            SimDate simDate2 = this.contributionStartDate;
            if (simDate2 == null) {
                simDate2 = portfolio.getReconDate();
            }
            startDate = SimDate.Companion.max(simDate2, portfolio.getReconDate());
            position = portfolio.getPocketMoney();
            valueProvider = ValueProviders.constValue(this.contributionAmount);
            simDate = this.contributionEndDate;
            Periodicity periodicity2 = this.contributionPeriodicity;
            if (periodicity2 == null) {
                periodicity2 = Periodicity.YEARLY;
            }
            periodicity = periodicity2;
            compos.add(new TransferCompo(pos, "contribution", position, pos, valueProvider, -1, periodicity, startDate, simDate));
        }
        if (!(this.cashPart == 0.0) && this.cashInterestRate != null && !Intrinsics.areEqual((Double)this.cashInterestRate, (double)0.0)) {
            compos.add(new YieldCompo(pos, "cashInterest", ValueProviders.eomBalance(pos), ValueProviders.constValue(this.cashPart / 100.0 * this.cashInterestRate), Periodicity.YEARLY, BookingKind.INTEREST, this.interestAllocation));
        }
        if (!(this.bondPart == 0.0) && this.bondInterestRate != null && !Intrinsics.areEqual((Double)this.bondInterestRate, (double)0.0)) {
            compos.add(new YieldCompo(pos, "bondInterest", ValueProviders.eomBalance(pos), ValueProviders.constValue(this.bondPart / 100.0 * this.bondInterestRate), Periodicity.YEARLY, BookingKind.INTEREST, this.interestAllocation));
        }
        if (!(this.stockPart == 0.0)) {
            if (this.stockDividendYield != null && !Intrinsics.areEqual((Double)this.stockDividendYield, (double)0.0)) {
                compos.add(new YieldCompo(pos, "dividend", ValueProviders.eomBalance(pos), ValueProviders.constValue(this.stockPart / 100.0 * this.stockDividendYield), Periodicity.YEARLY, BookingKind.DIVIDEND, this.dividendAllocation));
            }
            if (this.stockCapitalGain != null && !Intrinsics.areEqual((Double)this.stockCapitalGain, (double)0.0)) {
                compos.add(new YieldCompo(pos, "capitalGain", ValueProviders.eomBalance(pos), ValueProviders.constValue(this.stockPart / 100.0 * this.stockCapitalGain), Periodicity.YEARLY, BookingKind.CAPITAL_GAIN, FundsAllocation.COMPOUND));
            }
        }
        if (this.managementFee != null && !Intrinsics.areEqual((Double)this.managementFee, (double)0.0)) {
            compos.add(new CashflowCompo(pos, "managementFee", FundsAllocation.COMPOUND, arg_0 -> InvestmentAccount.createCompos$lambda$0(this, pos, arg_0), -1, Periodicity.YEARLY, null, null, false, 448, null));
        }
        if (this.performanceFee != null && !Intrinsics.areEqual((Double)this.performanceFee, (double)0.0)) {
            compos.add(new CashflowCompo(pos, "performanceFee", FundsAllocation.COMPOUND, arg_0 -> InvestmentAccount.createCompos$lambda$1(this, pos, arg_0), -1, Periodicity.YEARLY, null, null, false, 448, null));
        }
        if (this.withdrawalAmount != null && this.withdrawalAmount > 0.0) {
            SimDate simDate3 = this.withdrawalStartDate;
            if (simDate3 == null) {
                simDate3 = portfolio.getReconDate();
            }
            startDate = SimDate.Companion.max(simDate3, portfolio.getReconDate());
            position = portfolio.getPocketMoney();
            valueProvider = ValueProviders.constValue(this.withdrawalAmount);
            simDate = this.withdrawalEndDate;
            Periodicity periodicity3 = this.withdrawalPeriodicity;
            if (periodicity3 == null) {
                periodicity3 = Periodicity.YEARLY;
            }
            periodicity = periodicity3;
            compos.add(new TransferCompo(pos, "withdrawal", pos, position, valueProvider, -1, periodicity, startDate, simDate));
        }
        return compos;
    }

    @Override
    @NotNull
    public Position createPosition(@NotNull Portfolio portfolio) {
        return Valuable.DefaultImpls.createPosition(this, portfolio);
    }

    @NotNull
    public final String component1() {
        return this.tag;
    }

    public final double component2() {
        return this.reconBalance;
    }

    @Nullable
    public final Double component3() {
        return this.contributionAmount;
    }

    @Nullable
    public final Periodicity component4() {
        return this.contributionPeriodicity;
    }

    @Nullable
    public final SimDate component5() {
        return this.contributionStartDate;
    }

    @Nullable
    public final SimDate component6() {
        return this.contributionEndDate;
    }

    public final double component7() {
        return this.cashPart;
    }

    public final double component8() {
        return this.bondPart;
    }

    public final double component9() {
        return this.stockPart;
    }

    @Nullable
    public final Double component10() {
        return this.cashInterestRate;
    }

    @Nullable
    public final Double component11() {
        return this.bondInterestRate;
    }

    @NotNull
    public final FundsAllocation component12() {
        return this.interestAllocation;
    }

    @Nullable
    public final Double component13() {
        return this.stockDividendYield;
    }

    @NotNull
    public final FundsAllocation component14() {
        return this.dividendAllocation;
    }

    @Nullable
    public final Double component15() {
        return this.stockCapitalGain;
    }

    @Nullable
    public final Double component16() {
        return this.managementFee;
    }

    @Nullable
    public final Double component17() {
        return this.performanceFee;
    }

    @Nullable
    public final Double component18() {
        return this.withdrawalAmount;
    }

    @Nullable
    public final Periodicity component19() {
        return this.withdrawalPeriodicity;
    }

    @Nullable
    public final SimDate component20() {
        return this.withdrawalStartDate;
    }

    @Nullable
    public final SimDate component21() {
        return this.withdrawalEndDate;
    }

    @NotNull
    public final InvestmentAccount copy(@NotNull String tag, double reconBalance, @Nullable Double contributionAmount, @Nullable Periodicity contributionPeriodicity, @Nullable SimDate contributionStartDate, @Nullable SimDate contributionEndDate, double cashPart, double bondPart, double stockPart, @Nullable Double cashInterestRate, @Nullable Double bondInterestRate, @NotNull FundsAllocation interestAllocation, @Nullable Double stockDividendYield, @NotNull FundsAllocation dividendAllocation, @Nullable Double stockCapitalGain, @Nullable Double managementFee, @Nullable Double performanceFee, @Nullable Double withdrawalAmount, @Nullable Periodicity withdrawalPeriodicity, @Nullable SimDate withdrawalStartDate, @Nullable SimDate withdrawalEndDate) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)interestAllocation), (String)"interestAllocation");
        Intrinsics.checkNotNullParameter((Object)((Object)dividendAllocation), (String)"dividendAllocation");
        return new InvestmentAccount(tag, reconBalance, contributionAmount, contributionPeriodicity, contributionStartDate, contributionEndDate, cashPart, bondPart, stockPart, cashInterestRate, bondInterestRate, interestAllocation, stockDividendYield, dividendAllocation, stockCapitalGain, managementFee, performanceFee, withdrawalAmount, withdrawalPeriodicity, withdrawalStartDate, withdrawalEndDate);
    }

    public static /* synthetic */ InvestmentAccount copy$default(InvestmentAccount investmentAccount, String string, double d, Double d2, Periodicity periodicity, SimDate simDate, SimDate simDate2, double d3, double d4, double d5, Double d6, Double d7, FundsAllocation fundsAllocation, Double d8, FundsAllocation fundsAllocation2, Double d9, Double d10, Double d11, Double d12, Periodicity periodicity2, SimDate simDate3, SimDate simDate4, int n, Object object) {
        if ((n & 1) != 0) {
            string = investmentAccount.tag;
        }
        if ((n & 2) != 0) {
            d = investmentAccount.reconBalance;
        }
        if ((n & 4) != 0) {
            d2 = investmentAccount.contributionAmount;
        }
        if ((n & 8) != 0) {
            periodicity = investmentAccount.contributionPeriodicity;
        }
        if ((n & 0x10) != 0) {
            simDate = investmentAccount.contributionStartDate;
        }
        if ((n & 0x20) != 0) {
            simDate2 = investmentAccount.contributionEndDate;
        }
        if ((n & 0x40) != 0) {
            d3 = investmentAccount.cashPart;
        }
        if ((n & 0x80) != 0) {
            d4 = investmentAccount.bondPart;
        }
        if ((n & 0x100) != 0) {
            d5 = investmentAccount.stockPart;
        }
        if ((n & 0x200) != 0) {
            d6 = investmentAccount.cashInterestRate;
        }
        if ((n & 0x400) != 0) {
            d7 = investmentAccount.bondInterestRate;
        }
        if ((n & 0x800) != 0) {
            fundsAllocation = investmentAccount.interestAllocation;
        }
        if ((n & 0x1000) != 0) {
            d8 = investmentAccount.stockDividendYield;
        }
        if ((n & 0x2000) != 0) {
            fundsAllocation2 = investmentAccount.dividendAllocation;
        }
        if ((n & 0x4000) != 0) {
            d9 = investmentAccount.stockCapitalGain;
        }
        if ((n & 0x8000) != 0) {
            d10 = investmentAccount.managementFee;
        }
        if ((n & 0x10000) != 0) {
            d11 = investmentAccount.performanceFee;
        }
        if ((n & 0x20000) != 0) {
            d12 = investmentAccount.withdrawalAmount;
        }
        if ((n & 0x40000) != 0) {
            periodicity2 = investmentAccount.withdrawalPeriodicity;
        }
        if ((n & 0x80000) != 0) {
            simDate3 = investmentAccount.withdrawalStartDate;
        }
        if ((n & 0x100000) != 0) {
            simDate4 = investmentAccount.withdrawalEndDate;
        }
        return investmentAccount.copy(string, d, d2, periodicity, simDate, simDate2, d3, d4, d5, d6, d7, fundsAllocation, d8, fundsAllocation2, d9, d10, d11, d12, periodicity2, simDate3, simDate4);
    }

    @NotNull
    public String toString() {
        return "InvestmentAccount(tag=" + this.tag + ", reconBalance=" + this.reconBalance + ", contributionAmount=" + this.contributionAmount + ", contributionPeriodicity=" + this.contributionPeriodicity + ", contributionStartDate=" + this.contributionStartDate + ", contributionEndDate=" + this.contributionEndDate + ", cashPart=" + this.cashPart + ", bondPart=" + this.bondPart + ", stockPart=" + this.stockPart + ", cashInterestRate=" + this.cashInterestRate + ", bondInterestRate=" + this.bondInterestRate + ", interestAllocation=" + this.interestAllocation + ", stockDividendYield=" + this.stockDividendYield + ", dividendAllocation=" + this.dividendAllocation + ", stockCapitalGain=" + this.stockCapitalGain + ", managementFee=" + this.managementFee + ", performanceFee=" + this.performanceFee + ", withdrawalAmount=" + this.withdrawalAmount + ", withdrawalPeriodicity=" + this.withdrawalPeriodicity + ", withdrawalStartDate=" + this.withdrawalStartDate + ", withdrawalEndDate=" + this.withdrawalEndDate + ")";
    }

    public int hashCode() {
        int result = this.tag.hashCode();
        result = result * 31 + Double.hashCode(this.reconBalance);
        result = result * 31 + (this.contributionAmount == null ? 0 : ((Object)this.contributionAmount).hashCode());
        result = result * 31 + (this.contributionPeriodicity == null ? 0 : this.contributionPeriodicity.hashCode());
        result = result * 31 + (this.contributionStartDate == null ? 0 : this.contributionStartDate.hashCode());
        result = result * 31 + (this.contributionEndDate == null ? 0 : this.contributionEndDate.hashCode());
        result = result * 31 + Double.hashCode(this.cashPart);
        result = result * 31 + Double.hashCode(this.bondPart);
        result = result * 31 + Double.hashCode(this.stockPart);
        result = result * 31 + (this.cashInterestRate == null ? 0 : ((Object)this.cashInterestRate).hashCode());
        result = result * 31 + (this.bondInterestRate == null ? 0 : ((Object)this.bondInterestRate).hashCode());
        result = result * 31 + this.interestAllocation.hashCode();
        result = result * 31 + (this.stockDividendYield == null ? 0 : ((Object)this.stockDividendYield).hashCode());
        result = result * 31 + this.dividendAllocation.hashCode();
        result = result * 31 + (this.stockCapitalGain == null ? 0 : ((Object)this.stockCapitalGain).hashCode());
        result = result * 31 + (this.managementFee == null ? 0 : ((Object)this.managementFee).hashCode());
        result = result * 31 + (this.performanceFee == null ? 0 : ((Object)this.performanceFee).hashCode());
        result = result * 31 + (this.withdrawalAmount == null ? 0 : ((Object)this.withdrawalAmount).hashCode());
        result = result * 31 + (this.withdrawalPeriodicity == null ? 0 : this.withdrawalPeriodicity.hashCode());
        result = result * 31 + (this.withdrawalStartDate == null ? 0 : this.withdrawalStartDate.hashCode());
        result = result * 31 + (this.withdrawalEndDate == null ? 0 : this.withdrawalEndDate.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InvestmentAccount)) {
            return false;
        }
        InvestmentAccount investmentAccount = (InvestmentAccount)other;
        if (!Intrinsics.areEqual((Object)this.tag, (Object)investmentAccount.tag)) {
            return false;
        }
        if (Double.compare(this.reconBalance, investmentAccount.reconBalance) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.contributionAmount, (Object)investmentAccount.contributionAmount)) {
            return false;
        }
        if (this.contributionPeriodicity != investmentAccount.contributionPeriodicity) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.contributionStartDate, (Object)investmentAccount.contributionStartDate)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.contributionEndDate, (Object)investmentAccount.contributionEndDate)) {
            return false;
        }
        if (Double.compare(this.cashPart, investmentAccount.cashPart) != 0) {
            return false;
        }
        if (Double.compare(this.bondPart, investmentAccount.bondPart) != 0) {
            return false;
        }
        if (Double.compare(this.stockPart, investmentAccount.stockPart) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.cashInterestRate, (Object)investmentAccount.cashInterestRate)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.bondInterestRate, (Object)investmentAccount.bondInterestRate)) {
            return false;
        }
        if (this.interestAllocation != investmentAccount.interestAllocation) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.stockDividendYield, (Object)investmentAccount.stockDividendYield)) {
            return false;
        }
        if (this.dividendAllocation != investmentAccount.dividendAllocation) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.stockCapitalGain, (Object)investmentAccount.stockCapitalGain)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.managementFee, (Object)investmentAccount.managementFee)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.performanceFee, (Object)investmentAccount.performanceFee)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.withdrawalAmount, (Object)investmentAccount.withdrawalAmount)) {
            return false;
        }
        if (this.withdrawalPeriodicity != investmentAccount.withdrawalPeriodicity) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.withdrawalStartDate, (Object)investmentAccount.withdrawalStartDate)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.withdrawalEndDate, (Object)investmentAccount.withdrawalEndDate);
    }

    private static final double createCompos$lambda$0(InvestmentAccount this$0, Position $pos, SimDate it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$pos, (String)"$pos");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.managementFee / (double)100 * $pos.getBalance(it);
    }

    private static final double createCompos$lambda$1(InvestmentAccount this$0, Position $pos, SimDate it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$pos, (String)"$pos");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.performanceFee / (double)100 * ($pos.getBalance(it) - $pos.getBalance(it.addYears(-1)));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u001eJ\u0015\u0010\u0006\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u001eJ\u0006\u0010\u001f\u001a\u00020 J\u0015\u0010\u0007\u001a\u00020\u00002\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u001eJ\u0015\u0010\b\u001a\u00020\u00002\b\u0010\b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u001eJ\u0015\u0010\t\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\n\u001a\u00020\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\f\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u000e\u001a\u00020\u00002\b\u0010\u000e\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\u000f\u001a\u00020\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0010\u0010\u0011\u001a\u00020\u00002\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010J\u0015\u0010\u0012\u001a\u00020\u00002\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u001eJ\u0015\u0010\u0013\u001a\u00020\u00002\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u001eJ\u0015\u0010\u0014\u001a\u00020\u00002\b\u0010\u0014\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u001eJ\u0015\u0010\u0015\u001a\u00020\u00002\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u001eJ\u0015\u0010\u0016\u001a\u00020\u00002\b\u0010\u0016\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u001eJ\u0015\u0010\u0017\u001a\u00020\u00002\b\u0010\u0017\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u001eJ\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0019J\u0015\u0010\u001a\u001a\u00020\u00002\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001b\u001a\u00020\u00002\b\u0010\u001b\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\u001c\u001a\u00020\u00002\b\u0010\u001c\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u001d\u001a\u00020\u00002\b\u0010\u001d\u001a\u0004\u0018\u00010\u000bR\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0012\u0010\b\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0012\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/fincast/household/impl/InvestmentAccount$Builder;", "", "()V", "bondInterestRate", "", "Ljava/lang/Double;", "bondPart", "cashInterestRate", "cashPart", "contributionAmount", "contributionEndDate", "Lio/fincast/util/SimDate;", "contributionPeriodicity", "Lio/fincast/enums/Periodicity;", "contributionStartDate", "dividendAllocation", "Lio/fincast/enums/FundsAllocation;", "interestAllocation", "managementFee", "performanceFee", "reconBalance", "stockCapitalGain", "stockDividendYield", "stockPart", "tag", "", "withdrawalAmount", "withdrawalEndDate", "withdrawalPeriodicity", "withdrawalStartDate", "(Ljava/lang/Double;)Lio/fincast/household/impl/InvestmentAccount$Builder;", "build", "Lio/fincast/household/impl/InvestmentAccount;", "fincast"})
    @SourceDebugExtension(value={"SMAP\nInvestmentAccount.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InvestmentAccount.kt\nio/fincast/household/impl/InvestmentAccount$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,238:1\n1#2:239\n*E\n"})
    public static final class Builder {
        @Nullable
        private String tag;
        @Nullable
        private Double reconBalance;
        @Nullable
        private Double contributionAmount;
        @Nullable
        private Periodicity contributionPeriodicity;
        @Nullable
        private SimDate contributionStartDate;
        @Nullable
        private SimDate contributionEndDate;
        @Nullable
        private Double cashPart;
        @Nullable
        private Double bondPart;
        @Nullable
        private Double stockPart;
        @Nullable
        private Double cashInterestRate;
        @Nullable
        private Double bondInterestRate;
        @Nullable
        private FundsAllocation interestAllocation;
        @Nullable
        private Double stockDividendYield;
        @Nullable
        private FundsAllocation dividendAllocation;
        @Nullable
        private Double stockCapitalGain;
        @Nullable
        private Double managementFee;
        @Nullable
        private Double performanceFee;
        @Nullable
        private Double withdrawalAmount;
        @Nullable
        private Periodicity withdrawalPeriodicity;
        @Nullable
        private SimDate withdrawalStartDate;
        @Nullable
        private SimDate withdrawalEndDate;

        @NotNull
        public final Builder tag(@NotNull String tag) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Builder $this$tag_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$tag_u24lambda_u240.tag = tag;
            return builder;
        }

        @NotNull
        public final Builder reconBalance(@Nullable Double reconBalance) {
            Builder builder;
            Builder $this$reconBalance_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$reconBalance_u24lambda_u241.reconBalance = reconBalance;
            return builder;
        }

        @NotNull
        public final Builder contributionAmount(@Nullable Double contributionAmount) {
            Builder builder;
            Builder $this$contributionAmount_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$contributionAmount_u24lambda_u242.contributionAmount = contributionAmount;
            return builder;
        }

        @NotNull
        public final Builder contributionPeriodicity(@Nullable Periodicity contributionPeriodicity) {
            Builder builder;
            Builder $this$contributionPeriodicity_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$contributionPeriodicity_u24lambda_u243.contributionPeriodicity = contributionPeriodicity;
            return builder;
        }

        @NotNull
        public final Builder contributionStartDate(@Nullable SimDate contributionStartDate) {
            Builder builder;
            Builder $this$contributionStartDate_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$contributionStartDate_u24lambda_u244.contributionStartDate = contributionStartDate;
            return builder;
        }

        @NotNull
        public final Builder contributionEndDate(@Nullable SimDate contributionEndDate) {
            Builder builder;
            Builder $this$contributionEndDate_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$contributionEndDate_u24lambda_u245.contributionEndDate = contributionEndDate;
            return builder;
        }

        @NotNull
        public final Builder cashPart(@Nullable Double cashPart) {
            Builder builder;
            Builder $this$cashPart_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$cashPart_u24lambda_u246.cashPart = cashPart;
            return builder;
        }

        @NotNull
        public final Builder bondPart(@Nullable Double bondPart) {
            Builder builder;
            Builder $this$bondPart_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$bondPart_u24lambda_u247.bondPart = bondPart;
            return builder;
        }

        @NotNull
        public final Builder stockPart(@Nullable Double stockPart) {
            Builder builder;
            Builder $this$stockPart_u24lambda_u248 = builder = this;
            boolean bl = false;
            $this$stockPart_u24lambda_u248.stockPart = stockPart;
            return builder;
        }

        @NotNull
        public final Builder cashInterestRate(@Nullable Double cashInterestRate) {
            Builder builder;
            Builder $this$cashInterestRate_u24lambda_u249 = builder = this;
            boolean bl = false;
            $this$cashInterestRate_u24lambda_u249.cashInterestRate = cashInterestRate;
            return builder;
        }

        @NotNull
        public final Builder bondInterestRate(@Nullable Double bondInterestRate) {
            Builder builder;
            Builder $this$bondInterestRate_u24lambda_u2410 = builder = this;
            boolean bl = false;
            $this$bondInterestRate_u24lambda_u2410.bondInterestRate = bondInterestRate;
            return builder;
        }

        @NotNull
        public final Builder interestAllocation(@Nullable FundsAllocation interestAllocation) {
            Builder builder;
            Builder $this$interestAllocation_u24lambda_u2411 = builder = this;
            boolean bl = false;
            $this$interestAllocation_u24lambda_u2411.interestAllocation = interestAllocation;
            return builder;
        }

        @NotNull
        public final Builder stockDividendYield(@Nullable Double stockDividendYield) {
            Builder builder;
            Builder $this$stockDividendYield_u24lambda_u2412 = builder = this;
            boolean bl = false;
            $this$stockDividendYield_u24lambda_u2412.stockDividendYield = stockDividendYield;
            return builder;
        }

        @NotNull
        public final Builder dividendAllocation(@Nullable FundsAllocation dividendAllocation) {
            Builder builder;
            Builder $this$dividendAllocation_u24lambda_u2413 = builder = this;
            boolean bl = false;
            $this$dividendAllocation_u24lambda_u2413.dividendAllocation = dividendAllocation;
            return builder;
        }

        @NotNull
        public final Builder stockCapitalGain(@Nullable Double stockCapitalGain) {
            Builder builder;
            Builder $this$stockCapitalGain_u24lambda_u2414 = builder = this;
            boolean bl = false;
            $this$stockCapitalGain_u24lambda_u2414.stockCapitalGain = stockCapitalGain;
            return builder;
        }

        @NotNull
        public final Builder managementFee(@Nullable Double managementFee) {
            Builder builder;
            Builder $this$managementFee_u24lambda_u2415 = builder = this;
            boolean bl = false;
            $this$managementFee_u24lambda_u2415.managementFee = managementFee;
            return builder;
        }

        @NotNull
        public final Builder performanceFee(@Nullable Double performanceFee) {
            Builder builder;
            Builder $this$performanceFee_u24lambda_u2416 = builder = this;
            boolean bl = false;
            $this$performanceFee_u24lambda_u2416.performanceFee = performanceFee;
            return builder;
        }

        @NotNull
        public final Builder withdrawalAmount(@Nullable Double withdrawalAmount) {
            Builder builder;
            Builder $this$withdrawalAmount_u24lambda_u2417 = builder = this;
            boolean bl = false;
            $this$withdrawalAmount_u24lambda_u2417.withdrawalAmount = withdrawalAmount;
            return builder;
        }

        @NotNull
        public final Builder withdrawalPeriodicity(@Nullable Periodicity withdrawalPeriodicity) {
            Builder builder;
            Builder $this$withdrawalPeriodicity_u24lambda_u2418 = builder = this;
            boolean bl = false;
            $this$withdrawalPeriodicity_u24lambda_u2418.withdrawalPeriodicity = withdrawalPeriodicity;
            return builder;
        }

        @NotNull
        public final Builder withdrawalStartDate(@Nullable SimDate withdrawalStartDate) {
            Builder builder;
            Builder $this$withdrawalStartDate_u24lambda_u2419 = builder = this;
            boolean bl = false;
            $this$withdrawalStartDate_u24lambda_u2419.withdrawalStartDate = withdrawalStartDate;
            return builder;
        }

        @NotNull
        public final Builder withdrawalEndDate(@Nullable SimDate withdrawalEndDate) {
            Builder builder;
            Builder $this$withdrawalEndDate_u24lambda_u2420 = builder = this;
            boolean bl = false;
            $this$withdrawalEndDate_u24lambda_u2420.withdrawalEndDate = withdrawalEndDate;
            return builder;
        }

        @NotNull
        public final InvestmentAccount build() {
            FundsAllocation fundsAllocation;
            String string = this.tag;
            if (string == null) {
                throw new IllegalArgumentException("tag is required");
            }
            Double d = this.reconBalance;
            double d2 = d != null ? d : 0.0;
            Double d3 = this.cashPart;
            double d4 = d3 != null ? d3 : 0.0;
            Double d5 = this.bondPart;
            double d6 = d5 != null ? d5 : 0.0;
            Double d7 = this.stockPart;
            double d8 = d7 != null ? d7 : 0.0;
            FundsAllocation fundsAllocation2 = this.interestAllocation;
            if (fundsAllocation2 == null) {
                fundsAllocation2 = FundsAllocation.COMPOUND;
            }
            if ((fundsAllocation = this.dividendAllocation) == null) {
                fundsAllocation = FundsAllocation.DISBURSE;
            }
            Double d9 = this.managementFee;
            Double d10 = this.performanceFee;
            return new InvestmentAccount(string, d2, this.contributionAmount, this.contributionPeriodicity, this.contributionStartDate, this.contributionEndDate, d4, d6, d8, this.cashInterestRate, this.bondInterestRate, fundsAllocation2, this.stockDividendYield, fundsAllocation, this.stockCapitalGain, d9 != null ? d9 : 0.0, d10 != null ? d10 : 0.0, this.withdrawalAmount, this.withdrawalPeriodicity, this.withdrawalStartDate, this.withdrawalEndDate);
        }
    }
}

