/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.household.impl;

import io.fincast.enums.BookingKind;
import io.fincast.enums.FundsAllocation;
import io.fincast.enums.Periodicity;
import io.fincast.enums.ProductType;
import io.fincast.household.Valuable;
import io.fincast.portfolio.Portfolio;
import io.fincast.portfolio.Position;
import io.fincast.portfolio.PositionCompo;
import io.fincast.portfolio.ValueProviders;
import io.fincast.portfolio.impl.CashflowCompo;
import io.fincast.portfolio.impl.YieldCompo;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u00013BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\f\u001a\u00020\b\u00a2\u0006\u0002\u0010\rJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\bH\u00c6\u0003J\t\u0010!\u001a\u00020\nH\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\bH\u00c6\u0003JO\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u00052\b\b\u0002\u0010\f\u001a\u00020\bH\u00c6\u0001J\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\u0013\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/H\u00d6\u0003J\t\u00100\u001a\u000201H\u00d6\u0001J\t\u00102\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00064"}, d2={"Lio/fincast/household/impl/Asset;", "Lio/fincast/household/Valuable;", "tag", "", "reconBalance", "", "interestRate", "interestPeriodicity", "Lio/fincast/enums/Periodicity;", "interestAllocation", "Lio/fincast/enums/FundsAllocation;", "insuranceRate", "insurancePeriodicity", "(Ljava/lang/String;DDLio/fincast/enums/Periodicity;Lio/fincast/enums/FundsAllocation;DLio/fincast/enums/Periodicity;)V", "getInsurancePeriodicity", "()Lio/fincast/enums/Periodicity;", "getInsuranceRate", "()D", "getInterestAllocation", "()Lio/fincast/enums/FundsAllocation;", "getInterestPeriodicity", "getInterestRate", "productType", "Lio/fincast/enums/ProductType;", "getProductType", "()Lio/fincast/enums/ProductType;", "getReconBalance", "getTag", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "createCompos", "", "Lio/fincast/portfolio/PositionCompo;", "portfolio", "Lio/fincast/portfolio/Portfolio;", "pos", "Lio/fincast/portfolio/Position;", "equals", "", "other", "", "hashCode", "", "toString", "Builder", "fincast"})
public final class Asset
implements Valuable {
    @NotNull
    private final String tag;
    private final double reconBalance;
    private final double interestRate;
    @NotNull
    private final Periodicity interestPeriodicity;
    @NotNull
    private final FundsAllocation interestAllocation;
    private final double insuranceRate;
    @NotNull
    private final Periodicity insurancePeriodicity;
    @NotNull
    private final ProductType productType;

    public Asset(@NotNull String tag, double reconBalance, double interestRate, @NotNull Periodicity interestPeriodicity, @NotNull FundsAllocation interestAllocation, double insuranceRate, @NotNull Periodicity insurancePeriodicity) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)interestPeriodicity), (String)"interestPeriodicity");
        Intrinsics.checkNotNullParameter((Object)((Object)interestAllocation), (String)"interestAllocation");
        Intrinsics.checkNotNullParameter((Object)((Object)insurancePeriodicity), (String)"insurancePeriodicity");
        this.tag = tag;
        this.reconBalance = reconBalance;
        this.interestRate = interestRate;
        this.interestPeriodicity = interestPeriodicity;
        this.interestAllocation = interestAllocation;
        this.insuranceRate = insuranceRate;
        this.insurancePeriodicity = insurancePeriodicity;
        this.productType = ProductType.ASSET;
    }

    public /* synthetic */ Asset(String string, double d, double d2, Periodicity periodicity, FundsAllocation fundsAllocation, double d3, Periodicity periodicity2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = 0.0;
        }
        if ((n & 4) != 0) {
            d2 = 0.0;
        }
        if ((n & 8) != 0) {
            periodicity = Periodicity.YEARLY;
        }
        if ((n & 0x10) != 0) {
            fundsAllocation = FundsAllocation.DISBURSE;
        }
        if ((n & 0x20) != 0) {
            d3 = 0.0;
        }
        if ((n & 0x40) != 0) {
            periodicity2 = Periodicity.YEARLY;
        }
        this(string, d, d2, periodicity, fundsAllocation, d3, periodicity2);
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @Override
    public double getReconBalance() {
        return this.reconBalance;
    }

    public final double getInterestRate() {
        return this.interestRate;
    }

    @NotNull
    public final Periodicity getInterestPeriodicity() {
        return this.interestPeriodicity;
    }

    @NotNull
    public final FundsAllocation getInterestAllocation() {
        return this.interestAllocation;
    }

    public final double getInsuranceRate() {
        return this.insuranceRate;
    }

    @NotNull
    public final Periodicity getInsurancePeriodicity() {
        return this.insurancePeriodicity;
    }

    @Override
    @NotNull
    public ProductType getProductType() {
        return this.productType;
    }

    @Override
    @NotNull
    public List<PositionCompo> createCompos(@NotNull Portfolio portfolio, @NotNull Position pos) {
        Intrinsics.checkNotNullParameter((Object)portfolio, (String)"portfolio");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        List compos = new ArrayList();
        if (!(this.interestRate == 0.0)) {
            compos.add(new YieldCompo(pos, "interest", ValueProviders.eomBalance(pos), ValueProviders.constValue(this.interestRate), Periodicity.YEARLY, BookingKind.INTEREST, this.interestAllocation));
        }
        if (!(this.insuranceRate == 0.0)) {
            compos.add(new CashflowCompo(pos, "insurance", FundsAllocation.DISBURSE, ValueProviders.constValue(this.insuranceRate / 100.0 * this.getReconBalance()), -1, this.insurancePeriodicity, null, null, false, 448, null));
        }
        return compos;
    }

    @Override
    @NotNull
    public Position createPosition(@NotNull Portfolio portfolio) {
        return Valuable.DefaultImpls.createPosition(this, portfolio);
    }

    @NotNull
    public final String component1() {
        return this.tag;
    }

    public final double component2() {
        return this.reconBalance;
    }

    public final double component3() {
        return this.interestRate;
    }

    @NotNull
    public final Periodicity component4() {
        return this.interestPeriodicity;
    }

    @NotNull
    public final FundsAllocation component5() {
        return this.interestAllocation;
    }

    public final double component6() {
        return this.insuranceRate;
    }

    @NotNull
    public final Periodicity component7() {
        return this.insurancePeriodicity;
    }

    @NotNull
    public final Asset copy(@NotNull String tag, double reconBalance, double interestRate, @NotNull Periodicity interestPeriodicity, @NotNull FundsAllocation interestAllocation, double insuranceRate, @NotNull Periodicity insurancePeriodicity) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)interestPeriodicity), (String)"interestPeriodicity");
        Intrinsics.checkNotNullParameter((Object)((Object)interestAllocation), (String)"interestAllocation");
        Intrinsics.checkNotNullParameter((Object)((Object)insurancePeriodicity), (String)"insurancePeriodicity");
        return new Asset(tag, reconBalance, interestRate, interestPeriodicity, interestAllocation, insuranceRate, insurancePeriodicity);
    }

    public static /* synthetic */ Asset copy$default(Asset asset, String string, double d, double d2, Periodicity periodicity, FundsAllocation fundsAllocation, double d3, Periodicity periodicity2, int n, Object object) {
        if ((n & 1) != 0) {
            string = asset.tag;
        }
        if ((n & 2) != 0) {
            d = asset.reconBalance;
        }
        if ((n & 4) != 0) {
            d2 = asset.interestRate;
        }
        if ((n & 8) != 0) {
            periodicity = asset.interestPeriodicity;
        }
        if ((n & 0x10) != 0) {
            fundsAllocation = asset.interestAllocation;
        }
        if ((n & 0x20) != 0) {
            d3 = asset.insuranceRate;
        }
        if ((n & 0x40) != 0) {
            periodicity2 = asset.insurancePeriodicity;
        }
        return asset.copy(string, d, d2, periodicity, fundsAllocation, d3, periodicity2);
    }

    @NotNull
    public String toString() {
        return "Asset(tag=" + this.tag + ", reconBalance=" + this.reconBalance + ", interestRate=" + this.interestRate + ", interestPeriodicity=" + this.interestPeriodicity + ", interestAllocation=" + this.interestAllocation + ", insuranceRate=" + this.insuranceRate + ", insurancePeriodicity=" + this.insurancePeriodicity + ")";
    }

    public int hashCode() {
        int result = this.tag.hashCode();
        result = result * 31 + Double.hashCode(this.reconBalance);
        result = result * 31 + Double.hashCode(this.interestRate);
        result = result * 31 + this.interestPeriodicity.hashCode();
        result = result * 31 + this.interestAllocation.hashCode();
        result = result * 31 + Double.hashCode(this.insuranceRate);
        result = result * 31 + this.insurancePeriodicity.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Asset)) {
            return false;
        }
        Asset asset = (Asset)other;
        if (!Intrinsics.areEqual((Object)this.tag, (Object)asset.tag)) {
            return false;
        }
        if (Double.compare(this.reconBalance, asset.reconBalance) != 0) {
            return false;
        }
        if (Double.compare(this.interestRate, asset.interestRate) != 0) {
            return false;
        }
        if (this.interestPeriodicity != asset.interestPeriodicity) {
            return false;
        }
        if (this.interestAllocation != asset.interestAllocation) {
            return false;
        }
        if (Double.compare(this.insuranceRate, asset.insuranceRate) != 0) {
            return false;
        }
        return this.insurancePeriodicity == asset.insurancePeriodicity;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0003\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\u0015\u0010\u0005\u001a\u00020\u00002\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\b\u001a\u00020\u00002\b\u0010\u0012\u001a\u0004\u0018\u00010\tJ\u0010\u0010\n\u001a\u00020\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u0004J\u0015\u0010\u000b\u001a\u00020\u00002\b\u0010\u000b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\f\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0012\u0010\f\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/fincast/household/impl/Asset$Builder;", "", "()V", "insurancePeriodicity", "Lio/fincast/enums/Periodicity;", "insuranceRate", "", "Ljava/lang/Double;", "interestAllocation", "Lio/fincast/enums/FundsAllocation;", "interestPeriodicity", "interestRate", "reconBalance", "tag", "", "build", "Lio/fincast/household/impl/Asset;", "(Ljava/lang/Double;)Lio/fincast/household/impl/Asset$Builder;", "fundsAllocation", "fincast"})
    @SourceDebugExtension(value={"SMAP\nAsset.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Asset.kt\nio/fincast/household/impl/Asset$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1#2:88\n*E\n"})
    public static final class Builder {
        @Nullable
        private String tag;
        @Nullable
        private Double reconBalance;
        @Nullable
        private Double interestRate;
        @Nullable
        private Periodicity interestPeriodicity;
        @Nullable
        private FundsAllocation interestAllocation;
        @Nullable
        private Double insuranceRate;
        @Nullable
        private Periodicity insurancePeriodicity;

        @NotNull
        public final Builder tag(@NotNull String tag) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Builder $this$tag_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$tag_u24lambda_u240.tag = tag;
            return builder;
        }

        @NotNull
        public final Builder reconBalance(@Nullable Double reconBalance) {
            Builder builder;
            Builder $this$reconBalance_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$reconBalance_u24lambda_u241.reconBalance = reconBalance;
            return builder;
        }

        @NotNull
        public final Builder interestRate(@Nullable Double interestRate) {
            Builder builder;
            Builder $this$interestRate_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$interestRate_u24lambda_u242.interestRate = interestRate;
            return builder;
        }

        @NotNull
        public final Builder interestPeriodicity(@Nullable Periodicity interestPeriodicity) {
            Builder builder;
            Builder $this$interestPeriodicity_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$interestPeriodicity_u24lambda_u243.interestPeriodicity = interestPeriodicity;
            return builder;
        }

        @NotNull
        public final Builder interestAllocation(@Nullable FundsAllocation fundsAllocation) {
            Builder builder;
            Builder $this$interestAllocation_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$interestAllocation_u24lambda_u244.interestAllocation = fundsAllocation;
            return builder;
        }

        @NotNull
        public final Builder insuranceRate(@Nullable Double insuranceRate) {
            Builder builder;
            Builder $this$insuranceRate_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$insuranceRate_u24lambda_u245.insuranceRate = insuranceRate;
            return builder;
        }

        @NotNull
        public final Builder insurancePeriodicity(@Nullable Periodicity insurancePeriodicity) {
            Builder builder;
            Builder $this$insurancePeriodicity_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$insurancePeriodicity_u24lambda_u246.insurancePeriodicity = insurancePeriodicity;
            return builder;
        }

        @NotNull
        public final Asset build() {
            FundsAllocation fundsAllocation;
            String string = this.tag;
            if (string == null) {
                throw new IllegalArgumentException("tag is required");
            }
            Double d = this.reconBalance;
            double d2 = d != null ? d : 0.0;
            Double d3 = this.interestRate;
            double d4 = d3 != null ? d3 : 0.0;
            Periodicity periodicity = this.interestPeriodicity;
            if (periodicity == null) {
                periodicity = Periodicity.YEARLY;
            }
            if ((fundsAllocation = this.interestAllocation) == null) {
                fundsAllocation = FundsAllocation.DISBURSE;
            }
            Double d5 = this.insuranceRate;
            double d6 = d5 != null ? d5 : 0.0;
            Periodicity periodicity2 = this.insurancePeriodicity;
            if (periodicity2 == null) {
                periodicity2 = Periodicity.YEARLY;
            }
            return new Asset(string, d2, d4, periodicity, fundsAllocation, d6, periodicity2);
        }
    }
}

