/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.household;

import io.fincast.enums.BookingKind;
import io.fincast.household.Booking;
import io.fincast.household.Holding;
import io.fincast.util.SimDate;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lio/fincast/household/ReconciliationBooking;", "Lio/fincast/household/Booking;", "holding", "Lio/fincast/household/Holding;", "date", "Lio/fincast/util/SimDate;", "amount", "", "(Lio/fincast/household/Holding;Lio/fincast/util/SimDate;D)V", "getAmount", "()D", "bookingKind", "Lio/fincast/enums/BookingKind;", "getBookingKind", "()Lio/fincast/enums/BookingKind;", "getDate", "()Lio/fincast/util/SimDate;", "getHolding", "()Lio/fincast/household/Holding;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "fincast"})
public final class ReconciliationBooking
implements Booking {
    @NotNull
    private final Holding holding;
    @NotNull
    private final SimDate date;
    private final double amount;
    @NotNull
    private final BookingKind bookingKind;

    public ReconciliationBooking(@NotNull Holding holding, @NotNull SimDate date, double amount) {
        Intrinsics.checkNotNullParameter((Object)holding, (String)"holding");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        this.holding = holding;
        this.date = date;
        this.amount = amount;
        this.bookingKind = BookingKind.RECONCILE;
    }

    @Override
    @NotNull
    public Holding getHolding() {
        return this.holding;
    }

    @Override
    @NotNull
    public SimDate getDate() {
        return this.date;
    }

    @Override
    public double getAmount() {
        return this.amount;
    }

    @Override
    @NotNull
    public BookingKind getBookingKind() {
        return this.bookingKind;
    }

    @NotNull
    public String toString() {
        SimDate simDate = this.getDate();
        String string = this.getBookingKind().getCode();
        String string2 = this.getHolding().getTag();
        String string3 = "%.0f";
        Object[] objectArray = new Object[]{this.getAmount()};
        String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
        return simDate + ": " + string + " " + string2 + " " + string4;
    }

    @NotNull
    public final Holding component1() {
        return this.holding;
    }

    @NotNull
    public final SimDate component2() {
        return this.date;
    }

    public final double component3() {
        return this.amount;
    }

    @NotNull
    public final ReconciliationBooking copy(@NotNull Holding holding, @NotNull SimDate date, double amount) {
        Intrinsics.checkNotNullParameter((Object)holding, (String)"holding");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return new ReconciliationBooking(holding, date, amount);
    }

    public static /* synthetic */ ReconciliationBooking copy$default(ReconciliationBooking reconciliationBooking, Holding holding, SimDate simDate, double d, int n, Object object) {
        if ((n & 1) != 0) {
            holding = reconciliationBooking.holding;
        }
        if ((n & 2) != 0) {
            simDate = reconciliationBooking.date;
        }
        if ((n & 4) != 0) {
            d = reconciliationBooking.amount;
        }
        return reconciliationBooking.copy(holding, simDate, d);
    }

    public int hashCode() {
        int result = this.holding.hashCode();
        result = result * 31 + this.date.hashCode();
        result = result * 31 + Double.hashCode(this.amount);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ReconciliationBooking)) {
            return false;
        }
        ReconciliationBooking reconciliationBooking = (ReconciliationBooking)other;
        if (!Intrinsics.areEqual((Object)this.holding, (Object)reconciliationBooking.holding)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.date, (Object)reconciliationBooking.date)) {
            return false;
        }
        return Double.compare(this.amount, reconciliationBooking.amount) == 0;
    }
}

