/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.household;

import io.fincast.enums.Periodicity;
import io.fincast.household.Holding;
import io.fincast.household.Person;
import io.fincast.household.ProjectionResult;
import io.fincast.household.impl.HouseholdImpl;
import io.fincast.portfolio.Portfolio;
import io.fincast.util.SimDate;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001c\u001dJ\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00142\b\b\u0002\u0010\u001a\u001a\u00020\u001bH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\tR\u0012\u0010\r\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0005R\u0012\u0010\u000f\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001e"}, d2={"Lio/fincast/household/Household;", "", "externalMoney", "Lio/fincast/household/Holding;", "getExternalMoney", "()Lio/fincast/household/Holding;", "holdings", "", "getHoldings", "()Ljava/util/List;", "persons", "Lio/fincast/household/Person;", "getPersons", "pocketMoney", "getPocketMoney", "portfolio", "Lio/fincast/portfolio/Portfolio;", "getPortfolio", "()Lio/fincast/portfolio/Portfolio;", "reconDate", "Lio/fincast/util/SimDate;", "getReconDate", "()Lio/fincast/util/SimDate;", "calcProjection", "Lio/fincast/household/ProjectionResult;", "endDate", "periodicity", "Lio/fincast/enums/Periodicity;", "Builder", "Companion", "fincast"})
public interface Household {
    @NotNull
    public static final Companion Companion = io.fincast.household.Household$Companion.$$INSTANCE;
    @NotNull
    public static final String POCKET_MONEY_TAG = "#pocketMoney";
    @NotNull
    public static final String EXTERNAL_MONEY_TAG = "#externalMoney";

    @NotNull
    public List<Person> getPersons();

    @NotNull
    public SimDate getReconDate();

    @NotNull
    public List<Holding> getHoldings();

    @NotNull
    public Holding getPocketMoney();

    @NotNull
    public Holding getExternalMoney();

    @NotNull
    public Portfolio getPortfolio();

    @NotNull
    public ProjectionResult calcProjection(@NotNull SimDate var1, @NotNull Periodicity var2);

    @JvmStatic
    @NotNull
    public static Household createHousehold(@NotNull List<? extends Person> persons, @NotNull SimDate reconDate, @NotNull List<? extends Holding> holdings) {
        return Companion.createHousehold(persons, reconDate, holdings);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\u0003\u001a\u00020\u00002\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u0014\u0010\u0006\u001a\u00020\u00002\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/fincast/household/Household$Builder;", "", "()V", "holdings", "", "Lio/fincast/household/Holding;", "persons", "Lio/fincast/household/Person;", "reconDate", "Lio/fincast/util/SimDate;", "build", "Lio/fincast/household/Household;", "fincast"})
    @SourceDebugExtension(value={"SMAP\nHousehold.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Household.kt\nio/fincast/household/Household$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1#2:58\n*E\n"})
    public static final class Builder {
        @NotNull
        private List<? extends Person> persons = CollectionsKt.emptyList();
        @Nullable
        private SimDate reconDate;
        @NotNull
        private List<? extends Holding> holdings = CollectionsKt.emptyList();

        @NotNull
        public final Builder persons(@NotNull List<? extends Person> persons) {
            Builder builder;
            Intrinsics.checkNotNullParameter(persons, (String)"persons");
            Builder $this$persons_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$persons_u24lambda_u240.persons = persons;
            return builder;
        }

        @NotNull
        public final Builder reconDate(@NotNull SimDate reconDate) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)reconDate, (String)"reconDate");
            Builder $this$reconDate_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$reconDate_u24lambda_u241.reconDate = reconDate;
            return builder;
        }

        @NotNull
        public final Builder holdings(@NotNull List<? extends Holding> holdings) {
            Builder builder;
            Intrinsics.checkNotNullParameter(holdings, (String)"holdings");
            Builder $this$holdings_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$holdings_u24lambda_u242.holdings = holdings;
            return builder;
        }

        @NotNull
        public final Household build() {
            SimDate simDate = this.reconDate;
            if (simDate == null) {
                throw new IllegalArgumentException("reconDate is required");
            }
            return new HouseholdImpl(this.persons, simDate, this.holdings);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\tH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/fincast/household/Household$Companion;", "", "()V", "EXTERNAL_MONEY_TAG", "", "POCKET_MONEY_TAG", "createHousehold", "Lio/fincast/household/Household;", "persons", "", "Lio/fincast/household/Person;", "reconDate", "Lio/fincast/util/SimDate;", "holdings", "Lio/fincast/household/Holding;", "fincast"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        public static final String POCKET_MONEY_TAG = "#pocketMoney";
        @NotNull
        public static final String EXTERNAL_MONEY_TAG = "#externalMoney";

        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Household createHousehold(@NotNull List<? extends Person> persons, @NotNull SimDate reconDate, @NotNull List<? extends Holding> holdings) {
            Intrinsics.checkNotNullParameter(persons, (String)"persons");
            Intrinsics.checkNotNullParameter((Object)reconDate, (String)"reconDate");
            Intrinsics.checkNotNullParameter(holdings, (String)"holdings");
            return new Builder().persons(persons).reconDate(reconDate).holdings(holdings).build();
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static /* synthetic */ ProjectionResult calcProjection$default(Household household, SimDate simDate, Periodicity periodicity, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: calcProjection");
            }
            if ((n & 2) != 0) {
                periodicity = Periodicity.MONTHLY;
            }
            return household.calcProjection(simDate, periodicity);
        }
    }
}

