/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.household;

import io.fincast.household.Aggregate;
import io.fincast.util.SimDate;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003JE\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\b\u0010\"\u001a\u00020\u0005H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\r\u00a8\u0006#"}, d2={"Lio/fincast/household/CategoryPeriod;", "Lio/fincast/household/Aggregate;", "date", "Lio/fincast/util/SimDate;", "category", "", "assets", "", "liabilities", "income", "expense", "(Lio/fincast/util/SimDate;Ljava/lang/String;DDDD)V", "getAssets", "()D", "getCategory", "()Ljava/lang/String;", "getDate", "()Lio/fincast/util/SimDate;", "getExpense", "getIncome", "getLiabilities", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "", "hashCode", "", "toString", "fincast"})
public final class CategoryPeriod
implements Aggregate {
    @NotNull
    private final SimDate date;
    @NotNull
    private final String category;
    private final double assets;
    private final double liabilities;
    private final double income;
    private final double expense;

    public CategoryPeriod(@NotNull SimDate date, @NotNull String category, double assets, double liabilities, double income, double expense) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        this.date = date;
        this.category = category;
        this.assets = assets;
        this.liabilities = liabilities;
        this.income = income;
        this.expense = expense;
    }

    @Override
    @NotNull
    public SimDate getDate() {
        return this.date;
    }

    @NotNull
    public final String getCategory() {
        return this.category;
    }

    public final double getAssets() {
        return this.assets;
    }

    public final double getLiabilities() {
        return this.liabilities;
    }

    public final double getIncome() {
        return this.income;
    }

    public final double getExpense() {
        return this.expense;
    }

    @NotNull
    public String toString() {
        SimDate simDate = this.getDate();
        String string = "%.0f";
        Object[] objectArray = new Object[]{this.assets};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        string = "%.0f";
        objectArray = new Object[]{this.liabilities};
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
        string = "%.0f";
        objectArray = new Object[]{this.income};
        String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
        string = "%.0f";
        objectArray = new Object[]{this.expense};
        String string5 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(format, *args)");
        return simDate + ": Cat " + this.category + " " + string2 + " " + string3 + " " + string4 + " " + string5;
    }

    @NotNull
    public final SimDate component1() {
        return this.date;
    }

    @NotNull
    public final String component2() {
        return this.category;
    }

    public final double component3() {
        return this.assets;
    }

    public final double component4() {
        return this.liabilities;
    }

    public final double component5() {
        return this.income;
    }

    public final double component6() {
        return this.expense;
    }

    @NotNull
    public final CategoryPeriod copy(@NotNull SimDate date, @NotNull String category, double assets, double liabilities, double income, double expense) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        return new CategoryPeriod(date, category, assets, liabilities, income, expense);
    }

    public static /* synthetic */ CategoryPeriod copy$default(CategoryPeriod categoryPeriod, SimDate simDate, String string, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 1) != 0) {
            simDate = categoryPeriod.date;
        }
        if ((n & 2) != 0) {
            string = categoryPeriod.category;
        }
        if ((n & 4) != 0) {
            d = categoryPeriod.assets;
        }
        if ((n & 8) != 0) {
            d2 = categoryPeriod.liabilities;
        }
        if ((n & 0x10) != 0) {
            d3 = categoryPeriod.income;
        }
        if ((n & 0x20) != 0) {
            d4 = categoryPeriod.expense;
        }
        return categoryPeriod.copy(simDate, string, d, d2, d3, d4);
    }

    public int hashCode() {
        int result = this.date.hashCode();
        result = result * 31 + this.category.hashCode();
        result = result * 31 + Double.hashCode(this.assets);
        result = result * 31 + Double.hashCode(this.liabilities);
        result = result * 31 + Double.hashCode(this.income);
        result = result * 31 + Double.hashCode(this.expense);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CategoryPeriod)) {
            return false;
        }
        CategoryPeriod categoryPeriod = (CategoryPeriod)other;
        if (!Intrinsics.areEqual((Object)this.date, (Object)categoryPeriod.date)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.category, (Object)categoryPeriod.category)) {
            return false;
        }
        if (Double.compare(this.assets, categoryPeriod.assets) != 0) {
            return false;
        }
        if (Double.compare(this.liabilities, categoryPeriod.liabilities) != 0) {
            return false;
        }
        if (Double.compare(this.income, categoryPeriod.income) != 0) {
            return false;
        }
        return Double.compare(this.expense, categoryPeriod.expense) == 0;
    }
}

